/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.inventory.ingredient;

import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IRecipeIngredient;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class IngredientOreDict
implements IRecipeIngredient {
    private final String oreName;
    private final int amount;
    private List<ItemStack> stacks;

    IngredientOreDict(@Nonnull String oreName) {
        this(oreName, 1);
    }

    IngredientOreDict(@Nonnull String oreName, int amount) {
        this.oreName = oreName;
        this.amount = amount;
        this.stacks = null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.oreName;
    }

    @Override
    @Nonnull
    public List<ItemStack> getStacks() {
        if (this.stacks == null) {
            this.stacks = OreDictionary.getOres((String)this.oreName, (boolean)false).stream().map(ItemStack::func_77946_l).peek(x -> x.func_190920_e(this.amount)).collect(Collectors.toList());
        }
        return this.stacks;
    }

    @Override
    public boolean test(Object obj) {
        return this.testIgnoreCount(obj) && ((ItemStack)obj).func_190916_E() >= this.amount;
    }

    @Override
    public boolean testIgnoreCount(Object obj) {
        return obj instanceof ItemStack && CoreHelpers.doesStackMatchOre((ItemStack)obj, this.oreName);
    }

    @Override
    public boolean matches(IRecipeIngredient other) {
        return other instanceof IngredientOreDict && ((IngredientOreDict)other).oreName.equals(this.oreName);
    }
}

