/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching;

import com.alcatrazescapee.alcatrazcore.util.RegistryHelper;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.common.capability.CapabilityPlayerItem;
import com.alcatrazescapee.notreepunching.common.capability.IPlayerItem;
import com.alcatrazescapee.notreepunching.common.recipe.ModRecipes;
import com.alcatrazescapee.notreepunching.util.HarvestBlockHandler;
import com.alcatrazescapee.notreepunching.util.PlayerInteractionHandler;
import com.alcatrazescapee.notreepunching.util.WoodRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="notreepunching")
public final class ModEventHandler {
    @SubscribeEvent
    public static void breakEvent(BlockEvent.BreakEvent event) {
        IPlayerItem cap;
        EntityPlayer player = event.getPlayer();
        if (player != null && (cap = (IPlayerItem)player.getCapability(CapabilityPlayerItem.CAPABILITY, null)) != null) {
            cap.setStack(player.func_184614_ca());
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        IBlockState state;
        ItemStack stack;
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && !(player instanceof FakePlayer) && !player.func_184812_l_() && ModConfig.GENERAL.enableBreakingChanges && HarvestBlockHandler.isInvalidTool(stack = player.func_184614_ca(), player, state = event.getState())) {
            String toolClass = state.func_177230_c().getHarvestTool(state);
            event.setNewSpeed(event.getOriginalSpeed() * HarvestBlockHandler.getSpeedModifier(toolClass == null ? "" : toolClass));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (!event.getWorld().field_72995_K && player != null && !(player instanceof FakePlayer) && !player.func_184812_l_() && ModConfig.GENERAL.enableBreakingChanges) {
            IBlockState state = event.getState();
            IPlayerItem cap = (IPlayerItem)player.getCapability(CapabilityPlayerItem.CAPABILITY, null);
            ItemStack stack = ItemStack.field_190927_a;
            if (cap != null) {
                stack = cap.getStack();
            }
            if (stack.func_190926_b()) {
                stack = player.func_184614_ca();
            }
            HarvestBlockHandler.addExtraDrops(event.getDrops(), state, player, stack, event.isSilkTouching());
            if (HarvestBlockHandler.isInvalidTool(stack, player, state)) {
                event.getDrops().clear();
            }
        }
    }

    @SubscribeEvent
    public static void playerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (event.getHand() == EnumHand.OFF_HAND) {
            ItemStack mainStack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (PlayerInteractionHandler.hasAction(event.getWorld(), event.getPos(), mainStack, event.getFace())) {
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
        if (PlayerInteractionHandler.hasAction(event.getWorld(), event.getPos(), stack, event.getFace()) && PlayerInteractionHandler.performAction(event.getWorld(), event.getPos(), player, stack, event.getFace(), event.getHand())) {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.registerRecipes(event);
        WoodRecipeHandler.registerRecipes(event);
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CapabilityPlayerItem.KEY, (ICapabilityProvider)new CapabilityPlayerItem.Instance());
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        RegistryHelper.get((String)"notreepunching").initItems(event);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryHelper.get((String)"notreepunching").initBlocks(event);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        RegistryHelper.get((String)"notreepunching").initSounds(event);
    }

    @SubscribeEvent
    public void harvestBlockInitialCheck(PlayerEvent.HarvestCheck event) {
        if (HarvestBlockHandler.isWhitelisted(event.getTargetBlock())) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("notreepunching")) {
            ConfigManager.sync((String)"notreepunching", (Config.Type)Config.Type.INSTANCE);
            HarvestBlockHandler.reloadWhitelist();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        RegistryHelper.get((String)"notreepunching").initModels(event);
    }
}

