/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.integration.guide.utils;

import amerifrance.guideapi.api.IRecipeRenderer;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.reciperenderer.ShapedOreRecipeRenderer;
import amerifrance.guideapi.page.reciperenderer.ShapedRecipesRenderer;
import amerifrance.guideapi.page.reciperenderer.ShapelessOreRecipeRenderer;
import amerifrance.guideapi.page.reciperenderer.ShapelessRecipesRenderer;
import com.alcatrazescapee.notreepunching.NoTreePunching;
import com.alcatrazescapee.notreepunching.integration.guide.utils.ILazyLoader;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PageIRecipeLazy
extends PageIRecipe
implements ILazyLoader {
    private final ResourceLocation recipeLookup;

    private static IRecipeRenderer getRenderer(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return new ShapedRecipesRenderer((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapelessRecipes) {
            return new ShapelessRecipesRenderer((ShapelessRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return new ShapedOreRecipeRenderer((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            return new ShapelessOreRecipeRenderer((ShapelessOreRecipe)recipe);
        }
        NoTreePunching.getLog().info("Couldn't get renderer!!! Problem!!!");
        return null;
    }

    public PageIRecipeLazy(ResourceLocation recipeLookup) {
        super(null, null);
        this.recipeLookup = recipeLookup;
    }

    @Override
    public void loadPost() {
        this.recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(this.recipeLookup);
        this.iRecipeRenderer = PageIRecipeLazy.getRenderer(this.recipe);
        this.isValid = this.recipe != null && this.iRecipeRenderer != null;
    }
}

