/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Config {
    public static final ServerConfig SERVER;
    public static final CommonConfig COMMON;
    private static final ForgeConfigSpec SERVER_SPEC;
    private static final ForgeConfigSpec COMMON_SPEC;
    private static final Logger LOGGER;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    static {
        LOGGER = LogManager.getLogger();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(x$0 -> new ServerConfig((ForgeConfigSpec.Builder)x$0));
        Pair commonPair = new ForgeConfigSpec.Builder().configure(x$0 -> new CommonConfig((ForgeConfigSpec.Builder)x$0));
        SERVER_SPEC = (ForgeConfigSpec)serverPair.getRight();
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)serverPair.getLeft();
        COMMON = (CommonConfig)commonPair.getLeft();
    }

    public static final class CommonConfig {
        public final ForgeConfigSpec.BooleanValue enableLooseRockSpawning;
        public final ForgeConfigSpec.IntValue looseRockFrequency;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            this.enableLooseRockSpawning = builder.comment("Enable loose rock spawning. Note: this requires a MC restart to take effect.").define("enableLooseRockSpawning", true);
            this.looseRockFrequency = builder.comment("How common loose rocks are.  Note: this requires a MC restart to take effect.").defineInRange("looseRockFrequency", 12, 0, Integer.MAX_VALUE);
        }
    }

    public static final class ServerConfig {
        public final ForgeConfigSpec.BooleanValue noMiningWithoutCorrectTool;
        public final ForgeConfigSpec.BooleanValue noBlockDropsWithoutCorrectTool;
        public final ForgeConfigSpec.BooleanValue doInstantBreakBlocksRequireTool;
        public final ForgeConfigSpec.DoubleValue flintKnappingConsumeChance;
        public final ForgeConfigSpec.DoubleValue flintKnappingSuccessChance;
        public final ForgeConfigSpec.DoubleValue fireStarterFireStartChance;

        private ServerConfig(ForgeConfigSpec.Builder builder) {
            this.noMiningWithoutCorrectTool = builder.comment("Makes blocks take forever to mine if using the wrong tool").define("noMiningWithoutCorrectTool", true);
            this.noBlockDropsWithoutCorrectTool = builder.comment("Makes blocks not drop anything when broken with the wrong tool").define("noBlockDropsWithoutCorrectTool", true);
            this.doInstantBreakBlocksRequireTool = builder.comment("Makes blocks that would otherwise be broken instantly unbreakable if using the wrong tool.").define("doInstantBreakBlocksRequireTool", false);
            this.flintKnappingConsumeChance = builder.comment("The chance to consume a piece of flint when knapping").defineInRange("flintKnappingConsumeChance", 0.4, 0.0, 1.0);
            this.flintKnappingSuccessChance = builder.comment("The chance to produce flint shards if a piece of flint has been consumed while knapping").defineInRange("flintKnappingSuccessChance", 0.7, 0.0, 1.0);
            this.fireStarterFireStartChance = builder.comment("The chance for a fire starter to start fires").defineInRange("fireStarterFireStartChance", 0.3, 0.0, 1.0);
        }
    }
}

