/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching;

import com.alcatrazescapee.notreepunching.Config;
import com.alcatrazescapee.notreepunching.client.ModSounds;
import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.util.MaterialHacks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="notreepunching", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventHandler {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        boolean canHarvest = event.canHarvest();
        canHarvest = ModTags.Blocks.ALWAYS_DROPS.func_199685_a_((Object)event.getTargetBlock().func_177230_c()) ? true : (((Boolean)Config.SERVER.noBlockDropsWithoutCorrectTool.get()).booleanValue() ? (canHarvest |= MaterialHacks.canHarvest(event.getTargetBlock(), event.getPlayer())) : (canHarvest |= MaterialHacks.doesMaterialRequireNoToolByDefault(event.getTargetBlock().func_185904_a())));
        event.setCanHarvest(canHarvest);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (((Boolean)Config.SERVER.noMiningWithoutCorrectTool.get()).booleanValue() && !MaterialHacks.canHarvest(event.getState(), event.getPlayer()) && !ModTags.Blocks.ALWAYS_BREAKABLE.func_199685_a_((Object)event.getState().func_177230_c())) {
            float newSpeed = (Boolean)Config.SERVER.doInstantBreakBlocksRequireTool.get() != false ? 0.0f : 1.0E-10f;
            event.setNewSpeed(newSpeed);
        }
    }

    @SubscribeEvent
    public static void playerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        if (ModTags.Items.FLINT_KNAPPABLE.func_199685_a_((Object)stack.func_77973_b()) && state.func_185904_a() == Material.field_151576_e) {
            if (!world.field_72995_K) {
                if ((double)RANDOM.nextFloat() < (Double)Config.SERVER.flintKnappingConsumeChance.get()) {
                    if ((double)RANDOM.nextFloat() < (Double)Config.SERVER.flintKnappingSuccessChance.get()) {
                        Direction face = event.getFace() == null ? Direction.UP : event.getFace();
                        InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.5), (double)((double)pos.func_177956_o() + 0.5 + (double)face.func_96559_d() * 0.5), (double)((double)pos.func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.5), (ItemStack)new ItemStack((IItemProvider)ModItems.FLINT_SHARD.get(), 2));
                    }
                    stack.func_190918_g(1);
                    event.getPlayer().func_184611_a(event.getHand(), stack);
                }
                world.func_184133_a(null, pos, (SoundEvent)ModSounds.KNAPPING.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }
}

