/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching;

import com.alcatrazescapee.notreepunching.Config;
import com.alcatrazescapee.notreepunching.client.ModSounds;
import com.alcatrazescapee.notreepunching.common.blocks.ModBlocks;
import com.alcatrazescapee.notreepunching.common.container.ModContainers;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.common.tileentity.ModTileEntities;
import com.alcatrazescapee.notreepunching.util.MaterialHacks;
import com.alcatrazescapee.notreepunching.world.LooseRocksFeature;
import com.alcatrazescapee.notreepunching.world.ModFeatures;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="notreepunching")
public final class NoTreePunching {
    public static final String MOD_ID = "notreepunching";
    private static final Logger LOGGER = LogManager.getLogger();

    public NoTreePunching() {
        LOGGER.info("Hello No Tree Punching!");
        LOGGER.debug("If you can see this, debug logging is working.");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModTileEntities.TILE_ENTITIES.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        Config.init();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setup");
        MaterialHacks.setup();
        DeferredWorkQueue.runLater(() -> {
            if (((Boolean)Config.COMMON.enableLooseRockSpawning.get()).booleanValue()) {
                for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((LooseRocksFeature)ModFeatures.LOOSE_ROCKS.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(((Integer)Config.COMMON.looseRockFrequency.get()).intValue()))));
                }
            }
        });
    }
}

