/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.notreepunching.common.tileentity.InventoryTileEntity;
import com.alcatrazescapee.notreepunching.common.tileentity.LargeVesselTileEntity;
import com.alcatrazescapee.notreepunching.util.Helpers;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class LargeVesselBlock
extends Block {
    private static final VoxelShape SHAPE = LargeVesselBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    public LargeVesselBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_200943_b(1.0f));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LargeVesselTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        Helpers.getTE((IBlockReader)worldIn, pos, InventoryTileEntity.class).ifPresent(tile -> {
            tile.onReplaced();
            worldIn.func_175666_e(pos, (Block)this);
        });
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity && !player.func_225608_bj_()) {
            Helpers.getTE((IBlockReader)worldIn, pos, LargeVesselTileEntity.class).ifPresent(tile -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (stack.func_82837_s()) {
            Helpers.getTE((IBlockReader)worldIn, pos, LargeVesselTileEntity.class).ifPresent(tile -> tile.setCustomName(stack.func_200301_q()));
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        Helpers.getTE((IBlockReader)worldIn, pos, LargeVesselTileEntity.class).ifPresent(tile -> tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (!worldIn.field_72995_K && player.func_184812_l_() && !tile.isEmpty()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                CompoundNBT compoundnbt = tile.func_189515_b(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    stack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                stack.func_200302_a(tile.func_145748_c_());
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                itemEntity.func_174869_p();
                worldIn.func_217376_c((Entity)itemEntity);
            }
        }));
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        Helpers.getTE(world, pos, LargeVesselTileEntity.class).ifPresent(tile -> {
            CompoundNBT nbt = tile.func_189515_b(new CompoundNBT());
            if (!nbt.isEmpty()) {
                stack.func_77983_a("BlockEntityTag", (INBT)nbt);
            }
        });
        return stack;
    }
}

