/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.notreepunching.common.ModItemGroup;
import com.alcatrazescapee.notreepunching.common.blocks.LargeVesselBlock;
import com.alcatrazescapee.notreepunching.common.blocks.LooseRockBlock;
import com.alcatrazescapee.notreepunching.common.blocks.PotteryBlock;
import com.alcatrazescapee.notreepunching.common.items.LargeVesselBlockItem;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "notreepunching");
    public static final RegistryObject<Block> ANDESITE_COBBLESTONE = ModBlocks.register("andesite_cobblestone", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<Block> DIORITE_COBBLESTONE = ModBlocks.register("diorite_cobblestone", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<Block> GRANITE_COBBLESTONE = ModBlocks.register("granite_cobblestone", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<StairsBlock> ANDESITE_COBBLESTONE_STAIRS = ModBlocks.register("andesite_cobblestone_stairs", () -> new StairsBlock(() -> ((Block)ANDESITE_COBBLESTONE.get()).func_176223_P(), Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<StairsBlock> DIORITE_COBBLESTONE_STAIRS = ModBlocks.register("diorite_cobblestone_stairs", () -> new StairsBlock(() -> ((Block)DIORITE_COBBLESTONE.get()).func_176223_P(), Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<StairsBlock> GRANITE_COBBLESTONE_STAIRS = ModBlocks.register("granite_cobblestone_stairs", () -> new StairsBlock(() -> ((Block)GRANITE_COBBLESTONE.get()).func_176223_P(), Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<SlabBlock> ANDESITE_COBBLESTONE_SLAB = ModBlocks.register("andesite_cobblestone_slab", () -> new SlabBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<SlabBlock> DIORITE_COBBLESTONE_SLAB = ModBlocks.register("diorite_cobblestone_slab", () -> new SlabBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<SlabBlock> GRANITE_COBBLESTONE_SLAB = ModBlocks.register("granite_cobblestone_slab", () -> new SlabBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<WallBlock> ANDESITE_COBBLESTONE_WALL = ModBlocks.register("andesite_cobblestone_wall", () -> new WallBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<WallBlock> DIORITE_COBBLESTONE_WALL = ModBlocks.register("diorite_cobblestone_wall", () -> new WallBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<WallBlock> GRANITE_COBBLESTONE_WALL = ModBlocks.register("granite_cobblestone_wall", () -> new WallBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
    public static final RegistryObject<LooseRockBlock> ANDESITE_LOOSE_ROCK = ModBlocks.register("andesite_loose_rock", LooseRockBlock::new);
    public static final RegistryObject<LooseRockBlock> DIORITE_LOOSE_ROCK = ModBlocks.register("diorite_loose_rock", LooseRockBlock::new);
    public static final RegistryObject<LooseRockBlock> GRANITE_LOOSE_ROCK = ModBlocks.register("granite_loose_rock", LooseRockBlock::new);
    public static final RegistryObject<LooseRockBlock> STONE_LOOSE_ROCK = ModBlocks.register("stone_loose_rock", LooseRockBlock::new);
    public static final RegistryObject<LooseRockBlock> SANDSTONE_LOOSE_ROCK = ModBlocks.register("sandstone_loose_rock", LooseRockBlock::new);
    public static final RegistryObject<LooseRockBlock> RED_SANDSTONE_LOOSE_ROCK = ModBlocks.register("red_sandstone_loose_rock", LooseRockBlock::new);
    public static final Map<PotteryBlock.Variant, RegistryObject<PotteryBlock>> POTTERY = Arrays.stream(PotteryBlock.Variant.values()).collect(Collectors.toMap(Function.identity(), pottery -> ModBlocks.register("clay_" + pottery.name().toLowerCase(), () -> new PotteryBlock((PotteryBlock.Variant)((Object)pottery)))));
    public static final RegistryObject<LargeVesselBlock> CERAMIC_LARGE_VESSEL = ModBlocks.register("ceramic_large_vessel", LargeVesselBlock::new, block -> new LargeVesselBlockItem((Block)block, new Item.Properties().func_200916_a(ModItemGroup.ITEMS)));

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockFactory) {
        return ModBlocks.register(name, blockFactory, block -> new BlockItem(block, new Item.Properties().func_200916_a(ModItemGroup.ITEMS)));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockFactory, Function<T, BlockItem> blockItemFactory) {
        RegistryObject block = BLOCKS.register(name, blockFactory);
        ModItems.ITEMS.register(name, () -> (BlockItem)blockItemFactory.apply(block.get()));
        return block;
    }
}

