/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.notreepunching.common.blocks.ModBlocks;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;

public class PotteryBlock
extends Block {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{PotteryBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)PotteryBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (VoxelShape)PotteryBlock.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0)), (VoxelShape)PotteryBlock.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_216384_a((VoxelShape)PotteryBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PotteryBlock.func_208617_a((double)3.0, (double)2.0, (double)4.0, (double)13.0, (double)8.0, (double)12.0), PotteryBlock.func_208617_a((double)4.0, (double)2.0, (double)3.0, (double)12.0, (double)8.0, (double)13.0), PotteryBlock.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0)}), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)PotteryBlock.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)PotteryBlock.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0)), (IBooleanFunction)IBooleanFunction.field_223234_e_), VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_216384_a((VoxelShape)PotteryBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), (VoxelShape[])new VoxelShape[]{PotteryBlock.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), PotteryBlock.func_208617_a((double)5.0, (double)4.0, (double)4.0, (double)11.0, (double)10.0, (double)12.0), PotteryBlock.func_208617_a((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0)}), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)PotteryBlock.func_208617_a((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)PotteryBlock.func_208617_a((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)), (IBooleanFunction)IBooleanFunction.field_223234_e_), VoxelShapes.func_197878_a((VoxelShape)PotteryBlock.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (VoxelShape)PotteryBlock.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)};
    private final Variant variant;

    public PotteryBlock(Variant variant) {
        super(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200943_b(0.8f - 0.1f * (float)variant.ordinal()).harvestLevel(0).harvestTool(ToolType.SHOVEL).func_200947_a(SoundType.field_185849_b));
        this.variant = variant;
    }

    @Nonnull
    public Variant getVariant() {
        return this.variant;
    }

    @Nonnull
    public ItemStack getFiredType() {
        switch (this.variant) {
            case LARGE_VESSEL: {
                return new ItemStack((IItemProvider)ModBlocks.CERAMIC_LARGE_VESSEL.get());
            }
            case BUCKET: {
                return new ItemStack((IItemProvider)ModItems.CERAMIC_BUCKET.get());
            }
            case SMALL_VESSEL: {
                return new ItemStack((IItemProvider)ModItems.CERAMIC_SMALL_VESSEL.get());
            }
            case FLOWER_POT: {
                return new ItemStack((IItemProvider)Items.field_222087_nH);
            }
        }
        return ItemStack.field_190927_a;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[this.variant.ordinal()];
    }

    public static enum Variant {
        WORKED,
        LARGE_VESSEL,
        SMALL_VESSEL,
        BUCKET,
        FLOWER_POT;

        private static final Variant[] VALUES;

        @Nullable
        public Variant next() {
            if (this == FLOWER_POT) {
                return null;
            }
            return VALUES[this.ordinal() + 1];
        }

        static {
            VALUES = Variant.values();
        }
    }
}

