/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.container;

import com.alcatrazescapee.notreepunching.common.container.DeviceContainer;
import com.alcatrazescapee.notreepunching.common.container.LargeVesselContainer;
import com.alcatrazescapee.notreepunching.common.container.SmallVesselContainer;
import com.alcatrazescapee.notreepunching.common.tileentity.InventoryTileEntity;
import com.alcatrazescapee.notreepunching.common.tileentity.LargeVesselTileEntity;
import com.alcatrazescapee.notreepunching.util.Helpers;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModContainers {
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = new DeferredRegister(ForgeRegistries.CONTAINERS, "notreepunching");
    public static final RegistryObject<ContainerType<LargeVesselContainer>> LARGE_VESSEL = ModContainers.register("large_vessel", LargeVesselTileEntity.class, LargeVesselContainer::new);
    public static final RegistryObject<ContainerType<SmallVesselContainer>> SMALL_VESSEL = ModContainers.register("small_vessel", (windowId, playerInv, buffer) -> new SmallVesselContainer(windowId, playerInv));

    private static <T extends InventoryTileEntity, C extends DeviceContainer<T>> RegistryObject<ContainerType<C>> register(String name, Class<T> tileClass, DeviceContainer.IFactory<T, C> factory) {
        return ModContainers.register(name, (windowId, playerInventory, packetBuffer) -> {
            World world = playerInventory.field_70458_d.field_70170_p;
            BlockPos pos = packetBuffer.func_179259_c();
            return Helpers.getTE((IBlockReader)world, pos, tileClass).map(tile -> factory.create(tile, playerInventory, windowId)).orElse(null);
        });
    }

    private static <C extends Container> RegistryObject<ContainerType<C>> register(String name, IContainerFactory<C> containerFactory) {
        return CONTAINERS.register(name, () -> IForgeContainerType.create((IContainerFactory)containerFactory));
    }
}

