/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.notreepunching.common.ModTags;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.registries.ForgeRegistries;

public class CeramicBucketItem
extends Item {
    public CeramicBucketItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack bucketStack;
        Fluid containedFluid = this.getFluid(bucketStack = playerIn.func_184586_b(handIn));
        RayTraceResult raytraceresult = CeramicBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(containedFluid == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)bucketStack, (RayTraceResult)raytraceresult);
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)bucketStack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)bucketStack);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)raytraceresult;
        BlockPos fluidPos = blockRayTraceResult.func_216350_a();
        Direction direction = blockRayTraceResult.func_216354_b();
        BlockPos pos1 = fluidPos.func_177972_a(direction);
        if (worldIn.func_175660_a(playerIn, fluidPos) && playerIn.func_175151_a(pos1, direction, bucketStack)) {
            BlockPos pos2;
            if (containedFluid == Fluids.field_204541_a) {
                Fluid fluid;
                BlockState blockstate1 = worldIn.func_180495_p(fluidPos);
                if (blockstate1.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, fluidPos, blockstate1)) != Fluids.field_204541_a) {
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent soundevent = containedFluid.getAttributes().getEmptySound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                    ItemStack filledBucket = this.fillBucket(bucketStack, playerIn, fluid);
                    if (!worldIn.field_72995_K) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)fluid.func_204524_b()));
                    }
                    return ActionResult.func_226248_a_((Object)filledBucket);
                }
                return ActionResult.func_226251_d_((Object)bucketStack);
            }
            BlockState blockstate = worldIn.func_180495_p(fluidPos);
            BlockPos blockPos = pos2 = this.canBlockContainFluid(worldIn, fluidPos, blockstate, containedFluid) ? fluidPos : pos1;
            if (this.tryPlaceContainedLiquid(playerIn, worldIn, pos2, blockRayTraceResult, containedFluid)) {
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, pos2, bucketStack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_226248_a_((Object)this.emptyBucket(bucketStack, playerIn));
            }
            return ActionResult.func_226251_d_((Object)bucketStack);
        }
        return ActionResult.func_226251_d_((Object)bucketStack);
    }

    private ItemStack emptyBucket(ItemStack stack, PlayerEntity playerIn) {
        return playerIn.field_71075_bZ.field_75098_d ? stack : this.getContainerItem(stack);
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, PlayerEntity player, Fluid fillFluid) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        ItemStack filledStack = emptyBuckets.func_77979_a(1);
        filledStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> handler.fill(new FluidStack(fillFluid, 1000), IFluidHandler.FluidAction.EXECUTE));
        if (emptyBuckets.func_190926_b()) {
            return filledStack;
        }
        if (!player.field_71071_by.func_70441_a(filledStack)) {
            player.func_71019_a(filledStack, false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult rayTrace, Fluid containedFluid) {
        if (!(containedFluid instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = blockstate.func_227032_a_(containedFluid);
        boolean canContainFluid = this.canBlockContainFluid(worldIn, posIn, blockstate, containedFluid);
        if (blockstate.func_196958_f() || flag || canContainFluid) {
            if (worldIn.field_73011_w.func_177500_n() && containedFluid.func_207185_a(FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (canContainFluid) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)containedFluid).func_207204_a(false))) {
                    this.playEmptySound(player, (IWorld)worldIn, posIn, containedFluid);
                }
            } else {
                if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.playEmptySound(player, (IWorld)worldIn, posIn, containedFluid);
                worldIn.func_180501_a(posIn, containedFluid.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return rayTrace != null && this.tryPlaceContainedLiquid(player, worldIn, rayTrace.func_216350_a().func_177972_a(rayTrace.func_216354_b()), null, containedFluid);
    }

    protected void playEmptySound(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos, Fluid containedFluid) {
        SoundEvent emptySound = containedFluid.getAttributes().getEmptySound();
        if (emptySound == null) {
            emptySound = containedFluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        worldIn.func_184133_a(player, pos, emptySound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private boolean canBlockContainFluid(World worldIn, BlockPos posIn, BlockState blockstate, Fluid fluid) {
        return blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, fluid);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
            return (ITextComponent)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
                if (handler instanceof FluidHandlerItemStackSimple && !((FluidHandlerItemStackSimple)handler).getFluid().isEmpty()) {
                    ITextComponent fluidName = ((FluidHandlerItemStackSimple)handler).getFluid().getDisplayName();
                    fluidName.func_150258_a(" ").func_150257_a(super.func_200295_i(stack));
                    return fluidName;
                }
                return super.func_200295_i(stack);
            }).orElseThrow(() -> new IllegalStateException("No fluid handler on ceramic bucket?"));
        }
        return super.func_200295_i(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                if (!ModTags.Fluids.CERAMIC_BUCKETABLE.func_199685_a_((Object)fluid)) continue;
                ItemStack stack = new ItemStack((IItemProvider)this);
                stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE) > 0) {
                        items.add((Object)stack);
                    }
                });
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStackSimple(stack, 1000);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack((IItemProvider)this);
    }

    private Fluid getFluid(ItemStack stack) {
        return (Fluid)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> handler.getFluidInTank(0).getFluid()).orElse((Object)Fluids.field_204541_a);
    }
}

