/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.notreepunching.Config;
import com.alcatrazescapee.notreepunching.common.ModItemGroup;
import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.util.Helpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.TieredItem;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class FireStarterItem
extends TieredItem {
    public FireStarterItem() {
        super((IItemTier)ItemTier.WOOD, new Item.Properties().func_200916_a(ModItemGroup.ITEMS).func_200918_c(10).setNoRepair());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        PlayerEntity player;
        RayTraceResult result;
        if (entityLiving instanceof PlayerEntity && (result = FireStarterItem.func_219968_a((World)worldIn, (PlayerEntity)(player = (PlayerEntity)entityLiving), (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)result).func_216350_a();
            if (!worldIn.field_72995_K) {
                Helpers.damageItem(player, player.func_184600_cs(), stack, 1);
                BlockState stateAt = worldIn.func_180495_p(pos);
                if (FlintAndSteelItem.func_219997_a((BlockState)stateAt)) {
                    worldIn.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    worldIn.func_180501_a(pos, (BlockState)stateAt.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
                } else {
                    List entities = worldIn.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1)));
                    ArrayList<ItemEntity> logEntities = new ArrayList<ItemEntity>();
                    ArrayList<ItemEntity> kindlingEntities = new ArrayList<ItemEntity>();
                    int logs = 0;
                    int kindling = 0;
                    for (ItemEntity drop : entities) {
                        ItemStack dropStack = drop.func_92059_d();
                        if (ModTags.Items.FIRE_STARTER_LOGS.func_199685_a_((Object)dropStack.func_77973_b())) {
                            logs += dropStack.func_190916_E();
                            logEntities.add(drop);
                            continue;
                        }
                        if (!ModTags.Items.FIRE_STARTER_KINDLING.func_199685_a_((Object)dropStack.func_77973_b())) continue;
                        kindling += dropStack.func_190916_E();
                        kindlingEntities.add(drop);
                    }
                    if (logs >= 1 && kindling >= 3) {
                        this.removeItems(logEntities, logs);
                        this.removeItems(kindlingEntities, kindling);
                        worldIn.func_175656_a(pos.func_177984_a(), (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((IProperty)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(true)));
                    } else if ((double)field_77697_d.nextFloat() < (Double)Config.SERVER.fireStarterFireStartChance.get()) {
                        worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        RayTraceResult result;
        if (player.field_70170_p.field_72995_K && player instanceof PlayerEntity && (result = FireStarterItem.func_219968_a((World)player.field_70170_p, (PlayerEntity)((PlayerEntity)player), (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)) instanceof BlockRayTraceResult && field_77697_d.nextInt(5) == 0) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, blockResult.func_216347_e().field_72450_a, blockResult.func_216347_e().field_72448_b, blockResult.func_216347_e().field_72449_c, 0.0, (double)0.1f, 0.0);
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 30;
    }

    private void removeItems(List<ItemEntity> itemEntities, int removeAmount) {
        for (ItemEntity logEntity : itemEntities) {
            ItemStack logStack = logEntity.func_92059_d();
            int shrink = Math.min(logStack.func_190916_E(), removeAmount);
            removeAmount -= shrink;
            logStack.func_190918_g(shrink);
            if (logStack.func_190916_E() != 0) continue;
            logEntity.func_70106_y();
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.BREAKABLE;
    }
}

