/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.util.ItemStackItemHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class LargeVesselBlockItem
extends BlockItem {
    public LargeVesselBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("BlockEntityTag")) {
            nbt = nbt.func_74775_l("BlockEntityTag");
        }
        return new LargeVesselItemHandler(nbt, stack, 15);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY != null) {
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                int displayCount = 0;
                int totalCount = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack contentStack = handler.getStackInSlot(i);
                    if (contentStack.func_190926_b()) continue;
                    ++totalCount;
                    if (displayCount > 4) continue;
                    ++displayCount;
                    ITextComponent itextcomponent = contentStack.func_200301_q().func_212638_h();
                    itextcomponent.func_150258_a(" x").func_150258_a(String.valueOf(contentStack.func_190916_E()));
                    tooltip.add(itextcomponent);
                }
                if (totalCount > displayCount) {
                    tooltip.add(new TranslationTextComponent("notreepunching.tooltip.small_vessel_more", new Object[]{totalCount - displayCount}).func_211708_a(TextFormatting.ITALIC));
                }
            });
        }
    }

    static class LargeVesselItemHandler
    extends ItemStackItemHandler {
        LargeVesselItemHandler(@Nullable CompoundNBT capNbt, ItemStack stack, int slots) {
            super(capNbt, stack, slots);
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return ModTags.Items.LARGE_VESSEL_BLACKLIST.func_199685_a_((Object)stack.func_77973_b());
        }
    }
}

