/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.notreepunching.common.ModItemGroup;
import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.common.container.SmallVesselContainer;
import com.alcatrazescapee.notreepunching.util.Helpers;
import com.alcatrazescapee.notreepunching.util.ItemStackItemHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class SmallVesselItem
extends Item {
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLUMNS = 3;
    public static final int SLOTS = 9;

    public SmallVesselItem() {
        super(new Item.Properties().func_200916_a(ModItemGroup.ITEMS).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn instanceof ServerPlayerEntity && !playerIn.func_225608_bj_()) {
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)Helpers.getStackContainerProvider(stack, (windowID, playerInventory, player) -> new SmallVesselContainer(windowID, playerInventory))));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY != null) {
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                int displayCount = 0;
                int totalCount = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack contentStack = handler.getStackInSlot(i);
                    if (contentStack.func_190926_b()) continue;
                    ++totalCount;
                    if (displayCount > 4) continue;
                    ++displayCount;
                    ITextComponent itextcomponent = contentStack.func_200301_q().func_212638_h();
                    itextcomponent.func_150258_a(" x").func_150258_a(String.valueOf(contentStack.func_190916_E()));
                    tooltip.add(itextcomponent);
                }
                if (totalCount > displayCount) {
                    tooltip.add(new TranslationTextComponent("notreepunching.tooltip.small_vessel_more", new Object[]{totalCount - displayCount}).func_211708_a(TextFormatting.ITALIC));
                }
            });
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SmallVesselItemStackHandler(nbt, stack, 9);
    }

    static final class SmallVesselItemStackHandler
    extends ItemStackItemHandler {
        SmallVesselItemStackHandler(@Nullable CompoundNBT capNbt, ItemStack stack, int slots) {
            super(capNbt, stack, slots);
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return !ModTags.Items.SMALL_VESSEL_BLACKLIST.func_199685_a_((Object)stack.func_77973_b());
        }
    }
}

