/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.tileentity;

import com.alcatrazescapee.notreepunching.common.tileentity.ModTileEntity;
import com.alcatrazescapee.notreepunching.util.Helpers;
import com.alcatrazescapee.notreepunching.util.ISlotCallback;
import com.alcatrazescapee.notreepunching.util.ItemStackHandlerCallback;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class InventoryTileEntity
extends ModTileEntity
implements INamedContainerProvider,
ISlotCallback {
    protected final ItemStackHandler inventory;
    protected final LazyOptional<IItemHandler> inventoryCapability;
    protected ITextComponent customName;
    protected ITextComponent defaultName;

    public InventoryTileEntity(TileEntityType<?> type, int inventorySlots, ITextComponent defaultName) {
        super(type);
        this.inventory = new ItemStackHandlerCallback(this, inventorySlots);
        this.inventoryCapability = LazyOptional.of(() -> this.inventory);
        this.defaultName = defaultName;
    }

    public InventoryTileEntity(TileEntityType<?> type, ItemStackHandler inventory, ITextComponent defaultName) {
        super(type);
        this.inventory = inventory;
        this.inventoryCapability = LazyOptional.of(() -> inventory);
        this.defaultName = defaultName;
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    @Nullable
    public ITextComponent getCustomName() {
        return this.customName;
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    public void func_145839_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("CustomName")) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("CustomName"));
        }
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        super.func_145839_a(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (this.customName != null) {
            nbt.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        nbt.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.markDirtyFast();
    }

    public boolean canInteractWith(PlayerEntity player) {
        return true;
    }

    public void onReplaced() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Helpers.dropInventoryItems(this.field_145850_b, this.field_174879_c, (IItemHandlerModifiable)this.inventory);
        }
    }
}

