/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Helpers {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();

    public static <T> Optional<T> getTE(IBlockReader world, BlockPos pos, Class<T> tileClass) {
        TileEntity tile = world.func_175625_s(pos);
        if (tileClass.isInstance(tile)) {
            return Optional.of(tile);
        }
        return Optional.empty();
    }

    public static void dropInventoryItems(World world, BlockPos pos, IItemHandlerModifiable inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    public static ItemStack damageItem(ItemStack stack, int amount) {
        if (stack.func_77984_f() && stack.func_96631_a(amount, RANDOM, null)) {
            stack.func_190918_g(1);
            stack.func_196085_b(0);
        }
        return stack;
    }

    public static ItemStack damageItem(@Nullable PlayerEntity player, @Nullable Hand hand, ItemStack stack, int amount) {
        if (player != null && hand != null) {
            stack.func_222118_a(amount, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            return stack;
        }
        return Helpers.damageItem(stack, amount);
    }

    public static <T> void ifPresentOrElse(LazyOptional<T> lazyOptional, Consumer<T> ifPresent, Runnable orElse) {
        lazyOptional.map(internal -> {
            ifPresent.accept(internal);
            return Unit.INSTANCE;
        }).orElseGet(() -> {
            orElse.run();
            return Unit.INSTANCE;
        });
    }

    public static <T, R> LazyOptional<R> getCapabilityOrElse(@Nullable Capability<R> capability, @Nullable Capability<T> capabilityToCheck, LazyOptional<T> instance) {
        if (capabilityToCheck == null || capability == null) {
            LOGGER.warn("Something called getCapability with a null capability! This is illegal");
            LOGGER.debug((Object)new RuntimeException("Stacktrace"));
            return LazyOptional.empty();
        }
        return capabilityToCheck.orEmpty(capability, instance);
    }

    public static INamedContainerProvider getStackContainerProvider(final ItemStack stack, final IContainerProvider simpleContainerProvider) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return stack.func_200301_q();
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
                return simpleContainerProvider.createMenu(windowId, playerInventory, player);
            }
        };
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }
}

