/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import com.alcatrazescapee.notreepunching.Config;
import com.alcatrazescapee.notreepunching.common.ModTags;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterialHacks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Material> DEFAULT_NO_TOOL_MATERIALS = new HashSet<Material>();
    private static final ToolType SWORD = ToolType.get((String)"sword");
    private static final Map<Material, ToolType> EXTRA_MATERIAL_TOOLS = (Map)Util.func_199748_a(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Stream.of(Material.field_151585_k, Material.field_203243_f, Material.field_151582_l, Material.field_204868_h, Material.field_215713_z, Material.field_215712_y, Material.field_151570_A).forEach(material -> builder.put(material, (Object)SWORD));
        Stream.of(Material.field_151575_d, Material.field_151584_j).forEach(material -> builder.put(material, (Object)ToolType.AXE));
        Stream.of(Material.field_151576_e, Material.field_151573_f, Material.field_151574_g, Material.field_76233_E).forEach(material -> builder.put(material, (Object)ToolType.PICKAXE));
        Stream.of(Material.field_151578_c, Material.field_151572_C, Material.field_151595_p, Material.field_151571_B, Material.field_151597_y, Material.field_151596_z).forEach(material -> builder.put(material, (Object)ToolType.SHOVEL));
        return builder.build();
    });

    public static void setup() {
        ForgeRegistries.BLOCKS.getValues().stream().flatMap(block -> block.func_176194_O().func_177619_a().stream()).forEach(state -> {
            Block block = state.func_177230_c();
            Material material = state.func_185904_a();
            if (material.func_76229_l()) {
                DEFAULT_NO_TOOL_MATERIALS.add(material);
            }
            material.field_76241_J = false;
            MaterialHacks.runReallySafely(() -> {
                Field harvestTool = Block.class.getDeclaredField("harvestTool");
                Field harvestLevel = Block.class.getDeclaredField("harvestLevel");
                harvestTool.setAccessible(true);
                harvestLevel.setAccessible(true);
                if (harvestTool.get(block) == null && harvestLevel.getInt(block) == -1 && EXTRA_MATERIAL_TOOLS.containsKey(material)) {
                    harvestTool.set(block, EXTRA_MATERIAL_TOOLS.get(material));
                    harvestLevel.set(block, 0);
                }
                return Unit.INSTANCE;
            }, () -> "Failed to add the sword tool type to block: " + block.getRegistryName());
        });
        ForgeRegistries.ITEMS.getValues().forEach(item -> MaterialHacks.runReallySafely(() -> {
            if (item instanceof SwordItem) {
                Field toolClasses = Item.class.getDeclaredField("toolClasses");
                toolClasses.setAccessible(true);
                MaterialHacks.castReallySafely(toolClasses.get(item)).put(SWORD, ((SwordItem)item).func_200891_e().func_200925_d());
            }
            return Unit.INSTANCE;
        }, () -> "Failed to add the sword tool class to item: " + item.getRegistryName()));
    }

    public static boolean doesMaterialRequireNoToolByDefault(Material material) {
        return DEFAULT_NO_TOOL_MATERIALS.contains(material);
    }

    public static boolean canHarvest(BlockState state, PlayerEntity player) {
        if (!(!((Boolean)Config.SERVER.noBlockDropsWithoutCorrectTool.get()).booleanValue() && DEFAULT_NO_TOOL_MATERIALS.contains(state.func_185904_a()) || ModTags.Blocks.ALWAYS_DROPS.func_199685_a_((Object)state.func_177230_c()))) {
            ItemStack stack = player.func_184614_ca();
            ToolType tool = state.getHarvestTool();
            if (tool != null) {
                if (!stack.func_190926_b()) {
                    int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
                    if (toolLevel == -1) {
                        toolLevel = MaterialHacks.getExtraHarvestLevel(stack, tool);
                    }
                    if (toolLevel >= state.getHarvestLevel() && state.getHarvestLevel() != -1) {
                        return true;
                    }
                }
                return player.field_71071_by.func_184432_b(state);
            }
        }
        return true;
    }

    private static int getExtraHarvestLevel(ItemStack stack, ToolType tool) {
        if (stack.getToolTypes().contains(ToolType.PICKAXE) && tool == ToolType.SHOVEL) {
            return 0;
        }
        if (ModTags.Items.KNIVES.func_199685_a_((Object)stack.func_77973_b()) && tool == SWORD) {
            if (stack.func_77973_b() instanceof TieredItem) {
                return ((TieredItem)stack.func_77973_b()).func_200891_e().func_200925_d();
            }
            return 0;
        }
        return -1;
    }

    private static void runReallySafely(Callable<?> dangerousThing, Supplier<String> message) {
        try {
            dangerousThing.call();
        }
        catch (Exception e) {
            LOGGER.warn("Oh noes: " + message.get());
            LOGGER.debug("Stacktrace", (Throwable)e);
        }
    }

    private static <K, V> Map<K, V> castReallySafely(Object whatever) {
        return (Map)whatever;
    }
}

