/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="nps")
@Config.LangKey(value="Nether Portal Spread Config")
public class ModConfig {
    @Config.Comment(value={"The radius around the portal to which the nether blocks can spread."})
    @Config.RangeInt(min=1, max=100)
    public static int portalSpreadRadius = 15;
    @Config.Comment(value={"The delay in ms in between the spread around the nether portal."})
    @Config.RangeInt(min=20, max=360000)
    public static int spreadDelay = 2500;
    @Config.Comment(value={"The amount of blocks that are instantly converted to a nether block around a portal when it is detected. If there are existing nether blocks within the radius, their count is substracted from this number."})
    @Config.RangeInt(min=0, max=1000)
    public static int instantConvertAmount = 50;
    @Config.Comment(value={"When enabled, blocks the spread effect when there are two coal blocks within the radius."})
    public static boolean coalPreventsSpread = true;
    @Config.Comment(value={"The chance the next spreaded block is quartz ore."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double isQuartzChance = 0.05;
    @Config.Comment(value={"The chance after the quartz roll that the next spreaded block is netherbrick."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double isNetherBrickChance = 0.2;

    @Mod.EventBusSubscriber(modid="nps")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("nps")) {
                ConfigManager.sync((String)"nps", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

