/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.util;

import com.natamus.netherportalspread.config.ModConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Util {
    public static World world = null;
    public static List<BlockPos> portals = new ArrayList<BlockPos>();
    private static List<Block> convertblocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n));

    public static Boolean portalExists(BlockPos pos) {
        for (BlockPos portalpos : portals) {
            Double distance = pos.func_185332_f(portalpos.func_177958_n(), portalpos.func_177956_o(), portalpos.func_177952_p());
            if (!(distance < (double)ModConfig.portalSpreadRadius / 2.0)) continue;
            return true;
        }
        return false;
    }

    public static void addPortal(BlockPos pos) {
        portals.add(pos);
    }

    public static void initSpread(final BlockPos portal, int delayms, final int loopcount, final Boolean resetafter) {
        if (delayms < 0) {
            delayms = ModConfig.spreadDelay;
        }
        final int delay = delayms;
        if (loopcount > 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Util.spreadNextBlock(portal).booleanValue()) {
                        Util.initSpread(portal, delay, loopcount - 1, resetafter);
                    } else {
                        portals.remove(portal);
                    }
                }
            }).start();
        } else if (resetafter.booleanValue()) {
            Util.initSpread(portal, ModConfig.spreadDelay, 10000000, false);
        }
    }

    public static Boolean spreadNextBlock(BlockPos p) {
        if (world == null || p == null) {
            return false;
        }
        IBlockState pbs = world.func_180495_p(p);
        if (pbs == null) {
            return false;
        }
        if (!world.func_180495_p(p).func_177230_c().equals(Blocks.field_150427_aO)) {
            return false;
        }
        int r = ModConfig.portalSpreadRadius;
        BlockPos closest = null;
        int coalcount = 0;
        double nearestdistance = 100000.0;
        for (BlockPos np : BlockPos.func_191532_a((int)(p.func_177958_n() - r), (int)(p.func_177956_o() - r), (int)(p.func_177952_p() - r), (int)(p.func_177958_n() + r), (int)(p.func_177956_o() + r), (int)(p.func_177952_p() + r))) {
            if (ModConfig.coalPreventsSpread && world.func_180495_p(np).func_177230_c().equals(Blocks.field_150402_ci) && ++coalcount >= 2) break;
            double npnd = p.func_185332_f(np.func_177958_n(), np.func_177956_o(), np.func_177952_p());
            if (!(npnd < nearestdistance) || !Util.isNetherTarget(np, false).booleanValue()) continue;
            nearestdistance = npnd;
            closest = np;
        }
        if (ModConfig.coalPreventsSpread && coalcount >= 2) {
            return true;
        }
        if (closest != null) {
            Util.spreadNetherToBlock(closest);
            return true;
        }
        return false;
    }

    public static int countNetherBlocks(BlockPos p) {
        int nethercount = 0;
        int r = ModConfig.portalSpreadRadius;
        for (BlockPos np : BlockPos.func_191532_a((int)(p.func_177958_n() - r), (int)(p.func_177956_o() - r), (int)(p.func_177952_p() - r), (int)(p.func_177958_n() + r), (int)(p.func_177956_o() + r), (int)(p.func_177952_p() + r))) {
            if (!Util.isNetherTarget(np, true).booleanValue()) continue;
            ++nethercount;
        }
        return nethercount;
    }

    public static Boolean isNetherTarget(BlockPos pos, Boolean count) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (count.booleanValue()) {
            if (block.equals(Blocks.field_150424_aL) || block.equals(Blocks.field_150385_bj) || block.equals(Blocks.field_150449_bY) || block.equals(Blocks.field_150425_aM)) {
                return true;
            }
            return false;
        }
        if (convertblocks.contains(block)) {
            return true;
        }
        return false;
    }

    public static void spreadNetherToBlock(BlockPos pos) {
        IBlockState newblockstate = null;
        IBlockState curstate = world.func_180495_p(pos);
        Block curblock = curstate.func_177230_c();
        if (curblock.equals(Blocks.field_150354_m) || curblock.equals(Blocks.field_150351_n)) {
            newblockstate = Blocks.field_150425_aM.func_176223_P();
        } else {
            newblockstate = Blocks.field_150424_aL.func_176223_P();
            if (Math.random() <= ModConfig.isQuartzChance) {
                newblockstate = Blocks.field_150449_bY.func_176223_P();
            } else if (Math.random() <= ModConfig.isNetherBrickChance) {
                newblockstate = Blocks.field_150385_bj.func_176223_P();
            }
        }
        if (newblockstate != null) {
            world.func_175656_a(pos, newblockstate);
        }
    }

    public static void checkChunkForPortals(Chunk chunk, Boolean fromclick) {
        int a = chunk.field_76635_g * 16;
        int b = chunk.field_76647_h * 16;
        for (double x = 0.0; x <= 15.0; x += 1.0) {
            for (double y = 0.0; y <= 256.0; y += 1.0) {
                for (double z = 0.0; z <= 15.0; z += 1.0) {
                    int nethercount;
                    BlockPos actualPosition = new BlockPos((double)a + x, y, (double)b + z);
                    IBlockState state = chunk.func_177435_g(actualPosition);
                    Block block = state.func_177230_c();
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150427_aO) || Util.portalExists(actualPosition).booleanValue()) continue;
                    Util.addPortal(actualPosition);
                    if (fromclick.booleanValue() && (nethercount = Util.countNetherBlocks(actualPosition)) < ModConfig.instantConvertAmount) {
                        Util.initSpread(actualPosition, 20, ModConfig.instantConvertAmount - nethercount, true);
                        continue;
                    }
                    Util.initSpread(actualPosition, ModConfig.spreadDelay, 10000000, false);
                }
            }
        }
    }
}

