/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> portalSpreadRadius;
        public final ForgeConfigSpec.ConfigValue<Integer> spreadDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> instantConvertAmount;
        public final ForgeConfigSpec.ConfigValue<Boolean> coalPreventsSpread;
        public final ForgeConfigSpec.ConfigValue<Double> isQuartzChance;
        public final ForgeConfigSpec.ConfigValue<Double> isNetherBrickChance;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.portalSpreadRadius = builder.comment("The radius around the portal to which the nether blocks can spread.").defineInRange("portalSpreadRadius", 15, 1, 100);
            this.spreadDelay = builder.comment("The delay in ms in between the spread around the nether portal.").defineInRange("spreadDelay", 2500, 20, 360000);
            this.instantConvertAmount = builder.comment("The amount of blocks that are instantly converted to a nether block around a portal when it is detected. If there are existing nether blocks within the radius, their count is substracted from this number.").defineInRange("instantConvertAmount", 50, 0, 1000);
            this.coalPreventsSpread = builder.comment("When enabled, blocks the spread effect when there are two coal blocks within the radius.").define("coalPreventsSpread", true);
            this.isQuartzChance = builder.comment("The chance the next spreaded block is quartz ore.").defineInRange("isQuartzChance", 0.05, 0.0, 1.0);
            this.isNetherBrickChance = builder.comment("The chance after the quartz roll that the next spreaded block is netherbrick.").defineInRange("isNetherBrickChance", 0.2, 0.0, 1.0);
            builder.pop();
        }
    }
}

