/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks.turretheads;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import omtteam.omlib.util.GeneralUtil;
import omtteam.openmodularturrets.api.lists.TurretList;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.items.blocks.ItemBlockRelativisticTurret;
import omtteam.openmodularturrets.tileentity.turrets.RelativisticTurretTileEntity;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.turret.TurretType;

public class BlockRelativisticTurret
extends BlockAbstractTurretHead {
    public BlockRelativisticTurret() {
        this.func_149663_c("relativistic_turret");
        this.setRegistryName("openmodularturrets", "relativistic_turret");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockRelativisticTurret(block);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new RelativisticTurretTileEntity();
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i <= 5; ++i) {
            Random random = new Random();
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + random.nextGaussian() / 10.0 + 0.5, (double)((float)pos.func_177956_o() + 0.5f), (double)pos.func_177952_p() + random.nextGaussian() / 10.0 + 0.5, 200.0, 200.0, 200.0, new int[0]);
        }
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TurretHead) {
            TurretHead turret = (TurretHead)te;
            boolean active = turret.getBase().isActive();
            probeInfo.text("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:active") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)active));
            String ownerName = turret.getBase().getOwner().getName();
            probeInfo.text("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:owner") + ": \u00a7F" + ownerName);
        }
    }

    @Override
    public TurretType getTurretType() {
        return TurretList.getTurretType("relativistic_turret");
    }
}

