/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.client.gui;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.OMLib;
import omtteam.omlib.api.gui.GuiParameters;
import omtteam.omlib.api.gui.IHasTooltips;
import omtteam.omlib.api.gui.ISupportsBackSystem;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.handler.GUIBackSystem;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageCloseGUITile;
import omtteam.omlib.network.messages.MessageOpenGUITile;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.handler.OMTNetworkingHandler;
import omtteam.openmodularturrets.network.messages.MessageAdjustLightOpacity;
import omtteam.openmodularturrets.network.messages.MessageAdjustLightValue;
import omtteam.openmodularturrets.network.messages.MessageToggleAttackMobs;
import omtteam.openmodularturrets.network.messages.MessageToggleAttackNeutralMobs;
import omtteam.openmodularturrets.network.messages.MessageToggleAttackPlayers;
import omtteam.openmodularturrets.tileentity.TurretBase;
import org.lwjgl.opengl.GL11;

public class ConfigureGui
extends GuiScreen
implements IHasTooltips,
GuiPageButtonList.GuiResponder,
GuiSlider.FormatHelper,
ISupportsBackSystem {
    protected final int xSize = 176;
    protected final int ySize = 205;
    private final TurretBase base;
    private final EntityPlayer player;
    protected int guiLeft;
    protected int guiTop;
    private int mouseX;
    private int mouseY;
    private GuiSlider sliderLightValue;
    private GuiSlider sliderLightOpacity;
    private int lightValue;
    private int lightOpacity;
    private boolean addedToSyncList;
    private int accessLevel = 0;

    public ConfigureGui(InventoryPlayer inventoryPlayer, TurretBase tileEntity) {
        this.base = tileEntity;
        this.lightValue = this.base.getCamoSettings().getLightValue();
        this.lightOpacity = this.base.getCamoSettings().getLightOpacity();
        this.player = inventoryPlayer.field_70458_d;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void buttonInit() {
        if (PlayerUtil.canPlayerChangeSetting((EntityPlayer)this.player, (IHasOwner)this.base)) {
            String mobsButton = GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:attack_mobs") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksMobs());
            String neutralsButton = GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:attack_neutrals") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksNeutrals());
            String playersButton = GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:attack_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksPlayers());
            this.field_146292_n.add(new GuiButton(0, this.guiLeft + 10, this.guiTop + 20, 155, 20, mobsButton));
            this.field_146292_n.add(new GuiButton(1, this.guiLeft + 10, this.guiTop + 40, 155, 20, neutralsButton));
            this.field_146292_n.add(new GuiButton(2, this.guiLeft + 10, this.guiTop + 60, 155, 20, playersButton));
        }
        if (PlayerUtil.isPlayerAdmin((EntityPlayer)this.player, (IHasOwner)this.base)) {
            this.field_146292_n.add(new GuiButton(3, this.guiLeft + 10, this.guiTop + 95, 155, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:trusted_players")));
            this.sliderLightValue = new GuiSlider((GuiPageButtonList.GuiResponder)this, 4, this.guiLeft + 10, this.guiTop + 157, GeneralUtil.safeLocalize((String)"text.openmodularturrets.gui.light_value"), 0.0f, 15.0f, (float)this.lightValue, (GuiSlider.FormatHelper)this);
            this.sliderLightOpacity = new GuiSlider((GuiPageButtonList.GuiResponder)this, 5, this.guiLeft + 10, this.guiTop + 179, GeneralUtil.safeLocalize((String)"text.openmodularturrets.gui.light_opacity"), 0.0f, 15.0f, (float)this.lightOpacity, (GuiSlider.FormatHelper)this);
            if (this.base.getTier() > 3) {
                this.field_146292_n.add(this.sliderLightValue);
                this.field_146292_n.add(this.sliderLightOpacity);
            }
        }
        this.field_146292_n.add(new GuiButton(6, this.guiLeft + 185, this.guiTop + 20, 80, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:back")));
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        if (!this.addedToSyncList) {
            OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageOpenGUITile((TileEntity)this.base));
            this.addedToSyncList = true;
        }
        this.accessLevel = PlayerUtil.getPlayerAccessLevel((EntityPlayer)this.player, (IHasOwner)this.base).ordinal();
        if (this.accessLevel < 2) {
            this.player.func_71053_j();
        }
        this.field_146292_n.clear();
        this.buttonInit();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        this.func_146276_q_();
        if (this.accessLevel != PlayerUtil.getPlayerAccessLevel((EntityPlayer)this.player, (IHasOwner)this.base).ordinal() && !PlayerUtil.isPlayerOwner((EntityPlayer)this.player, (IHasOwner)this.base)) {
            this.accessLevel = PlayerUtil.getPlayerAccessLevel((EntityPlayer)this.player, (IHasOwner)this.base).ordinal();
            if (this.accessLevel != 0) {
                this.func_73866_w_();
            }
        } else if (!PlayerUtil.isPlayerOwner((EntityPlayer)this.player, (IHasOwner)this.base) && this.accessLevel < 2) {
            this.player.func_71053_j();
            this.player.openGui((Object)OpenModularTurrets.instance, 1, this.player.func_130014_f_(), this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
            return;
        }
        ResourceLocation texture = new ResourceLocation("openmodularturrets:textures/gui/configure.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b((this.field_146294_l - 176) / 2, (this.field_146295_m - 205) / 2, 0, 0, 176, 205);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:targeting_options") + ": ", this.guiLeft + 10, this.guiTop + 9, 0);
        if (this.accessLevel > 2) {
            fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:trusted_players") + ": ", this.guiLeft + 10, this.guiTop + 84, 0);
            fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:light_values") + ": ", this.guiLeft + 10, this.guiTop + 145, 0);
        }
        ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:attack_mobs") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksMobs());
        ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:attack_neutrals") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksNeutrals());
        ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:attack_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksPlayers());
        super.func_73863_a(par1, par2, par3);
        this.drawTooltips();
    }

    @ParametersAreNonnullByDefault
    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            if (PlayerUtil.canPlayerChangeSetting((EntityPlayer)this.player, (IHasOwner)this.base)) {
                this.sendChangeToServerMobs(!this.base.isAttacksMobs());
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 1) {
            if (PlayerUtil.canPlayerChangeSetting((EntityPlayer)this.player, (IHasOwner)this.base)) {
                this.sendChangeToServerNeutrals(!this.base.isAttacksNeutrals());
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 2) {
            if (PlayerUtil.canPlayerChangeSetting((EntityPlayer)this.player, (IHasOwner)this.base)) {
                this.sendChangeToServerPlayers(!this.base.isAttacksPlayers());
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 3) {
            if (PlayerUtil.isPlayerAdmin((EntityPlayer)this.player, (IHasOwner)this.base)) {
                this.player.openGui((Object)OMLib.instance, 0, this.player.func_130014_f_(), this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 6) {
            GUIBackSystem.getInstance().openLastGui(this.player);
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
        if (id == 4) {
            this.lightValue = Math.round(value);
            this.sliderLightValue.func_175218_a((float)Math.round(value), false);
            this.sendChangeToServerLightValue(this.lightValue);
        } else if (id == 5) {
            this.lightOpacity = Math.round(value);
            this.sliderLightOpacity.func_175218_a((float)Math.round(value), false);
            this.sendChangeToServerLightOpacity(this.lightOpacity);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_175319_a(int id, String value) {
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_175318_a(int id, String name, float value) {
        return name + ": " + Math.round(value);
    }

    public void drawTooltips() {
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        int tooltipToDraw = this.field_146292_n.stream().filter(GuiButton::func_146115_a).mapToInt(s -> s.field_146127_k).sum();
        ArrayList<String> tooltip = new ArrayList<String>();
        switch (tooltipToDraw) {
            case 0: {
                if (!((GuiButton)this.field_146292_n.get(0)).func_146115_a()) break;
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.omlib:target_mobs"));
                break;
            }
            case 1: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.omlib:target_neutrals"));
                break;
            }
            case 2: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.omlib:target_players"));
                break;
            }
            case 3: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.omlib:trusted_player_gui"));
                break;
            }
        }
        if (!tooltip.isEmpty()) {
            this.drawHoveringText(tooltip, this.guiLeft + this.mouseX - k, this.guiTop + this.mouseY - l, Minecraft.func_71410_x().field_71466_p);
        }
    }

    private void sendChangeToServerMobs(boolean setTo) {
        MessageToggleAttackMobs message = new MessageToggleAttackMobs(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), setTo);
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendChangeToServerNeutrals(boolean setTo) {
        MessageToggleAttackNeutralMobs message = new MessageToggleAttackNeutralMobs(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), setTo);
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendChangeToServerPlayers(boolean setTo) {
        MessageToggleAttackPlayers message = new MessageToggleAttackPlayers(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), setTo);
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendChangeToServerLightValue(int value) {
        MessageAdjustLightValue message = new MessageAdjustLightValue(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), value);
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendChangeToServerLightOpacity(int value) {
        MessageAdjustLightOpacity message = new MessageAdjustLightOpacity(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), value);
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_146281_b() {
        OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageCloseGUITile((TileEntity)this.base));
        super.func_146281_b();
    }

    @Nullable
    public GuiParameters getGuiParameters() {
        return new GuiParameters((Object)OpenModularTurrets.instance, 20, this.player.func_130014_f_(), this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
    }
}

