/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.ArmorBypassDamageSource;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class GrenadeProjectile
extends TurretProjectile {
    private boolean hit = false;

    public GrenadeProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.03f;
    }

    public GrenadeProjectile(World world, ItemStack ammo, TurretBase turretBase) {
        super(world, ammo, turretBase);
        this.gravity = 0.03f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= 39 && !this.func_130014_f_().field_72995_K) {
            float strength = OMTConfig.TURRETS.canGrenadesDestroyBlocks ? 1.4f : 0.1f;
            this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true);
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 3.0, this.field_70161_v + 3.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase entity : targets) {
                int damage = OMTConfig.TURRETS.grenade_turret.baseDamage;
                if (this.isAmped) {
                    damage = (int)((double)damage + (double)((int)entity.func_110143_aJ()) * (this.getDamageAmpBonus() * (double)this.amp_level));
                }
                if (!this.canDamageEntity((Entity)entity)) continue;
                if (!(entity instanceof EntityPlayer)) {
                    this.setTagsForTurretHit((Entity)entity);
                }
                entity.func_70097_a((DamageSource)new NormalDamageSource("grenade", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_(), true), (float)damage * 0.9f);
                entity.func_70097_a((DamageSource)new ArmorBypassDamageSource("grenade", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_(), true), (float)damage * 0.1f);
                entity.field_70172_ad = -1;
            }
            this.func_70106_y();
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (this.hit) {
            return;
        }
        if (this.canDamageEntity(entity)) {
            this.field_70159_w *= (double)0.2f;
            this.field_70181_x *= (double)1.2f;
            this.field_70179_y *= (double)0.2f;
            this.func_70018_K();
            this.hit = true;
            this.field_70173_aa = 30;
        }
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    @ParametersAreNonnullByDefault
    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }

    @Override
    public double getDamageAmpBonus() {
        return OMTConfig.TURRETS.grenade_turret.damageAmp;
    }
}

