/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.render.MessageSpawnParticleQuad;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.ArmorBypassDamageSource;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class PlasmaProjectile
extends TurretProjectile {
    public PlasmaProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.001f;
    }

    public PlasmaProjectile(World world, TurretBase turretBase) {
        super(world, turretBase);
        this.gravity = 0.001f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 30) {
            this.func_70106_y();
        }
    }

    private void explode() {
        if (this.field_70128_L) {
            return;
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w * 0.8, this.field_70163_u + this.field_70181_x * 0.8, this.field_70161_v + this.field_70179_y * 0.8);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (!this.func_130014_f_().field_72995_K) {
            MessageSpawnParticleQuad flameParticles = new MessageSpawnParticleQuad(EnumParticleTypes.FLAME.func_179348_c(), this.func_130014_f_().field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0, 1.0, 2.0, 0.2, 15);
            MessageSpawnParticleQuad smokeParticles = new MessageSpawnParticleQuad(EnumParticleTypes.SMOKE_LARGE.func_179348_c(), this.func_130014_f_().field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0, 1.0, 2.0, 0.2, 15);
            OMLibNetworkingHandler.INSTANCE.sendToAllTracking((IMessage)flameParticles, (Entity)this);
            OMLibNetworkingHandler.INSTANCE.sendToAllTracking((IMessage)smokeParticles, (Entity)this);
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 2.0, this.field_70163_u - 2.0, this.field_70161_v - 2.0, this.field_70165_t + 2.0, this.field_70163_u + 2.0, this.field_70161_v + 2.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase entity : targets) {
                int damage = OMTConfig.TURRETS.plasma_turret.baseDamage;
                if (this.isAmped) {
                    damage = (int)((double)damage + (double)((int)entity.func_110143_aJ()) * (this.getDamageAmpBonus() * (double)this.amp_level));
                }
                if ((!(entity instanceof EntityPlayer) || !this.canDamagePlayer((EntityPlayer)entity)) && !this.canDamageEntity((Entity)entity)) continue;
                if (!(entity instanceof EntityPlayer)) {
                    this.setTagsForTurretHit((Entity)entity);
                }
                entity.func_70097_a((DamageSource)new NormalDamageSource("plasma", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_(), true), (float)damage * 0.5f);
                entity.func_70097_a((DamageSource)new ArmorBypassDamageSource("plasma", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_(), true), (float)damage * 0.5f);
                entity.field_70172_ad = -1;
            }
        }
        this.func_70106_y();
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a() || pos.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 0.5) {
            return;
        }
        this.explode();
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (this.canDamageEntity(entity)) {
            this.explode();
        }
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    @ParametersAreNonnullByDefault
    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }

    @Override
    public double getDamageAmpBonus() {
        return OMTConfig.TURRETS.plasma_turret.damageAmp;
    }
}

