/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class RocketProjectile
extends TurretProjectile {
    public int arrowShake;
    private Entity target;

    public RocketProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.0f;
    }

    public RocketProjectile(World p_i1776_1_, TurretBase turretBase) {
        super(p_i1776_1_, turretBase);
        this.gravity = 0.0f;
    }

    public RocketProjectile(World par1World, Entity target, ItemStack ammo, TurretBase turretBase) {
        super(par1World, ammo, turretBase);
        this.gravity = 0.0f;
        this.target = target;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.func_130014_f_().field_72995_K) {
            if (OMTConfig.TURRETS.canRocketsHome && this.target != null) {
                double d0 = this.target.field_70165_t - this.field_70165_t;
                double d1 = this.target.field_70163_u + (double)this.target.func_70047_e() - (double)1.1f - this.field_70163_u;
                double d2 = this.target.field_70161_v - this.field_70161_v;
                float speed = 0.24f;
                this.func_70186_c(d0, d1, d2, speed, 0.0f);
            } else if (OMTConfig.TURRETS.canRocketsHome) {
                this.func_70106_y();
            }
        }
        for (int i = 0; i <= 20; ++i) {
            Random random = new Random();
            this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + random.nextGaussian() / 10.0, this.field_70163_u + random.nextGaussian() / 10.0, this.field_70161_v + random.nextGaussian() / 10.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        if (!this.func_130014_f_().field_72995_K) {
            float strength = OMTConfig.TURRETS.canRocketsDestroyBlocks ? 2.3f : 0.1f;
            this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true);
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase entity : targets) {
                int damage = OMTConfig.TURRETS.rocket_turret.baseDamage;
                if (this.isAmped) {
                    damage = (int)((double)damage + (double)((int)entity.func_110143_aJ()) * (this.getDamageAmpBonus() * (double)this.amp_level));
                }
                if (OMTConfig.TURRETS.canRocketsHurtEnderDragon && entity instanceof EntityDragon) {
                    this.setTagsForTurretHit((Entity)entity);
                    entity.func_70606_j(entity.func_110143_aJ() - (float)damage);
                    entity.field_70172_ad = -1;
                    continue;
                }
                if (!this.canDamageEntity((Entity)entity)) continue;
                if (!(entity instanceof EntityPlayer)) {
                    this.setTagsForTurretHit((Entity)entity);
                }
                entity.func_70097_a((DamageSource)new NormalDamageSource("rocket", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_(), true), (float)damage);
                entity.field_70172_ad = -1;
            }
        }
        this.func_70106_y();
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        this.explode();
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!(this.func_130014_f_().field_72995_K || entity instanceof EntityPlayer && !this.canDamagePlayer((EntityPlayer)entity) || !this.canDamageEntity(entity) || entity instanceof TurretProjectile)) {
            this.explode();
        }
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    @ParametersAreNonnullByDefault
    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }

    @Override
    public double getDamageAmpBonus() {
        return OMTConfig.TURRETS.rocket_turret.damageAmp;
    }
}

