/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.handler.config;

import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import omtteam.omlib.util.GeneralUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.api.lists.AmmoList;
import omtteam.openmodularturrets.api.lists.MobBlacklist;
import omtteam.openmodularturrets.handler.config.BaseSetting;
import omtteam.openmodularturrets.handler.config.TurretSetting;

@Config(modid="openmodularturrets", category="")
public class OMTConfig {
    @Config.Name(value="Turrets")
    public static ConfigTurrets TURRETS = new ConfigTurrets();
    @Config.Name(value="Bases")
    public static ConfigBases BASES = new ConfigBases();
    @Config.Name(value="General")
    public static ConfigGeneral GENERAL = new ConfigGeneral();
    @Config.Name(value="Miscellaneous")
    public static ConfigMisc MISCELLANEOUS = new ConfigMisc();

    public static void parseLists() {
        OMTConfig.parseDisposableAmmoList();
        OMTConfig.parseMobBlacklist();
    }

    private static void parseDisposableAmmoList() {
        try {
            for (String itemListEntry : OMTConfig.GENERAL.stringAmmoAllowList) {
                String[] item = itemListEntry.split(":");
                AmmoList.clear();
                if (item.length == 3) {
                    AmmoList.add(new ItemStack(GeneralUtil.getItem((String)item[0], (String)item[1]), 1, Integer.parseInt(item[2])));
                    continue;
                }
                AmmoList.add(new ItemStack(GeneralUtil.getItem((String)item[0], (String)item[1]), 2));
            }
        }
        catch (Exception e) {
            OpenModularTurrets.getLogger().error("error while parsing disp. ammo list config!");
            e.printStackTrace();
        }
    }

    private static void parseMobBlacklist() {
        try {
            if (OMTConfig.GENERAL.stringMobBlackList.length == 0) {
                return;
            }
            MobBlacklist.clear();
            for (String itemListEntry : OMTConfig.GENERAL.stringMobBlackList) {
                MobBlacklist.add(itemListEntry);
            }
        }
        catch (Exception e) {
            OpenModularTurrets.getLogger().error("error while parsing mob blacklist config!");
            e.printStackTrace();
        }
    }

    public static class ConfigBases {
        @Config.Name(value="Tier 1")
        public BaseSetting baseTierOne = new BaseSetting(500, 50, 1, 5, 20);
        @Config.Name(value="Tier 2")
        public BaseSetting baseTierTwo = new BaseSetting(50000, 100, 1, 10, 30);
        @Config.Name(value="Tier 3")
        public BaseSetting baseTierThree = new BaseSetting(150000, 1000, 2, 15, 40);
        @Config.Name(value="Tier 4")
        public BaseSetting baseTierFour = new BaseSetting(500000, 2500, 3, 20, 50);
        @Config.Name(value="Tier 5")
        public BaseSetting baseTierFive = new BaseSetting(10000000, 50000, 4, 25, 60);
        @Config.RequiresMcRestart
        public boolean allowBaseCamo = true;
        public boolean baseBreakable = false;
    }

    public static class ConfigTurrets {
        public boolean canRocketsHome = false;
        public boolean canRocketsHurtEnderDragon = false;
        public boolean canRocketsDestroyBlocks = false;
        public boolean canGrenadesDestroyBlocks = false;
        public boolean canRailgunDestroyBlocks = false;
        public boolean canTurretsConcealWithoutAddon = false;
        public boolean doTurretsNeedAmmo = true;
        @Config.Comment(value={"If turrets can target players"})
        public boolean globalCanTargetPlayers = true;
        @Config.Comment(value={"If turrets can target neutrals (cow, sheep etc.)"})
        public boolean globalCanTargetNeutrals = true;
        @Config.Comment(value={"If turrets can target hostile mobs"})
        public boolean globalCanTargetMobs = true;
        @Config.Comment(value={"If turrets should warn players with audible alarm if entering their warning range"})
        public boolean turretAlarmSound = true;
        @Config.Comment(value={"If turrets should be breakable with tools"})
        public boolean turretBreakable = false;
        @Config.Comment(value={"If trusted players get damage when accidentally hit"})
        public boolean turretDamageTrustedPlayers = false;
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.Comment(value={"Volume of the sound of firing turrets"})
        public double turretSoundVolume = 4.0;
        @Config.Comment(value={"How many ticks should a turret wait before searching for targets again"})
        @Config.RangeInt(min=1)
        public int turretTargetSearchTicks = 10;
        @Config.Comment(value={"If turrets should warn players with a message if entering their warning range"})
        public boolean turretWarnMessage = true;
        @Config.Comment(value={"The warning distance that is added to the range of the turret"})
        public int turretWarningDistance = 5;
        @Config.Name(value="Disposable Turret")
        public TurretSetting disposable_turret = new TurretSetting(true, 10, 25, 2, 2, 50.0, 4, 0.05, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Potato Cannon Turret")
        public TurretSetting potato_cannon_turret = new TurretSetting(true, 15, 35, 3, 10, 30.0, 4, 0.05, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Machine Gun Turret")
        public TurretSetting machine_gun_turret = new TurretSetting(true, 18, 8, 2, 100, 30.0, 4, 0.06, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Incendiary Turret")
        public TurretSetting incendiary_turret = new TurretSetting(true, 12, 25, 2, 250, 30.0, 4, 0.05, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Grenade Turret")
        public TurretSetting grenade_turret = new TurretSetting(true, 18, 40, 8, 3000, 30.0, 3, 0.08, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Relativistic Turret")
        public TurretSetting relativistic_turret = new TurretSetting(true, 20, 25, 0, 5000, 0.0, 4, 0.0, 0.1, 2, 0.0, 0.08, 0.1, 0.05);
        @Config.Name(value="Rocket Turret")
        public TurretSetting rocket_turret = new TurretSetting(true, 30, 30, 10, 5000, 10.0, 3, 0.08, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Teleporter Turret")
        public TurretSetting teleporter_turret = new TurretSetting(true, 20, 100, 0, 15000, 0.0, 1, 0.0, 0.1, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Laser Turret")
        public TurretSetting laser_turret = new TurretSetting(true, 25, 10, 4, 8000, 10.0, 4, 0.06, 0.125, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Railgun Turret")
        public TurretSetting railgun_turret = new TurretSetting(true, 30, 100, 25, 25000, 3.0, 2, 0.1, 0.2, 2, 0.2, 0.08, 0.1, 0.05);
        @Config.Name(value="Plasma Turret")
        public TurretSetting plasma_turret = new TurretSetting(true, 20, 60, 20, 40000, 8.0, 1, 0.1, 0.2, 1, 0.2, 0.08, 0.1, 0.05);
    }

    public static class ConfigMisc {
        @Config.RangeInt(min=1, max=2000000000)
        public int expanderPowerTierOneCapacity = 2500;
        @Config.RangeInt(min=1, max=2000000000)
        public int expanderPowerTierTwoCapacity = 25000;
        @Config.RangeInt(min=1, max=2000000000)
        public int expanderPowerTierThreeCapacity = 75000;
        @Config.RangeInt(min=1, max=2000000000)
        public int expanderPowerTierFourCapacity = 250000;
        @Config.RangeInt(min=1, max=2000000000)
        public int expanderPowerTierFiveCapacity = 5000000;
        @Config.RangeInt(min=0)
        public int solarPanelAddonGen = 10;
        @Config.RangeInt(min=0)
        public int redstoneReactorAddonGen = 1600;
    }

    public static class ConfigGeneral {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Which recipes to use. Valid values: auto, enderio, mekanism, vanilla"})
        public String recipes = "auto";
        @Config.Comment(value={"If turrets kills drop loot"})
        public boolean doTurretsKillsDropMobLoot = true;
        @Config.Comment(value={"If loot is disabled, do loot addons enable loot anyway?"})
        public boolean doLootAddonsOverrideMobLootSetting = true;
        @Config.Comment(value={"Use a whitelist for ammo (which items fit into ammo slots of base)?"})
        public boolean useWhitelistForAmmo = true;
        @Config.Comment(value={"If enabled: Which items fit into ammo slots of base besides mods own ammo items?"})
        public String[] stringAmmoAllowList = new String[]{"minecraft:cobblestone", "minecraft:planks"};
        @Config.Comment(value={"Which entities should not be targeted by turrets?"})
        public String[] stringMobBlackList = new String[]{"ArmorStand"};
    }
}

