/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.network.messages;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class MessageAdjustLightValue
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int value;

    public MessageAdjustLightValue() {
    }

    public MessageAdjustLightValue(int x, int y, int z, int value) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.value = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.value);
    }

    private int getX() {
        return this.x;
    }

    private int getY() {
        return this.y;
    }

    private int getZ() {
        return this.z;
    }

    public int getValue() {
        return this.value;
    }

    public static class MessageHandlerAdjustLightValue
    implements IMessageHandler<MessageAdjustLightValue, IMessage> {
        public IMessage onMessage(MessageAdjustLightValue messageIn, MessageContext ctxIn) {
            MessageAdjustLightValue message = messageIn;
            MessageContext ctx = ctxIn;
            ((WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_()).func_152344_a(() -> {
                World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                BlockPos pos = new BlockPos(message.getX(), message.getY(), message.getZ());
                TileEntity entity = world.func_175625_s(pos);
                TurretBase machine = null;
                if (entity instanceof TurretBase) {
                    machine = (TurretBase)entity;
                }
                if (machine != null && PlayerUtil.isPlayerAdmin((EntityPlayer)player, (IHasOwner)machine)) {
                    machine.getCamoSettings().setLightValue(message.value);
                    machine.informUpdate();
                    machine.updateCamoSettingsToPlayers();
                }
            });
            return null;
        }
    }
}

