/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.proxy.ClientProxy;
import omtteam.omlib.util.EnumMachineMode;
import omtteam.omlib.util.player.Player;
import omtteam.openmodularturrets.compatibility.valkyrienwarfare.VWUtil;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class MessageTurretBase
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int rfStorageCurrent;
    private int rfStorageMax;
    private int tier;
    private int camoBlockMeta;
    private int range;
    private int maxRange;
    private int kills;
    private int playerKills;
    private int lightValue;
    private int lightOpacity;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private boolean multiTargeting;
    private String camoBlockRegName;
    private List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    private EnumMachineMode mode;
    private Player owner;

    public MessageTurretBase() {
    }

    public MessageTurretBase(TileEntity tileEntity) {
        if (tileEntity instanceof TurretBase) {
            TurretBase base = (TurretBase)tileEntity;
            BlockPos pos = VWUtil.getTransformedBlockPos((TileEntity)base);
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
            this.tier = base.getTier();
            this.lightValue = base.getCamoSettings().getLightValue();
            this.lightOpacity = base.getCamoSettings().getLightOpacity();
            this.owner = base.getOwner();
            this.rfStorageCurrent = base.getEnergyStored(EnumFacing.DOWN);
            this.rfStorageMax = base.getMaxEnergyStored(EnumFacing.DOWN);
            this.attacksMobs = base.isAttacksMobs();
            this.attacksNeutrals = base.isAttacksNeutrals();
            this.attacksPlayers = base.isAttacksPlayers();
            this.multiTargeting = base.isMultiTargeting();
            this.trustedPlayers = base.getTrustManager().getTrustedPlayers();
            this.camoBlockRegName = Objects.requireNonNull(base.getCamoState().func_177230_c().getRegistryName()).toString();
            this.camoBlockMeta = base.getCamoState().func_177230_c().func_176201_c(base.getCamoState());
            this.range = base.getRange();
            this.maxRange = base.getMaxRange();
            this.mode = base.getMode();
            this.kills = base.getKills();
            this.playerKills = base.getPlayerKills();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.tier = buf.readInt();
        this.lightValue = buf.readInt();
        this.lightOpacity = buf.readInt();
        this.owner = Player.readFromByteBuf((ByteBuf)buf);
        this.rfStorageCurrent = buf.readInt();
        this.rfStorageMax = buf.readInt();
        this.range = buf.readInt();
        this.maxRange = buf.readInt();
        this.kills = buf.readInt();
        this.playerKills = buf.readInt();
        this.mode = EnumMachineMode.values()[buf.readInt()];
        this.attacksMobs = buf.readBoolean();
        this.attacksNeutrals = buf.readBoolean();
        this.attacksPlayers = buf.readBoolean();
        this.multiTargeting = buf.readBoolean();
        this.camoBlockRegName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.camoBlockMeta = buf.readInt();
        int lengthOfTPList = buf.readInt();
        if (lengthOfTPList > 0) {
            for (int i = 0; i < lengthOfTPList; ++i) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                TrustedPlayer trustedPlayer = new TrustedPlayer(name);
                trustedPlayer.setUuid(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)));
                trustedPlayer.setAccessLevel(EnumAccessLevel.values()[buf.readInt()]);
                this.trustedPlayers.add(trustedPlayer);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.tier);
        buf.writeInt(this.lightValue);
        buf.writeInt(this.lightOpacity);
        Player.writeToByteBuf((Player)this.owner, (ByteBuf)buf);
        buf.writeInt(this.rfStorageCurrent);
        buf.writeInt(this.rfStorageMax);
        buf.writeInt(this.range);
        buf.writeInt(this.maxRange);
        buf.writeInt(this.kills);
        buf.writeInt(this.playerKills);
        buf.writeInt(this.mode.ordinal());
        buf.writeBoolean(this.attacksMobs);
        buf.writeBoolean(this.attacksNeutrals);
        buf.writeBoolean(this.attacksPlayers);
        buf.writeBoolean(this.multiTargeting);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.camoBlockRegName);
        buf.writeInt(this.camoBlockMeta);
        buf.writeInt(this.trustedPlayers.size());
        if (this.trustedPlayers.size() > 0) {
            for (TrustedPlayer trustedPlayer : this.trustedPlayers) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)trustedPlayer.getName());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)trustedPlayer.getUuid().toString());
                buf.writeInt(trustedPlayer.getAccessLevel().ordinal());
            }
        }
    }

    public String toString() {
        return String.format("MessageTurretBase - x:%s, y:%s, z:%s, owner:%s, rfstorage:%s", this.x, this.y, this.z, this.owner, this.rfStorageCurrent);
    }

    public static class MessageHandlerTurretBase
    implements IMessageHandler<MessageTurretBase, IMessage> {
        public IMessage onMessage(MessageTurretBase messageIn, MessageContext ctx) {
            MessageTurretBase message = messageIn;
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity tileEntity = ClientProxy.getWorld((Minecraft)FMLClientHandler.instance().getClient()).func_175625_s(new BlockPos(message.x, message.y, message.z));
                if (tileEntity instanceof TurretBase) {
                    TurretBase base = (TurretBase)tileEntity;
                    OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
                    base.setOwner(message.owner);
                    if (storage != null) {
                        storage.setEnergyStored(message.rfStorageCurrent);
                        storage.setCapacity(message.rfStorageMax);
                    }
                    base.setAttacksMobs(message.attacksMobs);
                    base.setAttacksNeutrals(message.attacksNeutrals);
                    base.setAttacksPlayers(message.attacksPlayers);
                    base.setMultiTargeting(message.multiTargeting);
                    base.getTrustManager().setTrustedPlayers(message.trustedPlayers);
                    base.setTier(message.tier);
                    base.getCamoSettings().setLightValue(message.lightValue);
                    base.getCamoSettings().setLightOpacity(message.lightOpacity);
                    base.setMode(message.mode);
                    base.setCamoState(((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(message.camoBlockRegName)))).func_176203_a(message.camoBlockMeta));
                    base.getTargetingSettings().setRange(message.range);
                    base.getTargetingSettings().setMaxRange(message.maxRange);
                    base.setKills(message.kills);
                    base.setPlayerKills(message.playerKills);
                }
            });
            return null;
        }
    }
}

