/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import omtteam.omlib.tileentity.TileEntityContainer;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.MathUtil;
import omtteam.openmodularturrets.api.ITurretBaseAddonTileEntity;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.turret.TurretHeadUtil;
import omtteam.openmodularturrets.util.OMTUtil;

public class Expander
extends TileEntityContainer
implements ITickable,
ITurretBaseAddonTileEntity {
    protected IItemHandlerModifiable inventory;
    private boolean powerExpander;
    private EnumFacing orientation;
    private int tier;

    public Expander() {
        this.orientation = EnumFacing.NORTH;
        this.setupInventory();
    }

    public Expander(int tier, boolean powerExpander) {
        this.setupInventory();
        this.tier = tier;
        this.powerExpander = powerExpander;
        this.orientation = EnumFacing.NORTH;
    }

    protected void setupInventory() {
        this.inventory = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                Expander.this.func_70296_d();
            }

            public boolean isItemValidForSlot(ItemStack stack) {
                return !Expander.this.isPowerExpander() && OMTUtil.isItemStackValidAmmo(stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            public int getSlotLimit(int slot) {
                return MathUtil.truncateDoubleToInt((double)Math.pow(2.0, Expander.this.tier + 2));
            }
        };
    }

    public RangedWrapper getCapabilityInventory(EnumFacing facing) {
        return new RangedWrapper(this.inventory, 0, 9);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("powerExpander", this.powerExpander);
        nbtTagCompound.func_74774_a("direction", (byte)this.orientation.ordinal());
        nbtTagCompound.func_74768_a("tier", this.tier);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.powerExpander = nbtTagCompound.func_74767_n("powerExpander");
        this.tier = nbtTagCompound.func_74762_e("tier");
        if (nbtTagCompound.func_74764_b("direction")) {
            this.setOrientation(EnumFacing.func_82600_a((int)nbtTagCompound.func_74771_c("direction")));
        }
    }

    public void setSide() {
        this.setOrientation(TurretHeadUtil.getTurretBaseFacing(this.func_145831_w(), this.field_174879_c));
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_72820_D() % 15L == 0L && this.dropBlock) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
        }
    }

    public int getTier() {
        return this.tier;
    }

    public TurretBase getBase() {
        return TurretHeadUtil.getTurretBase(this.func_145831_w(), this.field_174879_c);
    }

    public boolean isPowerExpander() {
        return this.powerExpander;
    }

    public EnumFacing getOrientation() {
        return this.orientation;
    }

    private void setOrientation(EnumFacing orientation) {
        this.orientation = orientation;
    }

    @Nonnull
    public TileEntityOwnedBlock getLinkedBlock() {
        return this.getBase();
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }
}

