/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import omtteam.omlib.api.network.INetworkTile;
import omtteam.omlib.api.network.IPowerExchangeTile;
import omtteam.omlib.api.network.OMLibNetwork;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.api.render.camo.ICamoSupport;
import omtteam.omlib.api.tile.IDebugTile;
import omtteam.omlib.api.tile.IHasTargetingSettings;
import omtteam.omlib.compatibility.OMLibModCompatibility;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageCamoSettings;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.tileentity.TileEntityTrustedMachine;
import omtteam.omlib.util.EnumMachineMode;
import omtteam.omlib.util.NetworkUtil;
import omtteam.omlib.util.TargetingSettings;
import omtteam.omlib.util.camo.CamoSettings;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.omlib.util.world.WorldUtil;
import omtteam.openmodularturrets.api.network.IBaseController;
import omtteam.openmodularturrets.handler.OMTNetworkingHandler;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.network.messages.MessageTurretBase;
import omtteam.openmodularturrets.tileentity.turrets.AbstractDirectedTurret;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.turret.TurretHeadUtil;
import omtteam.openmodularturrets.util.OMTUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public class TurretBase
extends TileEntityTrustedMachine
implements IPeripheral,
ICamoSupport,
IDebugTile,
IPowerExchangeTile,
INetworkTile,
ITickable,
IHasTargetingSettings {
    public boolean shouldConcealTurrets;
    protected CamoSettings camoSettings;
    protected int tier;
    protected IItemHandlerModifiable inventory;
    protected FluidTank tank;
    private IBlockState camoBlockStateTemp;
    private boolean multiTargeting = false;
    private TargetingSettings targetingSettings;
    private int ticks;
    private boolean forceFire = false;
    private int kills;
    private int playerKills;
    private IBaseController controller;
    private OMLibNetwork network;
    private final List<EntityPlayerMP> openClients = new ArrayList<EntityPlayerMP>();

    public TurretBase(int MaxEnergyStorage, int MaxIO, int tier, IBlockState camoState) {
        this.storage = new OMEnergyStorage(MaxEnergyStorage, MaxIO);
        this.targetingSettings = new TargetingSettings(false, true, false, 0, 0);
        this.tier = tier;
        this.camoBlockStateTemp = camoState;
        this.mode = EnumMachineMode.INVERTED;
        this.camoSettings = new CamoSettings();
        this.setupInventory();
    }

    public TurretBase() {
        this.setupInventory();
    }

    private static void updateRedstoneReactor(TurretBase base) {
        OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (!TurretHeadUtil.hasRedstoneReactor(base) || storage == null) {
            return;
        }
        if (OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen * 9 < storage.getMaxEnergyStored() - storage.getEnergyStored()) {
            ItemStack redstoneBlock = TurretHeadUtil.getSpecificItemStackFromBase(base, new ItemStack(Blocks.field_150451_bX));
            if (redstoneBlock == ItemStack.field_190927_a) {
                redstoneBlock = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Blocks.field_150451_bX), base, null);
            }
            if (redstoneBlock != ItemStack.field_190927_a) {
                base.storage.modifyEnergyStored(OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen * 9);
                return;
            }
        }
        if (OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen < storage.getMaxEnergyStored() - storage.getEnergyStored()) {
            ItemStack redstone = TurretHeadUtil.getSpecificItemStackFromBase(base, new ItemStack(Items.field_151137_ax));
            if (redstone == ItemStack.field_190927_a) {
                redstone = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Items.field_151137_ax), base, null);
            }
            if (redstone != ItemStack.field_190927_a) {
                storage.modifyEnergyStored(OMTConfig.MISCELLANEOUS.redstoneReactorAddonGen);
            }
        }
    }

    public IItemHandler getCapabilityInventory(EnumFacing facing) {
        return new RangedWrapper(this.inventory, 0, 9);
    }

    protected void setupInventory() {
        this.inventory = new ItemStackHandler(13){

            public boolean isItemValidForSlot(int index, ItemStack stack) {
                if (index < 9) {
                    return OMTUtil.isItemStackValidAmmo(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected void setupTank() {
        this.tank = new FluidTank(4000){

            public boolean canFillFluidType(FluidStack fluid) {
                return super.canFillFluidType(fluid);
            }

            public boolean canDrain() {
                return false;
            }
        };
    }

    @Nonnull
    public CamoSettings getCamoSettings() {
        return this.camoSettings == null ? new CamoSettings() : this.camoSettings;
    }

    @Nonnull
    public IBlockState getDefaultCamoState() {
        Block base = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("openmodularturrets:turret_base"));
        return base.func_176203_a(this.tier - 1);
    }

    @Nonnull
    public IBlockState getCamoState() {
        return this.getCamoSettings().getCamoBlockState() != null && this.getCamoSettings().getCamoBlockState() instanceof IExtendedBlockState ? (IExtendedBlockState)this.getCamoSettings().getCamoBlockState() : (this.getCamoSettings().getCamoBlockState() != null ? this.getCamoSettings().getCamoBlockState().func_177230_c().getExtendedState(this.getCamoSettings().getCamoBlockState(), (IBlockAccess)this.func_145831_w(), this.func_174877_v()) : this.getDefaultCamoState());
    }

    public void setCamoState(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            if (this.getCamoState() == state.func_177230_c().getExtendedState(state, (IBlockAccess)this.func_145831_w(), this.func_174877_v())) {
                return;
            }
            this.getCamoSettings().setCamoBlockState(state.func_177230_c().getExtendedState(state, (IBlockAccess)this.func_145831_w(), this.func_174877_v()));
        } else {
            if (this.getCamoState() == state) {
                return;
            }
            this.getCamoSettings().setCamoBlockState(state);
        }
        this.camoBlockStateTemp = state;
        if (!this.field_145850_b.field_72995_K) {
            OMLibNetworkingHandler.INSTANCE.sendToAllTracking((IMessage)new MessageCamoSettings((ICamoSupport)this), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 80.0));
            this.setUpdateNBT(true);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("shouldConcealTurrets", this.shouldConcealTurrets);
        tag.func_74757_a("multiTargeting", this.multiTargeting);
        tag.func_74757_a("forceFire", this.forceFire);
        tag.func_74768_a("tier", this.tier);
        tag.func_74768_a("mode", this.mode.ordinal());
        tag.func_74768_a("kills", this.kills);
        this.targetingSettings.writeToNBT(tag);
        this.camoSettings.writeNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.targetingSettings = TargetingSettings.readFromNBT((NBTTagCompound)tag);
        this.shouldConcealTurrets = tag.func_74767_n("shouldConcealTurrets");
        this.multiTargeting = tag.func_74767_n("multiTargeting");
        this.forceFire = tag.func_74767_n("forceFire");
        this.tier = tag.func_74762_e("tier");
        this.mode = tag.func_74764_b("mode") ? EnumMachineMode.values()[tag.func_74762_e("mode")] : EnumMachineMode.INVERTED;
        this.camoSettings = CamoSettings.getSettingsFromNBT((NBTTagCompound)tag);
        this.camoBlockStateTemp = this.camoSettings.getCamoBlockState() != null ? this.camoSettings.getCamoBlockState() : this.getDefaultCamoState();
        this.kills = tag.func_74764_b("kills") ? tag.func_74762_e("kills") : 0;
        if (tag.func_74764_b("playerKills")) {
            this.kills = tag.func_74762_e("playerKills");
        } else {
            this.playerKills = 0;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.camoBlockStateTemp instanceof IExtendedBlockState) {
            this.camoSettings.setCamoBlockState(this.camoBlockStateTemp);
        } else {
            this.setCamoState(this.camoBlockStateTemp.func_177230_c().getExtendedState(this.camoBlockStateTemp, (IBlockAccess)this.func_145831_w(), this.func_174877_v()));
        }
        this.updateNBT = true;
    }

    public List<EntityPlayerMP> getSyncPlayerList() {
        return this.openClients;
    }

    public TileEntity getTE() {
        return this;
    }

    public void informUpdate() {
        OMTNetworkingHandler.INSTANCE.sendToAllTracking((IMessage)new MessageTurretBase((TileEntity)this), NetworkUtil.getTargetPointFromBlockPos((int)this.func_145831_w().field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)100.0));
    }

    private void updateControllerSettings() {
        if (this.controller != null) {
            this.targetingSettings = this.controller.getTargetingSettings();
        }
    }

    public List<String> getDebugInfo() {
        ArrayList<String> debugInfo = new ArrayList<String>();
        debugInfo.add("Camo: " + this.camoSettings.getCamoBlockState().func_177230_c().getRegistryName());
        debugInfo.add("Force Fire: " + this.forceFire + ", UpperMaxRange: " + this.targetingSettings.getMaxRange());
        return debugInfo;
    }

    @Nonnull
    public TileEntityOwnedBlock getOwnedBlock() {
        return this;
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.dropBlock) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
            return;
        }
        if (!this.func_145831_w().field_72995_K && this.updateNBT) {
            this.markBlockForUpdate();
            this.informUpdate();
            this.updateNBT = false;
        }
        if (!this.func_145831_w().field_72995_K) {
            for (EntityPlayerMP player : this.openClients) {
                OMTNetworkingHandler.INSTANCE.sendTo((IMessage)new MessageTurretBase((TileEntity)this), player);
            }
        }
        ++this.ticks;
        if (!this.func_145831_w().field_72995_K && this.ticks % 5 == 0) {
            this.updateControllerSettings();
            this.shouldConcealTurrets = TurretHeadUtil.hasConcealmentAddon(this);
            this.storage.setCapacity(this.getMaxEnergyStorageWithExtenders());
            if (this.ticks % 20 == 0) {
                this.ticks = 0;
                TurretBase.updateRedstoneReactor(this);
                if (this.targetingSettings.getRange() > this.targetingSettings.getMaxRange()) {
                    this.targetingSettings.setRange(this.targetingSettings.getMaxRange());
                }
                this.scrubSyncPlayerList();
            }
        }
    }

    public NBTTagCompound writeMemoryCardNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.targetingSettings.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74757_a("multiTargeting", this.multiTargeting);
        nbtTagCompound.func_74768_a("mode", this.mode.ordinal());
        NBTTagCompound trustedPlayers = new NBTTagCompound();
        nbtTagCompound.func_74782_a("trustedPlayers", (NBTBase)this.getTrustManager().writeToNBT(trustedPlayers));
        return nbtTagCompound;
    }

    public void readMemoryCardNBT(NBTTagCompound nbtTagCompound) {
        this.multiTargeting = nbtTagCompound.func_74767_n("multiTargeting");
        this.mode = nbtTagCompound.func_74764_b("mode") ? EnumMachineMode.values()[nbtTagCompound.func_74762_e("mode")] : EnumMachineMode.INVERTED;
        this.targetingSettings = TargetingSettings.readFromNBT((NBTTagCompound)nbtTagCompound);
        if (nbtTagCompound.func_74764_b("trustedPlayers")) {
            this.getTrustManager().readFromNBT((NBTTagCompound)nbtTagCompound.func_74781_a("trustedPlayers"));
        }
    }

    public void updateMaxRange() {
        int maxRange = 0;
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        for (TileEntity te : tileEntities) {
            if (!(te instanceof TurretHead)) continue;
            maxRange = Math.max(((TurretHead)te).getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this, (TurretHead)te), maxRange);
        }
        this.targetingSettings.setMaxRange(maxRange);
    }

    public void turretResetCaches() {
        for (TurretHead turretHead : WorldUtil.getTouchingTileEntitiesByClass((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), TurretHead.class)) {
            turretHead.triggerResetCaches();
        }
    }

    @Nullable
    public FluidTank getTank() {
        return this.tank;
    }

    @Nullable
    public FluidTank getCapabilityTank(EnumFacing facing) {
        return this.tank;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public boolean isActive() {
        boolean changedActive = false;
        if (this.controller != null && this.controller.overridesMode() && this.controller.getOverriddenMode() != this.mode) {
            this.refreshActive(this.controller.getOverriddenMode());
            changedActive = true;
        }
        if (!changedActive) {
            this.refreshActive(this.mode);
        }
        return this.active;
    }

    public boolean isAttacksMobs() {
        return this.targetingSettings.isTargetMobs();
    }

    public void setAttacksMobs(boolean attacksMobs) {
        this.targetingSettings.setTargetMobs(attacksMobs);
    }

    public boolean isAttacksNeutrals() {
        return this.targetingSettings.isTargetPassive();
    }

    public void setAttacksNeutrals(boolean attacksNeutrals) {
        this.targetingSettings.setTargetPassive(attacksNeutrals);
    }

    public boolean isAttacksPlayers() {
        return this.targetingSettings.isTargetPlayers();
    }

    public void setAttacksPlayers(boolean attacksPlayers) {
        this.targetingSettings.setTargetPlayers(attacksPlayers);
    }

    public boolean isMultiTargeting() {
        return this.multiTargeting;
    }

    public void setMultiTargeting(boolean multiTargeting) {
        this.multiTargeting = multiTargeting;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean isComputerAccessible() {
        return !(!OMLibModCompatibility.OpenComputersLoaded && !OMLibModCompatibility.ComputerCraftLoaded || this.tier != 5 && !TurretHeadUtil.hasSerialPortAddon(this));
    }

    public void increaseKillCounter() {
        ++this.kills;
    }

    public void increasePlayerKillCounter() {
        ++this.playerKills;
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }

    public int getPlayerKills() {
        return this.playerKills;
    }

    public void setPlayerKills(int playerKills) {
        this.playerKills = playerKills;
    }

    public int getRange() {
        return this.targetingSettings.getRange();
    }

    public void setRange(int range) {
        this.updateMaxRange();
        this.targetingSettings.setRange(range);
    }

    public int getMaxRange() {
        return this.targetingSettings.getMaxRange();
    }

    public void setMaxRange(int range) {
        this.targetingSettings.setMaxRange(range);
    }

    @Nullable
    public IBaseController getController() {
        return this.controller;
    }

    private int getMaxEnergyStorageWithExtenders() {
        int tier = this.getTier();
        switch (tier) {
            case 1: {
                return OMTConfig.BASES.baseTierOne.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 2: {
                return OMTConfig.BASES.baseTierTwo.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 3: {
                return OMTConfig.BASES.baseTierThree.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 4: {
                return OMTConfig.BASES.baseTierFour.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 5: {
                return OMTConfig.BASES.baseTierFive.baseMaxCharge + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
        }
        return 0;
    }

    public TargetingSettings getTargetingSettings() {
        return this.targetingSettings;
    }

    public void setTargetingSettings(TargetingSettings targetingSettings) {
        this.targetingSettings = targetingSettings;
    }

    public boolean registerController(IBaseController controller) {
        if (this.controller != null) {
            return false;
        }
        this.controller = controller;
        return true;
    }

    public List<EntityLivingBase> getEntitiesWithinRange() {
        AxisAlignedBB axis = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.targetingSettings.getRange() - 1), (double)(this.field_174879_c.func_177956_o() - this.targetingSettings.getRange() - 1), (double)(this.field_174879_c.func_177952_p() - this.targetingSettings.getRange() - 1), (double)(this.field_174879_c.func_177958_n() + this.targetingSettings.getRange() + 1), (double)(this.field_174879_c.func_177956_o() + this.targetingSettings.getRange() + 1), (double)(this.field_174879_c.func_177952_p() + this.targetingSettings.getRange() + 1));
        return this.func_145831_w().func_72872_a(EntityLivingBase.class, axis);
    }

    public void setAllTurretsYawPitch(float yaw, float pitch) {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        for (TileEntity te : tileEntities) {
            if (!(te instanceof AbstractDirectedTurret)) continue;
            ((AbstractDirectedTurret)te).setPitch(pitch);
            ((AbstractDirectedTurret)te).setYaw(yaw);
        }
    }

    public boolean setTurretYawPitch(EnumFacing facing, float yaw, float pitch) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (turretHead instanceof AbstractDirectedTurret) {
            ((AbstractDirectedTurret)turretHead).setPitch(pitch);
            ((AbstractDirectedTurret)turretHead).setYaw(yaw);
            return true;
        }
        return false;
    }

    public void setAllTurretsForceFire(boolean state) {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        for (TileEntity te : tileEntities) {
            if (!(te instanceof TurretHead)) continue;
            ((TurretHead)te).setAutoFire(state);
        }
    }

    public boolean setTurretForceFire(EnumFacing facing, boolean state) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (turretHead instanceof TurretHead) {
            ((TurretHead)turretHead).setAutoFire(state);
            return true;
        }
        return false;
    }

    public boolean forceShootTurret(EnumFacing facing) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        return turretHead instanceof AbstractDirectedTurret && ((AbstractDirectedTurret)turretHead).forceShot();
    }

    public int forceShootAllTurrets() {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        int successes = 0;
        for (TileEntity te : tileEntities) {
            if (!(te instanceof AbstractDirectedTurret)) continue;
            successes += ((AbstractDirectedTurret)te).forceShot() ? 1 : 0;
        }
        return successes;
    }

    public boolean requiresEnergy() {
        return true;
    }

    public boolean deliversEnergy() {
        return false;
    }

    public OMEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Nullable
    public OMLibNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(OMLibNetwork network) {
        this.network = network;
    }

    @Nonnull
    public String getDeviceName() {
        return "TurretBase";
    }

    @Optional.Method(modid="computercraft")
    @Nonnull
    public String getType() {
        return "turret_base";
    }

    @Optional.Method(modid="computercraft")
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{commands.getOwner.toString(), commands.isAttacksPlayers.toString(), commands.setAttacksPlayers.toString(), commands.isAttacksMobs.toString(), commands.setAttacksMobs.toString(), commands.isAttacksNeutrals.toString(), commands.setAttacksNeutrals.toString(), commands.getTrustedPlayers.toString(), commands.getTrustedPlayer.toString(), commands.addTrustedPlayer.toString(), commands.removeTrustedPlayer.toString(), commands.changeAccessLevel.toString(), commands.getActive.toString(), commands.getMode.toString(), commands.getRedstone.toString(), commands.setMode.toString(), commands.getType.toString(), commands.setAllAutoForceFire.toString(), commands.setTurretAutoForceFire.toString(), commands.forceShootAllTurrets.toString(), commands.forceShootTurret.toString(), commands.setAllYawPitch.toString(), commands.setTurretYawPitch.toString(), commands.getMaxEnergyStorage.toString(), commands.getCurrentEnergyStorage.toString()};
    }

    @Optional.Method(modid="computercraft")
    @ParametersAreNonnullByDefault
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        if (!this.isComputerAccessible()) {
            return new Object[]{"Computer access deactivated!"};
        }
        switch (commands.values()[method]) {
            case getOwner: {
                return new Object[]{this.getOwner().getName()};
            }
            case isAttacksPlayers: {
                return new Object[]{this.targetingSettings.isTargetPlayers()};
            }
            case setAttacksPlayers: {
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"Wrong parameters!"};
                }
                boolean b = arguments[0].toString().equals("true");
                this.targetingSettings.setTargetPlayers(b);
                return new Object[]{true};
            }
            case isAttacksMobs: {
                return new Object[]{this.targetingSettings.isTargetMobs()};
            }
            case setAttacksMobs: {
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"Wrong parameters!"};
                }
                boolean b = arguments[0].toString().equals("true");
                this.targetingSettings.setTargetMobs(b);
                return new Object[]{true};
            }
            case isAttacksNeutrals: {
                return new Object[]{this.targetingSettings.isTargetPassive()};
            }
            case setAttacksNeutrals: {
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"Wrong parameters!"};
                }
                boolean b = arguments[0].toString().equals("true");
                this.targetingSettings.setTargetPassive(b);
                return new Object[]{true};
            }
            case getTrustedPlayers: {
                return new Object[]{this.getTrustManager().getTrustedPlayersAsListMap()};
            }
            case getTrustedPlayer: {
                if (this.getTrustManager().getTrustedPlayer(arguments[0].toString()) != null) {
                    return new Object[]{this.getTrustManager().getTrustedPlayer(arguments[0].toString()).asMap()};
                }
            }
            case addTrustedPlayer: {
                if (arguments[0].toString().equals("")) {
                    return new Object[]{"Wrong parameters!"};
                }
                if (!this.getTrustManager().addTrustedPlayer(arguments[0].toString())) {
                    return new Object[]{"Name not valid!"};
                }
                if (arguments[1].toString().equals("")) {
                    return new Object[]{"successfully added"};
                }
                if (!(arguments[1] instanceof Integer)) {
                    return new Object[]{"Wrong parameters!"};
                }
                TrustedPlayer trustedPlayer = this.getTrustManager().getTrustedPlayer(arguments[0].toString());
                trustedPlayer.setAccessLevel(EnumAccessLevel.values()[(Integer)arguments[1]]);
                trustedPlayer.setUuid(PlayerUtil.getPlayerUUID((String)arguments[0].toString()));
                return new Object[]{true};
            }
            case removeTrustedPlayer: {
                if (arguments[0].toString().equals("")) {
                    return new Object[]{"Wrong parameters!"};
                }
                this.getTrustManager().removeTrustedPlayer(arguments[0].toString());
                return new Object[]{true};
            }
            case changeAccessLevel: {
                if (this.getTrustManager().getTrustedPlayer(arguments[0].toString()) == null) {
                    return new Object[]{"Not found!"};
                }
                if (!(arguments[1] instanceof Integer) || (Integer)arguments[1] < 0 || (Integer)arguments[1] > 3) {
                    return new Object[]{"Invalid Access Level!"};
                }
                TrustedPlayer trustedPlayer = this.getTrustManager().getTrustedPlayer(arguments[0].toString());
                trustedPlayer.setAccessLevel(EnumAccessLevel.values()[(Integer)arguments[1]]);
                return new Object[]{true};
            }
            case getActive: {
                return new Object[]{this.active};
            }
            case getMode: {
                return new Object[]{this.mode.getName()};
            }
            case getRedstone: {
                return new Object[]{this.redstone};
            }
            case setMode: {
                String arg = arguments[0].toString();
                if (!(arg.equals("0") || arg.equals("1") || arg.equals("2") || arg.equals("3"))) {
                    return new Object[]{"Wrong parameters! expects number between 0 and 3"};
                }
                int mode = Integer.parseInt(arguments[0].toString());
                this.setMode(EnumMachineMode.values()[mode]);
                return new Object[]{true};
            }
            case getType: {
                return new Object[]{this.getType()};
            }
            case setAllAutoForceFire: {
                if (!arguments[0].toString().equals("true") && !arguments[0].toString().equals("false")) {
                    return new Object[]{"Wrong parameters!"};
                }
                boolean b = arguments[0].toString().equals("true");
                this.setAllTurretsForceFire(b);
                return new Object[]{true};
            }
            case setTurretAutoForceFire: {
                try {
                    int t = Integer.parseInt(arguments[0].toString());
                    if (t >= 0 && t <= 6 || !arguments[1].toString().equals("true") && !arguments[1].toString().equals("false")) {
                        return new Object[]{"Wrong parameters!"};
                    }
                    return new Object[]{this.setTurretForceFire(EnumFacing.func_82600_a((int)t), Boolean.parseBoolean(arguments[1].toString()))};
                }
                catch (Exception e) {
                    return new Object[]{"Wrong parameters!"};
                }
            }
            case forceShootAllTurrets: {
                return new Object[]{this.forceShootAllTurrets()};
            }
            case forceShootTurret: {
                try {
                    int t = Integer.parseInt(arguments[0].toString());
                    if (t >= 0 && t <= 6) {
                        return new Object[]{"Wrong parameters!"};
                    }
                    return new Object[]{this.forceShootTurret(EnumFacing.func_82600_a((int)t))};
                }
                catch (Exception e) {
                    return new Object[]{"Wrong parameters!"};
                }
            }
            case setAllYawPitch: {
                try {
                    this.setAllTurretsYawPitch(Float.parseFloat(arguments[0].toString()), Float.parseFloat(arguments[1].toString()));
                    return new Object[]{"set yaw and pitch successfully"};
                }
                catch (Exception e) {
                    return new Object[]{"Wrong parameters!"};
                }
            }
            case setTurretYawPitch: {
                try {
                    this.setTurretYawPitch(EnumFacing.func_82600_a((int)Integer.parseInt(arguments[0].toString())), Float.parseFloat(arguments[1].toString()), Float.parseFloat(arguments[2].toString()));
                    return new Object[]{"setting successful"};
                }
                catch (Exception e) {
                    return new Object[]{"Wrong parameters!"};
                }
            }
            case getMaxEnergyStorage: {
                return new Object[]{this.getMaxEnergyStorageWithExtenders()};
            }
            case getCurrentEnergyStorage: {
                return new Object[]{this.getEnergyStored(null)};
            }
        }
        return new Object[]{"Nonexisting command"};
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        return other.getType().equals(this.getType());
    }

    @Optional.Method(modid="computercraft")
    public void attach(@Nonnull IComputerAccess computer) {
    }

    @Optional.Method(modid="computercraft")
    public void detach(@Nonnull IComputerAccess computer) {
    }

    public static enum commands {
        getOwner,
        isAttacksPlayers,
        setAttacksPlayers,
        isAttacksMobs,
        setAttacksMobs,
        isAttacksNeutrals,
        setAttacksNeutrals,
        getTrustedPlayers,
        getTrustedPlayer,
        addTrustedPlayer,
        removeTrustedPlayer,
        changeAccessLevel,
        getActive,
        getMode,
        getRedstone,
        setMode,
        getType,
        setAllAutoForceFire,
        setTurretAutoForceFire,
        forceShootAllTurrets,
        forceShootTurret,
        setAllYawPitch,
        setTurretYawPitch,
        getMaxEnergyStorage,
        getCurrentEnergyStorage;

    }
}

