/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.tileentity.TileEntityBase;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.TargetingSettings;
import omtteam.openmodularturrets.api.ITurretBaseAddonTileEntity;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.turret.EnumTargetingPriority;
import omtteam.openmodularturrets.turret.TurretHeadUtil;
import omtteam.openmodularturrets.turret.TurretTargetingUtils;
import omtteam.openmodularturrets.turret.TurretType;

public abstract class TurretHead
extends TileEntityBase
implements ITickable,
ITurretBaseAddonTileEntity {
    public float baseFitRotationX;
    public float baseFitRotationZ;
    public EntityLivingBase target = null;
    public float rotationAnimation = 0.0f;
    public boolean shouldConceal = false;
    protected TurretBase base;
    protected int ticks;
    protected int targetingTicks;
    protected int turretTier;
    protected boolean hasSetSide = false;
    protected boolean playedDeploy = false;
    protected boolean autoFire = false;
    protected int ticksWithoutTarget;
    protected double targetLastX = 0.0;
    protected double targetLastY = 0.0;
    protected double targetLastZ = 0.0;
    protected double targetSpeedX = 0.0;
    protected double targetSpeedY = 0.0;
    protected double targetSpeedZ = 0.0;
    protected double cachedAccuracy = 0.0;
    protected int cachedScattershot = 0;
    private boolean resetCaches;
    Integer[] priorities;
    private EnumFacing turretBase;

    public TurretHead(int turretTier) {
        this.turretTier = turretTier;
        this.resetCaches = true;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 2, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound var1 = pkt.func_148857_g();
        this.func_145839_a(var1);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("ticksBeforeFire", this.ticks);
        nbtTagCompound.func_74757_a("shouldConceal", this.shouldConceal);
        nbtTagCompound.func_74757_a("autoFire", this.autoFire);
        if (this.priorities.length != 0) {
            nbtTagCompound.func_74768_a("priorityMaxHP", this.priorities[EnumTargetingPriority.MAX_HP.ordinal()].intValue());
            nbtTagCompound.func_74768_a("priorityHPRemaining", this.priorities[EnumTargetingPriority.HP_REMAINING.ordinal()].intValue());
            nbtTagCompound.func_74768_a("priorityDistance", this.priorities[EnumTargetingPriority.DISTANCE.ordinal()].intValue());
            nbtTagCompound.func_74768_a("priorityArmor", this.priorities[EnumTargetingPriority.ARMOR.ordinal()].intValue());
            nbtTagCompound.func_74768_a("priorityPlayer", this.priorities[EnumTargetingPriority.PLAYER.ordinal()].intValue());
        }
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.ticks = nbtTagCompound.func_74762_e("ticksBeforeFire");
        this.shouldConceal = nbtTagCompound.func_74767_n("shouldConceal");
        this.autoFire = nbtTagCompound.func_74767_n("autoFire");
        this.priorities = nbtTagCompound.func_74764_b("priorityMaxHP") ? new Integer[]{nbtTagCompound.func_74762_e("priorityMaxHP"), nbtTagCompound.func_74762_e("priorityHPRemaining"), nbtTagCompound.func_74762_e("priorityDistance"), nbtTagCompound.func_74762_e("priorityArmor"), nbtTagCompound.func_74762_e("priorityPlayer")} : this.getDefaultPriorities();
    }

    @Nonnull
    public TileEntityOwnedBlock getLinkedBlock() {
        return this.base;
    }

    protected boolean setSide() {
        if (this.hasSetSide && !this.func_145831_w().func_175667_e(this.func_174877_v().func_177972_a(this.turretBase))) {
            return false;
        }
        if (this.hasSetSide) {
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177974_f()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177974_f()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 1.565f;
            this.turretBase = EnumFacing.EAST;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177976_e()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177976_e()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 4.705f;
            this.turretBase = EnumFacing.WEST;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177968_d()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177968_d()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 3.145f;
            this.turretBase = EnumFacing.SOUTH;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177978_c()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177978_c()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.NORTH;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177984_a()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a()) instanceof TurretBase) {
            this.baseFitRotationX = 3.145f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.UP;
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177977_b()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b()) instanceof TurretBase) {
            this.baseFitRotationX = 0.0f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.DOWN;
            this.hasSetSide = true;
            return true;
        }
        return false;
    }

    protected EntityLivingBase getTarget() {
        TurretTargetingUtils selector = new TurretTargetingUtils(this);
        if (!this.func_145831_w().field_72995_K && this.base != null) {
            AxisAlignedBB axis = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.base.getRange() - 1), (double)(this.field_174879_c.func_177956_o() - this.base.getRange() - 1), (double)(this.field_174879_c.func_177952_p() - this.base.getRange() - 1), (double)(this.field_174879_c.func_177958_n() + this.base.getRange() + 1), (double)(this.field_174879_c.func_177956_o() + this.base.getRange() + 1), (double)(this.field_174879_c.func_177952_p() + this.base.getRange() + 1));
            List targets = this.func_145831_w().func_72872_a(EntityLivingBase.class, axis);
            return selector.getBestEntity(targets);
        }
        return null;
    }

    public TargetingSettings getTargetingSettings() {
        return this.base.getTargetingSettings();
    }

    public Integer[] getPriorities() {
        if (this.priorities != null) {
            return this.priorities;
        }
        return this.getDefaultPriorities();
    }

    TurretBase getBaseFromWorld() {
        return TurretHeadUtil.getTurretBase(this.func_145831_w(), this.field_174879_c);
    }

    public TurretBase getBase() {
        return this.base;
    }

    protected boolean isOnCooldown() {
        return (float)this.ticks < (float)this.getTurretBaseFireRate() / (1.0f + TurretHeadUtil.getFireRateUpgrades(this.base, this));
    }

    public boolean getAutoFire() {
        return this.autoFire;
    }

    public void setAutoFire(boolean autoFire) {
        this.autoFire = autoFire;
    }

    public int getTurretBasePowerUsage() {
        return this.getTurretType().getSettings().powerUsage;
    }

    public int getTurretBaseFireRate() {
        return this.getTurretType().getSettings().baseFireRate;
    }

    public double getBaseTurretAccuracyDeviation() {
        return this.getTurretType().getSettings().baseAccuracyDeviation;
    }

    public int getTurretBaseRange() {
        return this.getTurretType().getSettings().baseRange;
    }

    public double getTurretDamageAmpBonus() {
        return this.getTurretType().getSettings().damageAmp;
    }

    public double getActualTurretAccuracyDeviation() {
        if (this.resetCaches) {
            this.cachedAccuracy = this.getBaseTurretAccuracyDeviation() / Math.pow(1.0f + TurretHeadUtil.getAccuracyUpgrades(this.getBase(), this), 1.5) * (double)(1.0f + (float)TurretHeadUtil.getScattershotUpgrades(this.getBase()) / 10.0f);
        }
        return this.cachedAccuracy;
    }

    public void triggerResetCaches() {
        this.resetCaches = true;
    }

    public boolean isEntityValidTarget(EntityLivingBase entity) {
        return true;
    }

    protected abstract Integer[] getDefaultPriorities();

    protected abstract boolean requiresAmmo();

    protected abstract boolean requiresSpecificAmmo();

    public TurretType getTurretType() {
        BlockAbstractTurretHead block = (BlockAbstractTurretHead)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c();
        return block.getTurretType();
    }

    @Nullable
    public abstract ItemStack getAmmo();

    @Nonnull
    protected abstract SoundEvent getLaunchSoundEffect();

    protected int getPowerRequiredForNextShot() {
        return Math.round((float)this.getTurretBasePowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base, this)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
    }

    protected ItemStack getAmmoStack() {
        ItemStack ammo;
        block4: {
            ammo = ItemStack.field_190927_a;
            if (!this.requiresAmmo() || !OMTConfig.TURRETS.doTurretsNeedAmmo) break block4;
            if (this.requiresSpecificAmmo()) {
                for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                    ammo = TurretHeadUtil.getSpecificItemStackFromBase(this.base, this.getAmmo(), this);
                    if (ammo != ItemStack.field_190927_a) continue;
                    ammo = TurretHeadUtil.getSpecificItemFromInvExpanders(this.func_145831_w(), this.getAmmo(), this.base, this);
                }
            } else {
                for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                    ammo = TurretHeadUtil.getDisposableAmmoFromBase(this.base);
                    if (ammo != ItemStack.field_190927_a) continue;
                    ammo = TurretHeadUtil.getDisposableAmmoFromInvExpander(this.func_145831_w(), this.base);
                }
            }
        }
        return ammo;
    }

    public void func_73660_a() {
        if (!this.setSide()) {
            return;
        }
        if (this.base == null) {
            this.base = this.getBaseFromWorld();
        }
        if (this.resetCaches) {
            this.cachedScattershot = TurretHeadUtil.getScattershotUpgrades(this.getBase());
            this.getActualTurretAccuracyDeviation();
            this.resetCaches = false;
        }
    }

    protected boolean updateChecks() {
        ++this.ticks;
        if (this.base != null && this.base.getTier() >= this.turretTier) {
            this.concealmentChecks();
            TurretHeadUtil.updateSolarPanelAddon(this.base);
            if (this.target == null && this.targetingTicks < OMTConfig.TURRETS.turretTargetSearchTicks) {
                ++this.targetingTicks;
                return false;
            }
            this.targetingTicks = 0;
            int power_required = Math.round((float)this.getTurretBasePowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base, this)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
            if (this.base.getEnergyStored(EnumFacing.DOWN) < power_required || !this.base.isActive()) {
                return false;
            }
            this.targetingChecks();
            if (this.target == null) {
                return false;
            }
            if (this.isOnCooldown()) {
                return false;
            }
            if (this.target != null && !TurretTargetingUtils.canSeeTargetFromPos(this, this.target)) {
                this.target = null;
                return false;
            }
            if (this.target != null && TurretTargetingUtils.chebyshevDistance(this, this.target)) {
                this.target = null;
                return false;
            }
            this.base.setEnergyStored(this.base.getEnergyStored(EnumFacing.DOWN) - power_required, null);
            return true;
        }
        this.func_145831_w().func_175655_b(this.field_174879_c, true);
        return false;
    }

    protected void targetingChecks() {
        if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || this.target.func_110143_aJ() <= 0.0f || !TurretTargetingUtils.canSeeTargetFromPos(this, this.target)) {
            this.target = this.getTarget();
        }
    }

    void concealmentChecks() {
        if (this.base != null && this.base.shouldConcealTurrets) {
            if (!(this.shouldConceal || this.target != null && TurretTargetingUtils.canSeeTargetFromPos(this, this.target) || this.ticksWithoutTarget < 40)) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = true;
                this.playedDeploy = false;
                this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.turretRetractSound, SoundCategory.BLOCKS, (float)OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
                this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                ++this.ticksWithoutTarget;
            }
            if (this.base != null && this.target != null) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = false;
                if (!this.playedDeploy) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.turretDeploySound, SoundCategory.BLOCKS, (float)OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
                    this.playedDeploy = true;
                    this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        } else {
            this.shouldConceal = false;
            this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

