/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.turret;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.handler.OMConfig;
import omtteam.omlib.util.TargetingSettings;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.omlib.util.world.Pos;
import omtteam.omlib.util.world.WorldUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.api.lists.MobBlacklist;
import omtteam.openmodularturrets.api.lists.MobList;
import omtteam.openmodularturrets.api.lists.NeutralList;
import omtteam.openmodularturrets.compatibility.ModCompatibility;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.turret.EnumTargetingPriority;
import omtteam.openmodularturrets.turret.TurretHeadUtil;
import omtteam.openmodularturrets.util.OMTUtil;
import org.apache.logging.log4j.Logger;
import valkyrienwarfare.api.IPhysicsEntity;
import valkyrienwarfare.api.IPhysicsEntityManager;
import valkyrienwarfare.api.TransformType;

public class TurretTargetingUtils {
    private TargetingSettings settings;
    private final Pos pos;
    private final TurretHead turret;

    public TurretTargetingUtils(TurretHead turret) {
        this.settings = turret.getTargetingSettings();
        this.pos = new Pos(turret.func_174877_v());
        this.turret = turret;
    }

    public static boolean chebyshevDistance(TurretHead turret, EntityLivingBase entity) {
        BlockPos pos;
        IPhysicsEntity physicsEntity;
        Vec3d targetPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vec3d startPos = new Vec3d((Vec3i)turret.func_174877_v());
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(turret.func_145831_w(), turret.func_174877_v())) != null) {
            startPos = physicsEntity.transformVector(startPos, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(targetPos.field_72450_a - (double)(pos = new BlockPos(startPos)).func_177958_n()), (double)(targetPos.field_72448_b - (double)pos.func_177956_o())), (double)(targetPos.field_72449_c - (double)pos.func_177952_p())) > (double)turret.getBase().getRange();
    }

    public static boolean canSeeTargetFromPos(TurretHead turret, EntityLivingBase entity) {
        IPhysicsEntity physicsEntity;
        Pos pos = new Pos(turret.func_174877_v());
        Vec3d traceStart = new Vec3d(pos.getX() + 0.5, pos.getY() + 0.5, pos.getZ() + 0.5);
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(turret.func_145831_w(), turret.func_174877_v())) != null) {
            traceStart = physicsEntity.transformVector(traceStart, TransformType.SUBSPACE_TO_GLOBAL);
        }
        Vec3d traceEnd = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d vecDelta = new Vec3d(traceEnd.field_72450_a - traceStart.field_72450_a, traceEnd.field_72448_b - traceStart.field_72448_b, traceEnd.field_72449_c - traceStart.field_72449_c);
        vecDelta = vecDelta.func_72432_b();
        for (int i = 0; i < 100; ++i) {
            traceStart = traceStart.func_178787_e(vecDelta);
            RayTraceResult traced = turret.func_145831_w().func_72933_a(traceStart, traceEnd);
            if (traced != null && traced.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState hitBlock = turret.func_145831_w().func_180495_p(traced.func_178782_a());
                if (!(traced.func_178782_a().equals((Object)turret.func_174877_v()) || !hitBlock.func_185904_a().func_76220_a() && MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(traceStart.field_72450_a - traceEnd.field_72450_a), (double)(traceStart.field_72448_b - traceEnd.field_72448_b)), (double)(traceStart.field_72449_c - traceEnd.field_72449_c)) > 1.0)) {
                    return false;
                }
            } else {
                EntityLivingBase targeted = traced == null ? entity : (traced.field_72313_a == RayTraceResult.Type.MISS ? entity : null);
                return targeted != null;
            }
            traceStart = traced.field_72307_f;
        }
        return false;
    }

    public static boolean isEntityValidNeutral(TurretHead turret, EntityLivingBase possibleTarget) {
        if (turret.getBase().isAttacksNeutrals() && OMTConfig.TURRETS.globalCanTargetNeutrals) {
            return !possibleTarget.field_70128_L && (possibleTarget instanceof EntityAnimal || possibleTarget instanceof EntityAmbientCreature || NeutralList.contains(possibleTarget));
        }
        return false;
    }

    public static boolean isEntityValidMob(TurretHead turret, EntityLivingBase possibleTarget) {
        if (turret.getBase().isAttacksMobs() && OMTConfig.TURRETS.globalCanTargetMobs) {
            return !possibleTarget.field_70128_L && (possibleTarget.isCreatureType(EnumCreatureType.MONSTER, false) || MobList.contains(possibleTarget));
        }
        return false;
    }

    public static boolean isTargetAlreadyTargeted(TurretBase base, Entity entity) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)base.func_145831_w(), (BlockPos)base.func_174877_v())) {
            if (!(tileEntity instanceof TurretHead) || !entity.equals((Object)((TurretHead)tileEntity).target)) continue;
            return true;
        }
        return false;
    }

    public TargetingSettings getSettings() {
        return this.settings;
    }

    public void setSettings(TargetingSettings settings) {
        this.settings = settings;
    }

    @Nullable
    public EntityLivingBase getBestEntity(List<EntityLivingBase> entityList) {
        int bestPriority = Integer.MIN_VALUE;
        EntityLivingBase bestEntity = null;
        for (EntityLivingBase entity : entityList) {
            if (!this.validTarget(entity)) continue;
            int tempPriority = 1;
            for (EnumTargetingPriority priority : EnumTargetingPriority.values()) {
                Integer[] priorities = this.turret.getPriorities();
                tempPriority *= EnumTargetingPriority.getValueByPriority(entity, this.pos, priority, this.settings, priorities);
            }
            if (tempPriority <= bestPriority) continue;
            bestPriority = tempPriority;
            bestEntity = entity;
        }
        return bestEntity;
    }

    private boolean validTarget(EntityLivingBase entity) {
        EntityPlayer owner;
        Entity entityOwned;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (!this.settings.isTargetPlayers() || !OMTConfig.TURRETS.globalCanTargetPlayers || PlayerUtil.isPlayerTrusted((EntityPlayer)player, (IHasOwner)this.turret) || PlayerUtil.isPlayerOP((EntityPlayer)player) && OMConfig.GENERAL.canOPAccessOwnedBlocks || !OMTUtil.canDamagePlayer((EntityPlayer)player, this.turret.getBase()) || player.field_70128_L) {
                return false;
            }
        }
        if (!TurretTargetingUtils.canSeeTargetFromPos(this.turret, entity)) {
            return false;
        }
        if (TurretTargetingUtils.chebyshevDistance(this.turret, entity)) {
            return false;
        }
        if (OMConfig.GENERAL.debugLogging) {
            Logger logger = OpenModularTurrets.getLogger();
            logger.info("Targeting, EntityString: " + EntityList.func_75621_b((Entity)entity));
            logger.info("Targeting, EntityKey: " + EntityList.func_191301_a((Entity)entity));
        }
        if (EntityList.func_75621_b((Entity)entity) != null && MobBlacklist.contains(EntityList.func_75621_b((Entity)entity))) {
            return false;
        }
        if (this.turret.getBase().getController() != null && !this.turret.getBase().getController().isEntityValidTarget((Entity)entity, TurretHeadUtil.getAimYaw((Entity)entity, this.pos), TurretHeadUtil.getAimPitch((Entity)entity, this.pos))) {
            return false;
        }
        if (entity instanceof IEntityOwnable ? (entityOwned = ((IEntityOwnable)entity).func_70902_q()) instanceof EntityPlayer && (PlayerUtil.isPlayerOwner((EntityPlayer)(owner = (EntityPlayer)entityOwned), (IHasOwner)this.turret) || PlayerUtil.isPlayerTrusted((EntityPlayer)owner, (IHasOwner)this.turret)) : entity instanceof EntityHorse && ((EntityHorse)entity).func_110248_bS()) {
            return false;
        }
        if (this.turret.getBase().isMultiTargeting() && TurretTargetingUtils.isTargetAlreadyTargeted(this.turret.getBase(), (Entity)entity)) {
            return false;
        }
        if (!this.turret.isEntityValidTarget(entity)) {
            return false;
        }
        if (TurretTargetingUtils.isEntityValidNeutral(this.turret, entity) && this.settings.isTargetPassive()) {
            return true;
        }
        if (TurretTargetingUtils.isEntityValidMob(this.turret, entity) && this.settings.isTargetMobs()) {
            return true;
        }
        return entity instanceof EntityPlayer;
    }
}

