/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.util;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.api.lists.AmmoList;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.items.AmmoMetaItem;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.turret.TurretHeadUtil;
import omtteam.openmodularturrets.turret.TurretType;

public class OMTUtil {
    public static boolean isItemStackValidAmmo(ItemStack itemStack) {
        if (itemStack == ItemStack.field_190927_a) {
            return false;
        }
        return !OMTConfig.GENERAL.useWhitelistForAmmo || itemStack.func_77973_b() == Items.field_151174_bG || itemStack.func_77973_b() == Items.field_151137_ax || itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX) || AmmoList.contains(itemStack) || itemStack.func_77973_b() instanceof AmmoMetaItem;
    }

    public static int getFakeDropsLevel(EntityLivingBase entity) {
        Set tags = entity.func_184216_O();
        return tags.contains("openmodularturrets:fake_drops_0") ? 0 : (tags.contains("openmodularturrets:fake_drops_1") ? 1 : (tags.contains("openmodularturrets:fake_drops_2") ? 2 : (tags.contains("openmodularturrets:fake_drops_3") ? 3 : -1)));
    }

    public static boolean canDamagePlayer(EntityPlayer entityPlayer, TurretBase base) {
        Player player = new Player(entityPlayer);
        return OMTUtil.canDamagePlayer(player, base);
    }

    public static boolean canDamagePlayer(Player player, TurretBase base) {
        if (base != null && player != null) {
            if (!OMTConfig.TURRETS.turretDamageTrustedPlayers && PlayerUtil.isPlayerTrusted((Player)player, (IHasOwner)base)) {
                return false;
            }
            String team = player.getTeamName();
            return !PlayerUtil.isPlayerOwner((Player)player, (IHasOwner)base) && (team.isEmpty() || !team.equals(base.getOwner().getTeamName()));
        }
        return false;
    }

    public static boolean canDamageEntity(Entity entity, TurretBase base) {
        if (entity != null && !(entity instanceof TurretProjectile)) {
            EntityLivingBase entityOwner;
            if (entity instanceof EntityPlayer) {
                return OMTUtil.canDamagePlayer((EntityPlayer)entity, base);
            }
            if (entity instanceof EntityTameable && (entityOwner = ((EntityTameable)entity).func_70902_q()) instanceof EntityPlayer) {
                EntityPlayer owner = (EntityPlayer)entityOwner;
                return OMTUtil.canDamagePlayer(owner, base);
            }
        }
        return true;
    }

    public static void setTagsForTurretHit(Entity entity, TurretBase base) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            if (!(entityLivingBase instanceof EntityPlayer) && !entityLivingBase.func_184216_O().contains("openmodularturrets:turret_hit")) {
                entityLivingBase.func_184211_a("openmodularturrets:turret_hit");
            }
            if (!(entityLivingBase instanceof EntityPlayer) && TurretHeadUtil.getFakeDropsLevel(base) > -1) {
                entityLivingBase.func_184211_a("openmodularturrets:fake_drops_" + TurretHeadUtil.getFakeDropsLevel(base));
            }
            if (!(entityLivingBase instanceof EntityPlayer || TurretHeadUtil.baseHasNoLootDeleter(base) || entityLivingBase.func_184216_O().contains("openmodularturrets:dont_drop_loot"))) {
                entityLivingBase.func_184211_a("openmodularturrets:dont_drop_loot");
            }
        }
    }

    public static int getRemainingTurretSlots(@Nonnull TurretBase base, @Nullable TurretType turret) {
        int numberOfTurretsRemaining = 1000;
        if (turret != null) {
            numberOfTurretsRemaining = turret.getSettings().maxSimultaneous;
            for (TurretHead turretHead : TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).values()) {
                if (!turret.getInternalName().equals(turretHead.getTurretType().getInternalName())) continue;
                --numberOfTurretsRemaining;
            }
        }
        switch (base.getTier()) {
            case 1: {
                return numberOfTurretsRemaining == 1000 ? Math.max(0, OMTConfig.BASES.baseTierOne.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size()) : Math.max(0, Math.min(OMTConfig.BASES.baseTierOne.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size(), numberOfTurretsRemaining));
            }
            case 2: {
                return numberOfTurretsRemaining == 1000 ? Math.max(0, OMTConfig.BASES.baseTierTwo.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size()) : Math.max(0, Math.min(OMTConfig.BASES.baseTierTwo.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size(), numberOfTurretsRemaining));
            }
            case 3: {
                return numberOfTurretsRemaining == 1000 ? Math.max(0, OMTConfig.BASES.baseTierThree.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size()) : Math.max(0, Math.min(OMTConfig.BASES.baseTierThree.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size(), numberOfTurretsRemaining));
            }
            case 4: {
                return numberOfTurretsRemaining == 1000 ? Math.max(0, OMTConfig.BASES.baseTierFour.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size()) : Math.max(0, Math.min(OMTConfig.BASES.baseTierFour.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size(), numberOfTurretsRemaining));
            }
            case 5: {
                return numberOfTurretsRemaining == 1000 ? Math.max(0, OMTConfig.BASES.baseTierFive.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size()) : Math.max(0, Math.min(OMTConfig.BASES.baseTierFive.baseMaxTurrets - TurretHeadUtil.getBaseTurrets(base.func_145831_w(), base.func_174877_v()).size(), numberOfTurretsRemaining));
            }
        }
        return 0;
    }
}

