/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.bukkit.BukkitBiome;
import com.khorn.terraincontrol.bukkit.BukkitMaterialData;
import com.khorn.terraincontrol.bukkit.BukkitMojangSettings;
import com.khorn.terraincontrol.bukkit.JsonToNBT;
import com.khorn.terraincontrol.bukkit.NBTException;
import com.khorn.terraincontrol.bukkit.generator.BukkitVanillaBiomeGenerator;
import com.khorn.terraincontrol.bukkit.generator.TXChunkGenerator;
import com.khorn.terraincontrol.bukkit.generator.TXInternalChunkGenerator;
import com.khorn.terraincontrol.bukkit.generator.TXWorldChunkManager;
import com.khorn.terraincontrol.bukkit.generator.TXWorldProvider;
import com.khorn.terraincontrol.bukkit.generator.structures.MojangStructurePart;
import com.khorn.terraincontrol.bukkit.generator.structures.TXMineshaftGen;
import com.khorn.terraincontrol.bukkit.generator.structures.TXNetherFortressGen;
import com.khorn.terraincontrol.bukkit.generator.structures.TXOceanMonumentGen;
import com.khorn.terraincontrol.bukkit.generator.structures.TXRareBuildingGen;
import com.khorn.terraincontrol.bukkit.generator.structures.TXStrongholdGen;
import com.khorn.terraincontrol.bukkit.generator.structures.TXVillageGen;
import com.khorn.terraincontrol.bukkit.util.NBTHelper;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeConfigFinder;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.ServerConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.customobjects.CustomObjectStructureCache;
import com.khorn.terraincontrol.customobjects.bo3.EntityFunction;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.generator.SpawnableObject;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import com.khorn.terraincontrol.util.helpers.ReflectionHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.v1_10_R1.BiomeBase;
import net.minecraft.server.v1_10_R1.Block;
import net.minecraft.server.v1_10_R1.BlockLeaves;
import net.minecraft.server.v1_10_R1.BlockLeaves1;
import net.minecraft.server.v1_10_R1.BlockLog1;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.BlockWood;
import net.minecraft.server.v1_10_R1.Blocks;
import net.minecraft.server.v1_10_R1.Chunk;
import net.minecraft.server.v1_10_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_10_R1.ChunkGenerator;
import net.minecraft.server.v1_10_R1.ChunkProviderServer;
import net.minecraft.server.v1_10_R1.ChunkSection;
import net.minecraft.server.v1_10_R1.DataConverter;
import net.minecraft.server.v1_10_R1.DataConverterRegistry;
import net.minecraft.server.v1_10_R1.DataConverterType;
import net.minecraft.server.v1_10_R1.DataConverterTypes;
import net.minecraft.server.v1_10_R1.DefinedStructure;
import net.minecraft.server.v1_10_R1.DefinedStructureManager;
import net.minecraft.server.v1_10_R1.DimensionManager;
import net.minecraft.server.v1_10_R1.EntityAreaEffectCloud;
import net.minecraft.server.v1_10_R1.EntityArmorStand;
import net.minecraft.server.v1_10_R1.EntityBat;
import net.minecraft.server.v1_10_R1.EntityBlaze;
import net.minecraft.server.v1_10_R1.EntityBoat;
import net.minecraft.server.v1_10_R1.EntityCaveSpider;
import net.minecraft.server.v1_10_R1.EntityChicken;
import net.minecraft.server.v1_10_R1.EntityCow;
import net.minecraft.server.v1_10_R1.EntityCreeper;
import net.minecraft.server.v1_10_R1.EntityDragonFireball;
import net.minecraft.server.v1_10_R1.EntityEgg;
import net.minecraft.server.v1_10_R1.EntityEnderCrystal;
import net.minecraft.server.v1_10_R1.EntityEnderDragon;
import net.minecraft.server.v1_10_R1.EntityEnderPearl;
import net.minecraft.server.v1_10_R1.EntityEnderSignal;
import net.minecraft.server.v1_10_R1.EntityEnderman;
import net.minecraft.server.v1_10_R1.EntityEndermite;
import net.minecraft.server.v1_10_R1.EntityExperienceOrb;
import net.minecraft.server.v1_10_R1.EntityFallingBlock;
import net.minecraft.server.v1_10_R1.EntityFireworks;
import net.minecraft.server.v1_10_R1.EntityGhast;
import net.minecraft.server.v1_10_R1.EntityGiantZombie;
import net.minecraft.server.v1_10_R1.EntityGuardian;
import net.minecraft.server.v1_10_R1.EntityHorse;
import net.minecraft.server.v1_10_R1.EntityIronGolem;
import net.minecraft.server.v1_10_R1.EntityLargeFireball;
import net.minecraft.server.v1_10_R1.EntityLightning;
import net.minecraft.server.v1_10_R1.EntityLiving;
import net.minecraft.server.v1_10_R1.EntityMagmaCube;
import net.minecraft.server.v1_10_R1.EntityMinecartChest;
import net.minecraft.server.v1_10_R1.EntityMinecartCommandBlock;
import net.minecraft.server.v1_10_R1.EntityMinecartFurnace;
import net.minecraft.server.v1_10_R1.EntityMinecartHopper;
import net.minecraft.server.v1_10_R1.EntityMinecartMobSpawner;
import net.minecraft.server.v1_10_R1.EntityMinecartRideable;
import net.minecraft.server.v1_10_R1.EntityMinecartTNT;
import net.minecraft.server.v1_10_R1.EntityMushroomCow;
import net.minecraft.server.v1_10_R1.EntityOcelot;
import net.minecraft.server.v1_10_R1.EntityPig;
import net.minecraft.server.v1_10_R1.EntityPigZombie;
import net.minecraft.server.v1_10_R1.EntityPolarBear;
import net.minecraft.server.v1_10_R1.EntityPotion;
import net.minecraft.server.v1_10_R1.EntityRabbit;
import net.minecraft.server.v1_10_R1.EntitySheep;
import net.minecraft.server.v1_10_R1.EntityShulker;
import net.minecraft.server.v1_10_R1.EntityShulkerBullet;
import net.minecraft.server.v1_10_R1.EntitySilverfish;
import net.minecraft.server.v1_10_R1.EntitySkeleton;
import net.minecraft.server.v1_10_R1.EntitySlime;
import net.minecraft.server.v1_10_R1.EntitySmallFireball;
import net.minecraft.server.v1_10_R1.EntitySnowball;
import net.minecraft.server.v1_10_R1.EntitySnowman;
import net.minecraft.server.v1_10_R1.EntitySpectralArrow;
import net.minecraft.server.v1_10_R1.EntitySpider;
import net.minecraft.server.v1_10_R1.EntitySquid;
import net.minecraft.server.v1_10_R1.EntityTNTPrimed;
import net.minecraft.server.v1_10_R1.EntityThrownExpBottle;
import net.minecraft.server.v1_10_R1.EntityTippedArrow;
import net.minecraft.server.v1_10_R1.EntityVillager;
import net.minecraft.server.v1_10_R1.EntityWitch;
import net.minecraft.server.v1_10_R1.EntityWither;
import net.minecraft.server.v1_10_R1.EntityWitherSkull;
import net.minecraft.server.v1_10_R1.EntityWolf;
import net.minecraft.server.v1_10_R1.EntityZombie;
import net.minecraft.server.v1_10_R1.EnumCreatureType;
import net.minecraft.server.v1_10_R1.IBlockData;
import net.minecraft.server.v1_10_R1.IBlockState;
import net.minecraft.server.v1_10_R1.ITileEntity;
import net.minecraft.server.v1_10_R1.Material;
import net.minecraft.server.v1_10_R1.MinecraftKey;
import net.minecraft.server.v1_10_R1.NBTBase;
import net.minecraft.server.v1_10_R1.NBTTagCompound;
import net.minecraft.server.v1_10_R1.SpawnerCreature;
import net.minecraft.server.v1_10_R1.TileEntity;
import net.minecraft.server.v1_10_R1.World;
import net.minecraft.server.v1_10_R1.WorldChunkManager;
import net.minecraft.server.v1_10_R1.WorldGenAcaciaTree;
import net.minecraft.server.v1_10_R1.WorldGenBigTree;
import net.minecraft.server.v1_10_R1.WorldGenDungeons;
import net.minecraft.server.v1_10_R1.WorldGenForest;
import net.minecraft.server.v1_10_R1.WorldGenForestTree;
import net.minecraft.server.v1_10_R1.WorldGenFossils;
import net.minecraft.server.v1_10_R1.WorldGenGroundBush;
import net.minecraft.server.v1_10_R1.WorldGenHugeMushroom;
import net.minecraft.server.v1_10_R1.WorldGenJungleTree;
import net.minecraft.server.v1_10_R1.WorldGenMegaTree;
import net.minecraft.server.v1_10_R1.WorldGenSwampTree;
import net.minecraft.server.v1_10_R1.WorldGenTaiga1;
import net.minecraft.server.v1_10_R1.WorldGenTaiga2;
import net.minecraft.server.v1_10_R1.WorldGenTrees;
import net.minecraft.server.v1_10_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftAmbient;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftComplexLivingEntity;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftFlying;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftGolem;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftWaterMob;
import org.bukkit.craftbukkit.v1_10_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_10_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_10_R1.potion.CraftPotionUtil;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Weather;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class BukkitWorld
implements LocalWorld {
    private boolean initialized;
    private TXChunkGenerator generator;
    private WorldServer world;
    private ServerConfigProvider settings;
    private CustomObjectStructureCache structureCache;
    private String name;
    private BiomeGenerator biomeGenerator;
    private DataConverter dataConverter;
    private static int nextBiomeId = DefaultBiome.values().length;
    private static final int MAX_BIOMES_COUNT = 1024;
    private static final int MAX_SAVED_BIOMES_COUNT = 256;
    private static final int STANDARD_WORLD_HEIGHT = 128;
    private final Map<String, LocalBiome> biomeNames = new HashMap<String, LocalBiome>();
    public TXStrongholdGen strongholdGen;
    public TXVillageGen villageGen;
    public TXMineshaftGen mineshaftGen;
    public TXRareBuildingGen rareBuildingGen;
    public TXNetherFortressGen netherFortressGen;
    public TXOceanMonumentGen oceanMonumentGen;
    private WorldGenDungeons dungeon;
    private WorldGenFossils fossil;
    private WorldGenTrees tree;
    private WorldGenAcaciaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenForest birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenForestTree darkOakTree;
    private WorldGenGroundBush groundBush;
    private WorldGenHugeMushroom hugeBrownMushroom;
    private WorldGenHugeMushroom hugeRedMushroom;
    private WorldGenMegaTree hugeTaigaTree1;
    private WorldGenMegaTree hugeTaigaTree2;
    private WorldGenJungleTree jungleTree;
    private WorldGenForest longBirchTree;
    private WorldGenSwampTree swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;
    private Chunk[] chunkCache;

    public BukkitWorld(String _name) {
        this.name = _name;
    }

    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds) {
        BukkitBiome biome = biomeConfig.defaultSettings.isCustomBiome ? BukkitBiome.forCustomBiome(biomeConfig, biomeIds) : BukkitBiome.forVanillaBiome(biomeConfig, BiomeBase.getBiome((int)biomeIds.getSavedId()));
        this.biomeNames.put(biome.getName(), biome);
        return biome;
    }

    @Override
    public int getMaxBiomesCount() {
        return 1024;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 256;
    }

    @Override
    public int getFreeBiomeId() {
        return nextBiomeId++;
    }

    @Override
    public ArrayList<LocalBiome> getAllBiomes() {
        ArrayList<LocalBiome> biomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : this.settings.getBiomeArray()) {
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public BukkitBiome getBiomeById(int id) throws BiomeNotFoundException {
        LocalBiome biome = this.settings.getBiomeByIdOrNull(id);
        if (biome == null) {
            throw new BiomeNotFoundException(id, Arrays.asList(this.settings.getBiomeArray()));
        }
        return (BukkitBiome)biome;
    }

    @Override
    public LocalBiome getBiomeByIdOrNull(int id) {
        return this.settings.getBiomeByIdOrNull(id);
    }

    @Override
    public LocalBiome getBiomeByNameOrNull(String name) {
        return this.biomeNames.get(name);
    }

    @Override
    public Collection<? extends BiomeLoadInstruction> getDefaultBiomes() {
        ArrayList<BiomeLoadInstruction> standardBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(BukkitMojangSettings.fromId(id), 128);
            standardBiomes.add(instruction);
        }
        return standardBiomes;
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled && dry) {
            this.villageGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.a((World)this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public boolean placeDungeon(Random rand, int x, int y, int z) {
        return this.dungeon.generate((World)this.world, rand, new BlockPosition(x, y, z));
    }

    @Override
    public boolean placeFossil(Random rand, ChunkCoordinate chunkCoord) {
        return this.fossil.generate((World)this.world, rand, new BlockPosition(chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ()));
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        BlockPosition blockPos = new BlockPosition(x, y, z);
        switch (type) {
            case Tree: {
                return this.tree.generate((World)this.world, rand, blockPos);
            }
            case BigTree: {
                return this.bigTree.generate((World)this.world, rand, blockPos);
            }
            case Forest: 
            case Birch: {
                return this.birchTree.generate((World)this.world, rand, blockPos);
            }
            case TallBirch: {
                return this.longBirchTree.generate((World)this.world, rand, blockPos);
            }
            case HugeMushroom: {
                if (rand.nextBoolean()) {
                    return this.hugeBrownMushroom.generate((World)this.world, rand, blockPos);
                }
                return this.hugeRedMushroom.generate((World)this.world, rand, blockPos);
            }
            case HugeRedMushroom: {
                return this.hugeRedMushroom.generate((World)this.world, rand, blockPos);
            }
            case HugeBrownMushroom: {
                return this.hugeBrownMushroom.generate((World)this.world, rand, blockPos);
            }
            case SwampTree: {
                return this.swampTree.generate((World)this.world, rand, blockPos);
            }
            case Taiga1: {
                return this.taigaTree1.generate((World)this.world, rand, blockPos);
            }
            case Taiga2: {
                return this.taigaTree2.generate((World)this.world, rand, blockPos);
            }
            case JungleTree: {
                return this.jungleTree.generate((World)this.world, rand, blockPos);
            }
            case GroundBush: {
                return this.groundBush.generate((World)this.world, rand, blockPos);
            }
            case CocoaTree: {
                return this.cocoaTree.generate((World)this.world, rand, blockPos);
            }
            case Acacia: {
                return this.acaciaTree.generate((World)this.world, rand, blockPos);
            }
            case DarkOak: {
                return this.darkOakTree.generate((World)this.world, rand, blockPos);
            }
            case HugeTaiga1: {
                return this.hugeTaigaTree1.generate((World)this.world, rand, blockPos);
            }
            case HugeTaiga2: {
                return this.hugeTaigaTree2.generate((World)this.world, rand, blockPos);
            }
        }
        throw new RuntimeException("Failed to handle tree of type " + type.toString());
    }

    @Override
    public boolean placeDefaultStructures(Random random, ChunkCoordinate chunkCoord) {
        ChunkCoordIntPair chunkIntPair = new ChunkCoordIntPair(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        WorldConfig worldConfig = this.settings.getWorldConfig();
        boolean villageGenerated = false;
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.villagesEnabled) {
            villageGenerated = this.villageGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.a((World)this.world, random, chunkIntPair);
        }
        return villageGenerated;
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
        if (!this.settings.getWorldConfig().BiomeConfigsHaveReplacement) {
            return;
        }
        Chunk[] cache = this.getChunkCache(chunkCoord);
        for (int i = 0; i < 4; ++i) {
            this.replaceBlocks(cache[i], 0, 0, 16);
        }
    }

    private void replaceBlocks(Chunk rawChunk, int startXInChunk, int startZInChunk, int size) {
        ChunkSection[] sectionsArray;
        int endXInChunk = startXInChunk + size;
        int endZInChunk = startZInChunk + size;
        int worldStartX = rawChunk.locX * 16;
        int worldStartZ = rawChunk.locZ * 16;
        for (ChunkSection section : sectionsArray = rawChunk.getSections()) {
            if (section == null) continue;
            for (int sectionX = startXInChunk; sectionX < endXInChunk; ++sectionX) {
                block2: for (int sectionZ = startZInChunk; sectionZ < endZInChunk; ++sectionZ) {
                    LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                    if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) continue;
                    LocalMaterialData[][] replaceArray = biome.getBiomeConfig().replacedBlocks.compiledInstructions;
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        IBlockData block = section.getType(sectionX, sectionY, sectionZ);
                        int blockId = Block.getId((Block)block.getBlock());
                        if (replaceArray[blockId] == null) continue;
                        int y = section.getYPosition() + sectionY;
                        if (y >= replaceArray[blockId].length) continue block2;
                        BukkitMaterialData replaceTo = (BukkitMaterialData)replaceArray[blockId][y];
                        if (replaceTo == null || replaceTo.getBlockId() == blockId) continue;
                        section.setType(sectionX, sectionY, sectionZ, replaceTo.internalBlock());
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        SpawnerCreature.a((World)this.world, (BiomeBase)((BukkitBiome)biome).getHandle(), (int)(chunkCoord.getChunkX() * 16 + 8), (int)(chunkCoord.getChunkZ() * 16 + 8), (int)16, (int)16, (Random)random);
    }

    private Chunk getChunk(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return null;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.chunkCache == null) {
            return this.world.getChunkAt(chunkX, chunkZ);
        }
        Chunk topLeftCachedChunk = this.chunkCache[0];
        int indexX = chunkX - topLeftCachedChunk.locX;
        int indexZ = chunkZ - topLeftCachedChunk.locZ;
        if (!(indexX != 0 && indexX != 1 || indexZ != 0 && indexZ != 1)) {
            return this.chunkCache[indexX | indexZ << 1];
        }
        if (this.settings.getWorldConfig().populationBoundsCheck) {
            return null;
        }
        if (this.world.getChunkProviderServer().isLoaded(chunkX, chunkZ)) {
            return this.world.getChunkAt(chunkX, chunkZ);
        }
        return null;
    }

    @Override
    public int getLiquidHeight(int x, int z) {
        for (int y = this.getHighestBlockYAt(x, z) - 1; y > 0; --y) {
            LocalMaterialData material = this.getMaterial(x, y, z);
            if (material.isLiquid()) {
                return y + 1;
            }
            if (!material.isSolid()) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getSolidHeight(int x, int z) {
        for (int y = this.getHighestBlockYAt(x, z) - 1; y > 0; --y) {
            LocalMaterialData material = this.getMaterial(x, y, z);
            if (!material.isSolid()) continue;
            return y + 1;
        }
        return -1;
    }

    @Override
    public boolean isEmpty(int x, int y, int z) {
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return true;
        }
        return chunk.a(x & 0xF, y, z & 0xF).getMaterial().equals(Material.AIR);
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null || y < 0 || y >= 256) {
            return BukkitMaterialData.ofMinecraftBlock(Blocks.AIR);
        }
        return BukkitMaterialData.ofMinecraftBlockData(chunk.a(x, y, z));
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material) {
        try {
            if (y < 0 || y >= 256) {
                return;
            }
            IBlockData blockData = ((BukkitMaterialData)material).internalBlock();
            Chunk chunk = this.getChunk(x, y, z);
            if (chunk == null) {
                return;
            }
            BlockPosition blockPos = new BlockPosition(x, y, z);
            boolean oldCaptureBlockStates = this.world.captureBlockStates;
            this.world.captureBlockStates = !(blockData.getBlock() instanceof ITileEntity);
            IBlockData oldBlockData = chunk.a(blockPos, blockData);
            this.world.captureBlockStates = oldCaptureBlockStates;
            if (oldBlockData == null) {
                return;
            }
            if ((blockData.c() != oldBlockData.c() || blockData.d() != oldBlockData.d()) && this.isSafeForLightUpdates(chunk, x, z)) {
                this.world.methodProfiler.a("checkLight");
                this.world.w(blockPos);
                this.world.methodProfiler.b();
            }
            this.world.notifyAndUpdatePhysics(blockPos, chunk, oldBlockData, blockData, 2);
        }
        catch (Throwable t) {
            String populatingChunkInfo = this.chunkCache == null ? "(no chunk)" : this.chunkCache[0].locX + "," + this.chunkCache[0].locZ;
            RuntimeException runtimeException = new RuntimeException("Error setting " + material + " block at " + x + "," + y + "," + z + " while populating chunk " + populatingChunkInfo, t);
            runtimeException.setStackTrace(new StackTraceElement[0]);
            throw runtimeException;
        }
    }

    private boolean isSafeForLightUpdates(Chunk currentChunk, int x, int z) {
        int xInChunk = x & 0xF;
        int zInChunk = z & 0xF;
        if (xInChunk == 0 || xInChunk == 15 || zInChunk == 0 || zInChunk == 15) {
            return currentChunk.areNeighborsLoaded(2);
        }
        return currentChunk.areNeighborsLoaded(1);
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        int y;
        Chunk chunk = this.getChunk(x, 0, z);
        if (chunk == null) {
            return -1;
        }
        boolean incorrectHeightMap = false;
        for (y = chunk.b(x & 0xF, z & 0xF); y < this.getHeightCap() && chunk.a(x, y, z).getMaterial().blocksLight(); ++y) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap && this.isSafeForLightUpdates(chunk, x, z)) {
            this.world.w(new BlockPosition(x, y, z));
        }
        return y;
    }

    @Override
    public void startPopulation(ChunkCoordinate chunkCoord) {
        if (this.chunkCache != null && this.settings.getWorldConfig().populationBoundsCheck) {
            throw new IllegalStateException("Chunk is already being populated. This may be a bug in OpenTerrainGenerator, but it may also be another mod that is poking in unloaded chunks.\nSet PopulationBoundsCheck to false in the WorldConfig to disable this error.");
        }
        this.chunkCache = this.loadFourChunks(chunkCoord);
    }

    private Chunk[] getChunkCache(ChunkCoordinate topLeft) {
        if (this.chunkCache == null || !topLeft.coordsMatch(this.chunkCache[0].locX, this.chunkCache[0].locZ)) {
            if (this.settings.getWorldConfig().populationBoundsCheck) {
                throw new IllegalStateException("chunkCache is null! You've got a bug!");
            }
            return this.loadFourChunks(topLeft);
        }
        return this.chunkCache;
    }

    private Chunk[] loadFourChunks(ChunkCoordinate topLeft) {
        Chunk[] chunkCache = new Chunk[4];
        for (int indexX = 0; indexX <= 1; ++indexX) {
            for (int indexZ = 0; indexZ <= 1; ++indexZ) {
                chunkCache[indexX | indexZ << 1] = this.world.getChunkAt(topLeft.getChunkX() + indexX, topLeft.getChunkZ() + indexZ);
            }
        }
        return chunkCache;
    }

    @Override
    public void endPopulation() {
        if (this.chunkCache == null && this.settings.getWorldConfig().populationBoundsCheck) {
            throw new IllegalStateException("Chunk is not being populated. This may be a bug in Open Terrain Generator, but it may also be another mod that is poking in unloaded chunks. Set PopulationBoundsCheck to false in the WorldConfig to disable this error.");
        }
        this.chunkCache = null;
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        return this.world.j(new BlockPosition(x, y, z));
    }

    @Override
    public boolean isLoaded(int x, int y, int z) {
        return this.getChunk(x, y, z) != null;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSeed() {
        return this.world.getSeed();
    }

    @Override
    public int getHeightCap() {
        return this.settings.getWorldConfig().worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.getWorldConfig().worldHeightScale;
    }

    public TXChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    public World getWorld() {
        return this.world;
    }

    public void setSettings(ServerConfigProvider newSettings) {
        if (this.settings != null) {
            throw new IllegalStateException("Settings are already set");
        }
        this.settings = newSettings;
    }

    public void reloadSettings() {
        this.biomeNames.clear();
        this.settings.reload();
    }

    public void enable(org.bukkit.World world) {
        WorldServer mcWorld;
        this.world = mcWorld = ((CraftWorld)world).getHandle();
        if (mcWorld.worldProvider.getDimensionManager().equals((Object)DimensionManager.OVERWORLD)) {
            mcWorld.worldProvider = new TXWorldProvider(this, this.world.worldProvider);
        }
        Class<? extends BiomeGenerator> biomeModeClass = this.settings.getWorldConfig().biomeMode;
        this.biomeGenerator = TerrainControl.getBiomeModeManager().createCached(biomeModeClass, this);
        this.injectWorldChunkManager(this.biomeGenerator);
        mcWorld.b(this.settings.getWorldConfig().waterLevelMax);
        if (!this.initialized) {
            this.structureCache = new CustomObjectStructureCache(this);
            this.dataConverter = DataConverterRegistry.a();
            switch (this.settings.getWorldConfig().ModeTerrain) {
                case Normal: 
                case OldGenerator: {
                    this.strongholdGen = new TXStrongholdGen(this.settings);
                    this.villageGen = new TXVillageGen(this.settings);
                    this.mineshaftGen = new TXMineshaftGen();
                    this.rareBuildingGen = new TXRareBuildingGen(this.settings);
                    this.netherFortressGen = new TXNetherFortressGen();
                    this.oceanMonumentGen = new TXOceanMonumentGen(this.settings);
                    this.injectInternalChunkGenerator(new TXInternalChunkGenerator(this, this.generator));
                }
                case NotGenerate: 
                case TerrainTest: {
                    this.generator.onInitialize(this);
                    break;
                }
            }
            this.dungeon = new WorldGenDungeons();
            this.fossil = new WorldGenFossils();
            IBlockData jungleLog = Blocks.LOG.getBlockData().set((IBlockState)BlockLog1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE);
            IBlockData jungleLeaves = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
            IBlockData oakLeaves = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.OAK).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
            this.tree = new WorldGenTrees(false);
            this.acaciaTree = new WorldGenAcaciaTree(false);
            this.cocoaTree = new WorldGenTrees(false, 5, jungleLog, jungleLeaves, true);
            this.bigTree = new WorldGenBigTree(false);
            this.birchTree = new WorldGenForest(false, false);
            this.darkOakTree = new WorldGenForestTree(false);
            this.longBirchTree = new WorldGenForest(false, true);
            this.swampTree = new WorldGenSwampTree();
            this.taigaTree1 = new WorldGenTaiga1();
            this.taigaTree2 = new WorldGenTaiga2(false);
            this.hugeBrownMushroom = new WorldGenHugeMushroom(Blocks.BROWN_MUSHROOM_BLOCK);
            this.hugeRedMushroom = new WorldGenHugeMushroom(Blocks.RED_MUSHROOM_BLOCK);
            this.hugeTaigaTree1 = new WorldGenMegaTree(false, false);
            this.hugeTaigaTree2 = new WorldGenMegaTree(false, true);
            this.jungleTree = new WorldGenJungleTree(false, 10, 20, jungleLog, jungleLeaves);
            this.groundBush = new WorldGenGroundBush(jungleLog, oakLeaves);
            this.initialized = true;
        } else {
            this.structureCache.reload(this);
        }
    }

    private void injectWorldChunkManager(BiomeGenerator biomeGenerator) {
        if (biomeGenerator instanceof BukkitVanillaBiomeGenerator) {
            ((BukkitVanillaBiomeGenerator)biomeGenerator).setWorldChunkManager(this.world.worldProvider.k());
        } else {
            ReflectionHelper.setValueInFieldOfType(this.world.worldProvider, WorldChunkManager.class, new TXWorldChunkManager(this, biomeGenerator));
        }
    }

    private void injectInternalChunkGenerator(CustomChunkGenerator chunkGenerator) {
        ChunkProviderServer chunkProvider = this.world.getChunkProviderServer();
        ChunkGenerator oldChunkGenerator = chunkProvider.chunkGenerator;
        if (oldChunkGenerator instanceof CustomChunkGenerator) {
            ReflectionHelper.setValueInFieldOfType(chunkProvider, ChunkGenerator.class, chunkGenerator);
        }
    }

    public void disable() {
        if (this.world.worldProvider instanceof TXWorldProvider) {
            this.world.worldProvider = ((TXWorldProvider)this.world.worldProvider).getOldWorldProvider();
        }
        this.injectInternalChunkGenerator(new CustomChunkGenerator((World)this.world, this.getSeed(), (org.bukkit.generator.ChunkGenerator)this.generator));
    }

    public void setChunkGenerator(TXChunkGenerator _generator) {
        this.generator = _generator;
    }

    @Override
    public BukkitBiome getCalculatedBiome(int x, int z) {
        return this.getBiomeById(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        if (this.settings.getWorldConfig().populateUsingSavedBiomes) {
            return this.getSavedBiome(x, z);
        }
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public LocalBiome getSavedBiome(int x, int z) throws BiomeNotFoundException {
        int savedId = BiomeBase.a((BiomeBase)this.world.getBiome(new BlockPosition(x, 0, z)));
        return this.getBiomeById(savedId);
    }

    @Override
    public void attachMetadata(int x, int y, int z, NamedBinaryTag tag) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.setInt("x", x);
        nmsTag.setInt("y", y);
        nmsTag.setInt("z", z);
        nmsTag = this.dataConverter.a((DataConverterType)DataConverterTypes.BLOCK_ENTITY, nmsTag, -1);
        TileEntity tileEntity = this.world.getTileEntity(new BlockPosition(x, y, z));
        if (tileEntity != null) {
            tileEntity.a(nmsTag);
        } else {
            TerrainControl.log(LogMarker.DEBUG, "Skipping tile entity with id {}, cannot be placed at {},{},{} on id {}", nmsTag.getString("id"), x, y, z, this.getMaterial(x, y, z));
        }
    }

    @Override
    public NamedBinaryTag getMetadata(int x, int y, int z) {
        TileEntity tileEntity = this.world.getTileEntity(new BlockPosition(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nmsTag = new NBTTagCompound();
        tileEntity.save(nmsTag);
        nmsTag.remove("x");
        nmsTag.remove("y");
        nmsTag.remove("z");
        return NBTHelper.getNBTFromNMSTagCompound(null, nmsTag);
    }

    @Override
    public CustomObjectStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public SpawnableObject getMojangStructurePart(String name) {
        MinecraftKey minecraftKey = new MinecraftKey(name);
        DefinedStructureManager mojangStructureParts = this.world.getDataManager().h();
        DefinedStructure mojangStructurePart = mojangStructureParts.a(this.world.getMinecraftServer(), minecraftKey);
        if (mojangStructurePart == null) {
            return null;
        }
        return new MojangStructurePart(name, mojangStructurePart);
    }

    @Override
    public void SpawnEntity(EntityFunction entityData) {
        block15: {
            boolean isBlockNormalCube;
            EntityType entityType;
            String nameTag;
            int groupSize;
            Random rand;
            block14: {
                rand = new Random();
                String mobTypeName = entityData.mobName;
                groupSize = entityData.groupSize;
                nameTag = entityData.nameTagOrNBTFileName;
                try {
                    entityType = EntityType.valueOf((String)mobTypeName.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    entityType = EntityType.fromName((String)mobTypeName);
                    if (entityType != null) break block14;
                    TerrainControl.log(LogMarker.WARN, "Could not find entity: " + mobTypeName, new Object[0]);
                    return;
                }
            }
            if (entityType == EntityType.PLAYER) {
                return;
            }
            net.minecraft.server.v1_10_R1.Entity entityLiving = this.getEntity(entityType.getEntityClass());
            CraftEntity bukkitEntityLiving = entityLiving.getBukkitEntity();
            boolean isWaterMob = bukkitEntityLiving instanceof CraftGuardian;
            if (entityLiving == null) break block15;
            EnumCreatureType creatureType = EnumCreatureType.CREATURE;
            if (bukkitEntityLiving instanceof CraftComplexLivingEntity || bukkitEntityLiving instanceof CraftSlime || bukkitEntityLiving instanceof CraftMonster || bukkitEntityLiving instanceof CraftFlying) {
                creatureType = EnumCreatureType.MONSTER;
            }
            if (bukkitEntityLiving instanceof CraftAmbient) {
                creatureType = EnumCreatureType.AMBIENT;
            }
            if (bukkitEntityLiving instanceof CraftAnimals || bukkitEntityLiving instanceof CraftVillager || bukkitEntityLiving instanceof CraftGolem) {
                creatureType = EnumCreatureType.CREATURE;
            }
            if (bukkitEntityLiving instanceof CraftWaterMob) {
                creatureType = EnumCreatureType.WATER_CREATURE;
            }
            int j1 = entityData.x;
            int k1 = entityData.y;
            int l1 = entityData.z;
            int x = entityData.x;
            int y = entityData.y;
            int z = entityData.z;
            CraftBlock block = (CraftBlock)this.world.getWorld().getBlockAt(new Location((org.bukkit.World)this.world.getWorld(), (double)x, (double)y, (double)z));
            org.bukkit.Material material = block.getType();
            boolean isOutsideBuildHeight = y < 0 || y >= 256;
            boolean isOpaque = material.isTransparent() ? false : material.isSolid();
            boolean isFullCube = material != org.bukkit.Material.STEP;
            boolean canProvidePower = block.isBlockPowered();
            boolean bl = isBlockNormalCube = !isOutsideBuildHeight && isOpaque && isFullCube && !canProvidePower;
            if (!(isBlockNormalCube || (creatureType != EnumCreatureType.WATER_CREATURE && !isWaterMob || material != org.bukkit.Material.WATER && material != org.bukkit.Material.STATIONARY_WATER) && material != org.bukkit.Material.AIR)) {
                float f = (float)j1 + 0.5f;
                float f1 = k1;
                float f2 = (float)l1 + 0.5f;
                if (entityLiving instanceof EntityLiving) {
                    for (int r = 0; r < groupSize; ++r) {
                        CraftEntity entity = (CraftEntity)this.world.getWorld().spawn(new Location((org.bukkit.World)this.world.getWorld(), (double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f), entityType.getEntityClass());
                        if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                            this.applyMetaData(entity, entityData.mobName, entityData.getMetaData());
                        }
                        if (entityData.nameTagOrNBTFileName != null && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt") && nameTag != null && nameTag.length() > 0) {
                            entity.setCustomName(nameTag);
                        }
                        if (!(entity instanceof CraftLivingEntity)) continue;
                        ((CraftLivingEntity)entity).setRemoveWhenFarAway(false);
                    }
                } else {
                    for (int r = 0; r < groupSize; ++r) {
                        CraftEntity entity = (CraftEntity)this.world.getWorld().spawn(new Location((org.bukkit.World)this.world.getWorld(), (double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f), entityType.getEntityClass());
                        if (entityData.nameTagOrNBTFileName == null || !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt")) continue;
                        this.applyMetaData(entity, entityData.mobName, entityData.getMetaData());
                    }
                }
            }
        }
    }

    private void applyMetaData(CraftEntity entity, String mobName, String metaDataString) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        try {
            NBTTagCompound nbtbase = JsonToNBT.getTagFromJson(metaDataString);
            if (!(nbtbase instanceof NBTTagCompound)) {
                TerrainControl.log(LogMarker.DEBUG, "Invalid NBT tag for mob in EntityFunction: " + metaDataString + ". Skipping mob.", new Object[0]);
                return;
            }
            nbttagcompound = nbtbase;
        }
        catch (NBTException nbtexception) {
            TerrainControl.log(LogMarker.DEBUG, "Invalid NBT tag for mob in EntityFunction: " + metaDataString + ". Skipping mob.", new Object[0]);
            return;
        }
        nbttagcompound.setString("id", mobName);
        net.minecraft.server.v1_10_R1.Entity nmsEntity = entity.getHandle();
        NBTTagCompound originalTag = new NBTTagCompound();
        nmsEntity.c(originalTag);
        NBTBase originalPos = originalTag.get("Pos");
        NBTBase originalRot = originalTag.get("Rotation");
        NBTBase originalUUIDLeast = originalTag.get("UUIDLeast");
        NBTBase originalUUIDMost = originalTag.get("UUIDMost");
        nbttagcompound.set("Pos", originalPos);
        nbttagcompound.set("Rotation", originalRot);
        nbttagcompound.set("UUIDLeast", originalUUIDLeast);
        nbttagcompound.set("UUIDMost", originalUUIDMost);
        nmsEntity.f(nbttagcompound);
        nmsEntity.recalcPosition();
    }

    private net.minecraft.server.v1_10_R1.Entity getEntity(Class<? extends Entity> clazz) {
        Object entity = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = new EntityBoat((World)this.world, x, y, z);
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            entity = new EntityFallingBlock((World)this.world, x, y, z, this.world.getType(new BlockPosition(x, y, z)));
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new EntitySnowball((World)this.world, x, y, z);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new EntityEgg((World)this.world, x, y, z);
            } else if (Arrow.class.isAssignableFrom(clazz)) {
                if (TippedArrow.class.isAssignableFrom(clazz)) {
                    entity = new EntityTippedArrow((World)this.world);
                    ((EntityTippedArrow)entity).setType(CraftPotionUtil.fromBukkit((PotionData)new PotionData(PotionType.WATER, false, false)));
                } else {
                    entity = SpectralArrow.class.isAssignableFrom(clazz) ? new EntitySpectralArrow((World)this.world) : new EntityTippedArrow((World)this.world);
                }
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = new EntityThrownExpBottle((World)this.world);
            } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                entity = new EntityEnderPearl((World)this.world);
            } else if (ThrownPotion.class.isAssignableFrom(clazz)) {
                entity = LingeringPotion.class.isAssignableFrom(clazz) ? new EntityPotion((World)this.world, x, y, z, CraftItemStack.asNMSCopy((ItemStack)new ItemStack(org.bukkit.Material.LINGERING_POTION, 1))) : new EntityPotion((World)this.world, x, y, z, CraftItemStack.asNMSCopy((ItemStack)new ItemStack(org.bukkit.Material.SPLASH_POTION, 1)));
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? new EntitySmallFireball((World)this.world) : (WitherSkull.class.isAssignableFrom(clazz) ? new EntityWitherSkull((World)this.world) : (DragonFireball.class.isAssignableFrom(clazz) ? new EntityDragonFireball((World)this.world) : new EntityLargeFireball((World)this.world)));
            } else if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                entity = new EntityShulkerBullet((World)this.world);
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartFurnace((World)this.world, x, y, z) : (StorageMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartChest((World)this.world, x, y, z) : (ExplosiveMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartTNT((World)this.world, x, y, z) : (HopperMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartHopper((World)this.world, x, y, z) : (SpawnerMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartMobSpawner((World)this.world, x, y, z) : (CommandMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartCommandBlock((World)this.world, x, y, z) : new EntityMinecartRideable((World)this.world, x, y, z))))));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new EntityEnderSignal((World)this.world, x, y, z);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = new EntityEnderCrystal((World)this.world);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = new EntityChicken((World)this.world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? new EntityMushroomCow((World)this.world) : new EntityCow((World)this.world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = new EntitySnowman((World)this.world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = new EntityIronGolem((World)this.world);
                } else if (Shulker.class.isAssignableFrom(clazz)) {
                    entity = new EntityShulker((World)this.world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = new EntityCreeper((World)this.world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = new EntityGhast((World)this.world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = new EntityPig((World)this.world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = new EntitySheep((World)this.world);
                } else if (Horse.class.isAssignableFrom(clazz)) {
                    entity = new EntityHorse((World)this.world);
                } else if (Skeleton.class.isAssignableFrom(clazz)) {
                    entity = new EntitySkeleton((World)this.world);
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? new EntityMagmaCube((World)this.world) : new EntitySlime((World)this.world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? new EntityCaveSpider((World)this.world) : new EntitySpider((World)this.world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = new EntitySquid((World)this.world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = new EntityWolf((World)this.world);
                    } else if (Ocelot.class.isAssignableFrom(clazz)) {
                        entity = new EntityOcelot((World)this.world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = new EntityPigZombie((World)this.world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = new EntityZombie((World)this.world);
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = new EntityGiantZombie((World)this.world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = new EntitySilverfish((World)this.world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = new EntityEnderman((World)this.world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = new EntityBlaze((World)this.world);
                } else if (Villager.class.isAssignableFrom(clazz)) {
                    entity = new EntityVillager((World)this.world);
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = new EntityWitch((World)this.world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = new EntityWither((World)this.world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        entity = new EntityEnderDragon((World)this.world);
                    }
                } else if (Ambient.class.isAssignableFrom(clazz)) {
                    if (Bat.class.isAssignableFrom(clazz)) {
                        entity = new EntityBat((World)this.world);
                    }
                } else if (Rabbit.class.isAssignableFrom(clazz)) {
                    entity = new EntityRabbit((World)this.world);
                } else if (Endermite.class.isAssignableFrom(clazz)) {
                    entity = new EntityEndermite((World)this.world);
                } else if (Guardian.class.isAssignableFrom(clazz)) {
                    entity = new EntityGuardian((World)this.world);
                } else if (ArmorStand.class.isAssignableFrom(clazz)) {
                    entity = new EntityArmorStand((World)this.world, x, y, z);
                } else if (PolarBear.class.isAssignableFrom(clazz)) {
                    entity = new EntityPolarBear((World)this.world);
                }
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new EntityTNTPrimed((World)this.world, x, y, z, null);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new EntityExperienceOrb((World)this.world, x, y, z, 0);
        } else if (Weather.class.isAssignableFrom(clazz)) {
            if (LightningStrike.class.isAssignableFrom(clazz)) {
                entity = new EntityLightning((World)this.world, x, y, z, false);
            }
        } else if (Firework.class.isAssignableFrom(clazz)) {
            entity = new EntityFireworks((World)this.world, x, y, z, null);
        } else if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
            entity = new EntityAreaEffectCloud((World)this.world, x, y, z);
        }
        return entity;
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, ConfigProvider configProvider) {
        return this.createBiomeFor(biomeConfig, biomeIds);
    }

    @Override
    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub) {
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        BlockPosition spawnPos = this.world.getSpawn();
        return ChunkCoordinate.fromBlockCoords(spawnPos.getX(), spawnPos.getZ());
    }
}

