/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.commands;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.bukkit.TCPerm;
import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.bukkit.commands.BaseCommand;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCollection;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;

public class ListCommand
extends BaseCommand {
    public ListCommand(TXPlugin _plugin) {
        super(_plugin);
        this.name = "list";
        this.perm = TCPerm.CMD_LIST.node;
        this.usage = "list [-w World] [page]";
        this.workOnConsole = false;
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        CustomObjectCollection globalObjects;
        int page = 1;
        if (args.size() > 1 && args.get(0).equals("-w")) {
            LocalWorld world;
            String worldName = args.get(1);
            if (args.size() > 2) {
                try {
                    page = Integer.parseInt(args.get(2));
                }
                catch (Exception e) {
                    sender.sendMessage(ERROR_COLOR + "Wrong page number " + args.get(2));
                }
            }
            if ((world = this.getWorld(sender, worldName)) != null) {
                if (world.getConfigs().getCustomObjects().isEmpty()) {
                    sender.sendMessage(MESSAGE_COLOR + "This world does not have custom objects");
                }
                ArrayList<String> pluginList = new ArrayList<String>();
                for (CustomObject object : world.getConfigs().getCustomObjects()) {
                    pluginList.add(VALUE_COLOR + object.getName());
                }
                this.ListMessage(sender, pluginList, page, "World objects");
            } else {
                sender.sendMessage(ERROR_COLOR + "World not found " + worldName);
            }
            return true;
        }
        if (args.size() > 0) {
            try {
                page = Integer.parseInt(args.get(0));
            }
            catch (Exception e) {
                sender.sendMessage(ERROR_COLOR + "Wrong page number " + args.get(0));
            }
        }
        if ((globalObjects = TerrainControl.getCustomObjectManager().getGlobalObjects()).isEmpty()) {
            sender.sendMessage(MESSAGE_COLOR + "This global directory does not have custom objects");
        }
        ArrayList<String> pluginList = new ArrayList<String>();
        for (CustomObject object : globalObjects) {
            if (!object.canSpawnAsObject()) continue;
            pluginList.add(VALUE_COLOR + object.getName());
        }
        this.ListMessage(sender, pluginList, page, "Global objects", "Use /otg list -w [world] for world objects");
        return true;
    }
}

