/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.events;

import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.bukkit.events.SaplingListener;
import com.khorn.terraincontrol.bukkit.events.TCSender;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class TCListener
implements Listener {
    private final TXPlugin tcPlugin;
    private final TCSender tcSender;
    private final SaplingListener saplingListener;

    public TCListener(TXPlugin plugin) {
        this.tcPlugin = plugin;
        this.tcSender = new TCSender(plugin);
        this.saplingListener = new SaplingListener();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldInit(WorldInitEvent event) {
        this.tcPlugin.onWorldInit(event.getWorld());
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.tcPlugin.onWorldUnload(event.getWorld());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onStructureGrow(StructureGrowEvent event) {
        this.saplingListener.onStructureGrow(event);
    }

    @EventHandler
    public void onPlayerRegisterChannel(PlayerRegisterChannelEvent event) {
        if (event.getChannel().equals("OpenTerrainGenerator")) {
            this.tcSender.send(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (player.getListeningPluginChannels().contains("OpenTerrainGenerator")) {
            this.tcSender.send(player);
        }
    }
}

