/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.MaterialSet;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.List;

public abstract class ConfigFunction<T> {
    private final T holder;

    public ConfigFunction(T holder) {
        this.holder = holder;
    }

    protected final void assureSize(int size, List<String> args) throws InvalidConfigException {
        if (args.size() < size) {
            throw new InvalidConfigException("Too few arguments supplied");
        }
    }

    protected final T getHolder() {
        return this.holder;
    }

    public abstract boolean isAnalogousTo(ConfigFunction<T> var1);

    protected final String makeMaterials(MaterialSet materials) {
        return "," + materials.toString();
    }

    public abstract String toString();

    protected final double readDouble(String string, double minValue, double maxValue) throws InvalidConfigException {
        return StringHelper.readDouble(string, minValue, maxValue);
    }

    protected final int readInt(String string, int minValue, int maxValue) throws InvalidConfigException {
        return StringHelper.readInt(string, minValue, maxValue);
    }

    protected final LocalMaterialData readMaterial(String string) throws InvalidConfigException {
        return TerrainControl.readMaterial(string);
    }

    protected final MaterialSet readMaterials(List<String> strings, int start) throws InvalidConfigException {
        MaterialSet materials = new MaterialSet();
        for (int i = start; i < strings.size(); ++i) {
            materials.parseAndAdd(strings.get(i));
        }
        return materials;
    }

    protected final double readRarity(String string) throws InvalidConfigException {
        return StringHelper.readDouble(string, 1.0E-6, 100.0);
    }
}

