/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.settingType;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.ArrayList;

public class MaterialListSetting
extends Setting<ArrayList<LocalMaterialData>> {
    private final DefaultMaterial[] defaultValue;

    public MaterialListSetting(String name, DefaultMaterial[] defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public ArrayList<LocalMaterialData> getDefaultValue() {
        ArrayList<LocalMaterialData> materials = new ArrayList<LocalMaterialData>();
        for (DefaultMaterial defaultMaterial : this.defaultValue) {
            materials.add(TerrainControl.toLocalMaterialData(defaultMaterial, 0));
        }
        return materials;
    }

    @Override
    public ArrayList<LocalMaterialData> read(String string) throws InvalidConfigException {
        String[] materialNames = string.split(",");
        ArrayList<LocalMaterialData> materials = new ArrayList<LocalMaterialData>();
        for (String materialName : materialNames) {
            materials.add(TerrainControl.readMaterial(materialName.trim()));
        }
        return materials;
    }

    @Override
    public String write(ArrayList<LocalMaterialData> value) {
        return StringHelper.join(value, ", ");
    }
}

