/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.configuration.io.SettingsMap;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.ObjectExtrusionHelper;
import com.khorn.terraincontrol.customobjects.StructurePartSpawnHeight;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.customobjects.bo3.BO3PlaceableFunction;
import com.khorn.terraincontrol.customobjects.bo3.BO3Settings;
import com.khorn.terraincontrol.customobjects.bo3.BlockFunction;
import com.khorn.terraincontrol.customobjects.bo3.EntityFunction;
import com.khorn.terraincontrol.util.BoundingBox;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.helpers.MathHelper;
import com.khorn.terraincontrol.util.helpers.RandomHelper;
import java.io.File;
import java.util.Map;
import java.util.Random;

public class BO3
implements CustomObject {
    private BO3Config settings;
    private final String name;
    private final File file;

    public BO3(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public BO3(BO3 oldObject, SettingsMap settings) {
        this.name = oldObject.name;
        this.file = oldObject.file;
        this.settings = new BO3Config(settings, this.file.getParentFile(), oldObject.settings.otherObjects);
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
        this.settings = new BO3Config(FileSettingsReader.read(this.name, this.file), this.file.getParentFile(), otherObjectsInDirectory);
        FileSettingsWriter.writeToFile(this.settings.getSettingsAsMap(), this.file, this.settings.settingsMode);
    }

    public int getOffsetAndVariance(Random random, int offset, int variance) {
        if (variance == 0) {
            return offset;
        }
        variance = variance < 0 ? -random.nextInt(MathHelper.abs(variance) + 1) : random.nextInt(variance + 1);
        return MathHelper.clamp(offset + variance, 0, 256);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public BO3Config getSettings() {
        return this.settings;
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.settings.tree;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        BO3PlaceableFunction[] blocks = this.settings.blocks[rotation.getRotationId()];
        BO3Check[] checks = this.settings.bo3Checks[rotation.getRotationId()];
        if (y < this.settings.minHeight || y > this.settings.maxHeight) {
            return false;
        }
        for (BO3Check check : checks) {
            if (!check.preventsSpawn(world, x + check.x, y + check.y, z + check.z)) continue;
            return false;
        }
        int blocksOutsideSourceBlock = 0;
        for (BO3PlaceableFunction block : blocks) {
            if (!world.isLoaded(x + block.x, y + block.y, z + block.z)) {
                return false;
            }
            if (this.settings.sourceBlocks.contains(world.getMaterial(x + block.x, y + block.y, z + block.z))) continue;
            ++blocksOutsideSourceBlock;
        }
        if ((double)blocksOutsideSourceBlock / (double)blocks.length * 100.0 > (double)this.settings.maxPercentageOutsideSourceBlock) {
            return false;
        }
        return TerrainControl.fireCanCustomObjectSpawnEvent(this, world, x, y, z);
    }

    @Override
    public boolean canRotateRandomly() {
        return this.settings.rotateRandomly;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        EntityFunction[] entities;
        BO3PlaceableFunction[] blocks = this.settings.blocks[rotation.getRotationId()];
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        for (BO3PlaceableFunction block : blocks) {
            if (this.settings.outsideSourceBlock == BO3Settings.OutsideSourceBlock.placeAnyway || this.settings.sourceBlocks.contains(world.getMaterial(x + block.x, y + block.y, z + block.z))) {
                block.spawn(world, random, x + block.x, y + block.y, z + block.z);
            }
            if (!(block instanceof BlockFunction)) continue;
            oeh.addBlock((BlockFunction)block);
        }
        for (EntityFunction entity : entities = this.settings.entityFunctions[rotation.getRotationId()]) {
            EntityFunction newEntityData = new EntityFunction(null);
            newEntityData.y = y + entity.y;
            newEntityData.x = x + entity.x;
            newEntityData.z = z + entity.z;
            newEntityData.mobName = entity.mobName;
            newEntityData.groupSize = entity.groupSize;
            newEntityData.nameTagOrNBTFileName = entity.nameTagOrNBTFileName;
            newEntityData.originalNameTagOrNBTFileName = entity.originalNameTagOrNBTFileName;
            world.SpawnEntity(newEntityData);
        }
        oeh.extrude(world, random, x, y, z);
        return true;
    }

    protected boolean spawn(LocalWorld world, Random random, int x, int z) {
        Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        int y = 0;
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.atMinY) {
            y = this.settings.minHeight;
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
            y = RandomHelper.numberInRange(random, this.settings.minHeight, this.settings.maxHeight);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
            y = world.getHighestBlockYAt(x, z);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
            y = world.getSolidHeight(x, z);
        }
        if (!this.canSpawnAt(world, rotation, x, y += this.getOffsetAndVariance(random, this.settings.spawnHeightOffset, this.settings.spawnHeightVariance), z)) {
            return false;
        }
        return this.spawnForced(world, random, rotation, x, y, z);
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        boolean atLeastOneObjectHasSpawned = false;
        int chunkMiddleX = chunkCoord.getBlockXCenter();
        int chunkMiddleZ = chunkCoord.getBlockZCenter();
        for (int i = 0; i < this.settings.frequency; ++i) {
            if (!(this.settings.rarity > random.nextDouble() * 100.0) || !this.spawn(world, random, chunkMiddleX + random.nextInt(16), chunkMiddleZ + random.nextInt(16))) continue;
            atLeastOneObjectHasSpawned = true;
        }
        return atLeastOneObjectHasSpawned;
    }

    @Override
    public CustomObject applySettings(SettingsMap extraSettings) {
        extraSettings.setFallback(this.settings.getSettingsAsMap());
        return new BO3(this, extraSettings);
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return !this.settings.excludedBiomes.contains("All") && !this.settings.excludedBiomes.contains("all") && !this.settings.excludedBiomes.contains(biome.getName());
    }

    @Override
    public boolean hasBranches() {
        return this.settings.branches[0].length != 0;
    }

    @Override
    public Branch[] getBranches(Rotation rotation) {
        return this.settings.branches[rotation.getRotationId()];
    }

    @Override
    public CustomObjectCoordinate makeCustomObjectCoordinate(Random random, int chunkX, int chunkZ) {
        if (this.settings.rarity > random.nextDouble() * 100.0) {
            Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
            int height = RandomHelper.numberInRange(random, this.settings.minHeight, this.settings.maxHeight);
            return new CustomObjectCoordinate(this, rotation, chunkX * 16 + 8 + random.nextInt(16), height, chunkZ * 16 + 8 + random.nextInt(16));
        }
        return null;
    }

    @Override
    public int getMaxBranchDepth() {
        return this.settings.maxBranchDepth;
    }

    @Override
    public StructurePartSpawnHeight getStructurePartSpawnHeight() {
        return this.settings.spawnHeight.toStructurePartSpawnHeight();
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return this.settings.boundingBoxes[rotation.getRotationId()];
    }
}

