/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.helpers.BlockHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class ForgeMaterialData
implements LocalMaterialData {
    private final IBlockState blockData;

    public static ForgeMaterialData ofString(String input) throws InvalidConfigException {
        Block block = Block.func_149684_b((String)input);
        if (block != null) {
            return ForgeMaterialData.ofMinecraftBlock(block);
        }
        try {
            return ForgeMaterialData.getMaterial0(input);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Unknown material: " + input);
        }
    }

    private static ForgeMaterialData getMaterial0(String input) throws NumberFormatException, InvalidConfigException {
        DefaultMaterial defaultMaterial;
        Block block;
        String blockName = input;
        int blockData = -1;
        int splitIndex = input.lastIndexOf(":");
        if (splitIndex == -1) {
            splitIndex = input.lastIndexOf(".");
        }
        if (splitIndex != -1) {
            blockName = input.substring(0, splitIndex);
            blockData = Integer.parseInt(input.substring(splitIndex + 1));
        }
        if ((block = Block.func_149684_b((String)blockName)) == null && (defaultMaterial = DefaultMaterial.getMaterial(blockName)) != DefaultMaterial.UNKNOWN_BLOCK) {
            block = Block.func_149729_e((int)defaultMaterial.id);
        }
        if (block != null) {
            if (blockData == -1) {
                return ForgeMaterialData.ofMinecraftBlock(block);
            }
            try {
                return ForgeMaterialData.ofMinecraftBlockState(block.func_176203_a(blockData));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Illegal block data for the block type, cannot use " + input);
            }
        }
        throw new InvalidConfigException("Unknown material: " + input);
    }

    private static ForgeMaterialData ofIds(int id, int data) {
        Block block = Block.func_149729_e((int)id);
        IBlockState blockData = block.func_176203_a(data);
        return ForgeMaterialData.ofMinecraftBlockState(blockData);
    }

    static ForgeMaterialData ofDefaultMaterial(DefaultMaterial material, int data) {
        return ForgeMaterialData.ofIds(material.id, data);
    }

    static ForgeMaterialData ofMinecraftBlock(Block block) {
        return ForgeMaterialData.ofMinecraftBlockState(block.func_176223_P());
    }

    public static ForgeMaterialData ofMinecraftBlockState(IBlockState blockData) {
        return new ForgeMaterialData(blockData);
    }

    private ForgeMaterialData(IBlockState blockData) {
        this.blockData = blockData;
    }

    @Override
    public boolean canSnowFallOn() {
        return this.toDefaultMaterial().canSnowFallOn();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForgeMaterialData)) {
            return false;
        }
        ForgeMaterialData other = (ForgeMaterialData)obj;
        return this.blockData.equals(other.blockData);
    }

    @Override
    public byte getBlockData() {
        return (byte)this.blockData.func_177230_c().func_176201_c(this.blockData);
    }

    @Override
    public int getBlockId() {
        return Block.func_149682_b((Block)this.blockData.func_177230_c());
    }

    @Override
    public String getName() {
        boolean nonDefaultData;
        Block block = this.blockData.func_177230_c();
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        byte data = this.getBlockData();
        boolean bl = nonDefaultData = !block.func_176223_P().equals(this.blockData);
        if (defaultMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
            if (nonDefaultData) {
                return Block.field_149771_c.func_177774_c((Object)this.blockData.func_177230_c()) + ":" + data;
            }
            return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.blockData.func_177230_c())).toString();
        }
        if (nonDefaultData) {
            return defaultMaterial.name() + ":" + this.getBlockData();
        }
        return defaultMaterial.name();
    }

    @Override
    public int hashCode() {
        return 65535 + this.getBlockId() * 16 + this.getBlockData();
    }

    @Override
    public int hashCodeWithoutBlockData() {
        return this.getBlockId();
    }

    @Override
    public boolean isLiquid() {
        return this.blockData.func_185904_a().func_76224_d();
    }

    @Override
    public boolean isMaterial(DefaultMaterial material) {
        return material.id == this.getBlockId();
    }

    @Override
    public boolean isSolid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return defaultMaterial.isSolid();
        }
        return this.blockData.func_185904_a().func_76220_a();
    }

    @Override
    public DefaultMaterial toDefaultMaterial() {
        return DefaultMaterial.getMaterial(this.getBlockId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public LocalMaterialData withBlockData(int i) {
        if (i == this.getBlockData()) {
            return this;
        }
        Block block = this.blockData.func_177230_c();
        return ForgeMaterialData.ofMinecraftBlockState(block.func_176203_a(i));
    }

    @Override
    public LocalMaterialData withDefaultBlockData() {
        Block block = this.blockData.func_177230_c();
        return this.withBlockData(block.func_176201_c(block.func_176223_P()));
    }

    public IBlockState internalBlock() {
        return this.blockData;
    }

    @Override
    public LocalMaterialData rotate() {
        byte blockDataByte;
        int newData;
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK && (newData = BlockHelper.rotateData(defaultMaterial, blockDataByte = this.getBlockData())) != blockDataByte) {
            return ForgeMaterialData.ofMinecraftBlockState(this.blockData.func_177230_c().func_176203_a(newData));
        }
        return this;
    }

    @Override
    public boolean isAir() {
        return this.blockData.func_185904_a() == Material.field_151579_a;
    }

    @Override
    public boolean canFall() {
        return this.blockData.func_177230_c() instanceof BlockFalling;
    }
}

