/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.google.common.base.Preconditions;
import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeConfigFinder;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ClientConfigProvider;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.ServerConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.standard.MojangSettings;
import com.khorn.terraincontrol.customobjects.CustomObjectStructureCache;
import com.khorn.terraincontrol.customobjects.bo3.EntityFunction;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.forge.ForgeBiome;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.forge.ForgeMojangSettings;
import com.khorn.terraincontrol.forge.TXDimensionManager;
import com.khorn.terraincontrol.forge.TXWorldServerMulti;
import com.khorn.terraincontrol.forge.generator.TXBiome;
import com.khorn.terraincontrol.forge.generator.TXChunkGenerator;
import com.khorn.terraincontrol.forge.generator.structure.MojangStructurePart;
import com.khorn.terraincontrol.forge.generator.structure.TXMineshaftGen;
import com.khorn.terraincontrol.forge.generator.structure.TXNetherFortressGen;
import com.khorn.terraincontrol.forge.generator.structure.TXOceanMonumentGen;
import com.khorn.terraincontrol.forge.generator.structure.TXRareBuildingGen;
import com.khorn.terraincontrol.forge.generator.structure.TXStrongholdGen;
import com.khorn.terraincontrol.forge.generator.structure.TXVillageGen;
import com.khorn.terraincontrol.forge.util.MobSpawnGroupHelper;
import com.khorn.terraincontrol.forge.util.NBTHelper;
import com.khorn.terraincontrol.generator.SpawnableObject;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.NamedBinaryTag;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeWorld
implements LocalWorld {
    public int clientDimensionId = 0;
    private TXChunkGenerator generator;
    public World world;
    private ConfigProvider settings;
    private CustomObjectStructureCache structureCache;
    private String name;
    public long seed;
    private BiomeGenerator biomeGenerator;
    private DataFixer dataFixer;
    private static final int MAX_BIOMES_COUNT = 1024;
    private static final int MAX_SAVED_BIOMES_COUNT = 255;
    private static final int STANDARD_WORLD_HEIGHT = 128;
    public HashMap<String, LocalBiome> biomeNames = new HashMap();
    public TXStrongholdGen strongholdGen;
    public TXVillageGen villageGen;
    public TXMineshaftGen mineshaftGen;
    public TXRareBuildingGen rareBuildingGen;
    public TXNetherFortressGen netherFortressGen;
    public TXOceanMonumentGen oceanMonumentGen;
    private WorldGenDungeons dungeonGen;
    private WorldGenFossils fossilGen;
    private WorldGenTrees tree;
    private WorldGenSavannaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenBirchTree birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenCanopyTree darkOakTree;
    private WorldGenShrub groundBush;
    private WorldGenBigMushroom hugeRedMushroom;
    private WorldGenBigMushroom hugeBrownMushroom;
    private WorldGenMegaPineTree hugeTaigaTree1;
    private WorldGenMegaPineTree hugeTaigaTree2;
    private WorldGenMegaJungle jungleTree;
    private WorldGenBirchTree longBirchTree;
    private WorldGenSwamp swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;
    private Chunk[] chunkCache;
    public static HashMap<Integer, ResourceLocation> vanillaResouceLocations = new HashMap();
    public static Biome[] vanillaBiomes = new Biome[1024];
    public static boolean vanillaBiomesCached = false;
    public boolean isMainWorld = false;

    public ForgeWorld(String _name, boolean isMainWorld) {
        TerrainControl.log(LogMarker.INFO, "Creating world \"" + _name + "\"", new Object[0]);
        this.name = _name;
        this.isMainWorld = isMainWorld;
        this.cacheVanillaBiomes();
        if (isMainWorld) {
            TXDimensionManager.UnloadAllCustomDimensionData();
            ((ForgeEngine)TerrainControl.getEngine()).worldLoader.unloadAllWorlds();
            ((ForgeEngine)TerrainControl.getEngine()).worldLoader.clearBiomeDictionary(null);
            ((ForgeEngine)TerrainControl.getEngine()).worldLoader.unRegisterDefaultBiomes();
            ((ForgeEngine)TerrainControl.getEngine()).worldLoader.unRegisterTCBiomes();
            TXDimensionManager.RemoveTCDims();
        }
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, ConfigProvider configProvider) {
        ForgeBiome forgeBiome;
        LocalBiome existingBiome;
        if (!this.isMainWorld && (existingBiome = TerrainControl.getBiomeAllWorlds(biomeConfig.getName())) != null && existingBiome.getBiomeConfig() != null) {
            biomeConfig = existingBiome.getBiomeConfig();
        }
        if (biomeConfig.getName().equals("Hell")) {
            forgeBiome = new ForgeBiome(Biomes.field_76778_j, biomeConfig, new BiomeIds(8, 8));
            this.biomeNames.put("Hell", forgeBiome);
            return forgeBiome;
        }
        if (biomeConfig.getName().equals("Sky")) {
            forgeBiome = new ForgeBiome(Biomes.field_76779_k, biomeConfig, new BiomeIds(9, 9));
            this.biomeNames.put("Sky", forgeBiome);
            return forgeBiome;
        }
        if (biomeConfig.getName().equals("The Void")) {
            forgeBiome = new ForgeBiome(Biomes.field_185440_P, biomeConfig, new BiomeIds(127, 127));
            this.biomeNames.put("The Void", forgeBiome);
            return forgeBiome;
        }
        forgeBiome = (ForgeBiome)TerrainControl.getBiomeAllWorlds(biomeConfig.getName());
        Biome biome = TXBiome.getOrCreateBiome(biomeConfig, biomeIds, this.isMainWorld);
        if (forgeBiome == null) {
            int allocatedGenerationId;
            Biome existingBiome2 = Biome.func_150568_d((int)biomeIds.getSavedId());
            int requestedGenerationId = biomeIds.getGenerationId();
            if (requestedGenerationId != (allocatedGenerationId = Biome.field_185377_q.field_148759_a.func_186815_a((Object)biome))) {
                biomeIds = new BiomeIds(requestedGenerationId, allocatedGenerationId);
                if (requestedGenerationId < 256 && allocatedGenerationId >= 256) {
                    throw new RuntimeException("Could not allocate the requested id " + requestedGenerationId + " for biome " + biomeConfig.getName() + ". All available id's under 256 have been allocated\n. To proceed, adjust your WorldConfig or use the ReplaceToBiomeName feature to make the biome virtual.");
                }
                TerrainControl.log(LogMarker.TRACE, "Asked to register {} with id {}, but succeeded with id {}", biomeConfig.getName(), requestedGenerationId, allocatedGenerationId);
            } else {
                TerrainControl.log(LogMarker.TRACE, "Registered {} with id {}", biomeConfig.getName(), allocatedGenerationId);
            }
            forgeBiome = new ForgeBiome(biome, biomeConfig, biomeIds);
            this.registerBiomeInBiomeDictionary(biome, existingBiome2, biomeConfig, configProvider);
        }
        this.biomeNames.put(biome.func_185359_l(), forgeBiome);
        return forgeBiome;
    }

    private void registerBiomeInBiomeDictionary(Biome biome, Biome sourceBiome, BiomeConfig biomeConfig, ConfigProvider configProvider) {
        ArrayList<Object> types = new ArrayList();
        if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.length() > 0) {
            LocalBiome replaceToBiome = configProvider.getBiomeByIdOrNull(Biome.func_185362_a((Biome)(sourceBiome != null ? sourceBiome : biome)));
            if (replaceToBiome == null) {
                int replaceToBiomeId = Biome.func_185362_a((Biome)(sourceBiome != null ? sourceBiome : biome));
                replaceToBiome = TerrainControl.getBiomeAllWorlds(replaceToBiomeId);
            }
            if (replaceToBiome != null && replaceToBiome.getBiomeConfig().biomeDictId != null) {
                types = this.getTypesList(replaceToBiome.getBiomeConfig().biomeDictId.split(","));
            }
        } else if (biomeConfig.biomeDictId != null && biomeConfig.biomeDictId.trim().length() > 0) {
            types = this.getTypesList(biomeConfig.biomeDictId.split(","));
        }
        BiomeDictionary.Type[] typeArr = new BiomeDictionary.Type[types.size()];
        types.toArray(typeArr);
        if (Biome.field_185377_q.func_177774_c((Object)biome) == null) {
            TerrainControl.log(LogMarker.WARN, "Biome " + biome.func_185359_l() + " could not be found in the registry. This can happen when a biome is a virtual biome (id > 255) but does not have a ReplaceToBiomeName configured.", new Object[0]);
        }
        BiomeDictionary.registerBiomeType((Biome)biome, (BiomeDictionary.Type[])typeArr);
    }

    private ArrayList<BiomeDictionary.Type> getTypesList(String[] typearr) {
        ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
        for (String typeString : typearr) {
            if (typeString == null || typeString.trim().length() <= 0) continue;
            BiomeDictionary.Type type = null;
            typeString = typeString.trim();
            try {
                type = BiomeDictionary.Type.getType((String)typeString, null);
            }
            catch (Exception ex) {
                TerrainControl.log(LogMarker.WARN, "Can't find BiomeDictId: \"" + typeString + "\".", new Object[0]);
            }
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    @Override
    public int getMaxBiomesCount() {
        return 1024;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 255;
    }

    @Override
    public int getFreeBiomeId() {
        throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
    }

    @Override
    public ArrayList<LocalBiome> getAllBiomes() {
        ArrayList<LocalBiome> biomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : this.settings.getBiomeArray()) {
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public ForgeBiome getBiomeById(int id) throws BiomeNotFoundException {
        throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
    }

    @Override
    public ForgeBiome getBiomeByIdOrNull(int id) {
        return (ForgeBiome)this.settings.getBiomeByIdOrNull(id);
    }

    @Override
    public LocalBiome getBiomeByNameOrNull(String name) {
        return this.biomeNames.get(name);
    }

    public Collection<BiomeLoadInstruction> getDefaultBiomes() {
        ArrayList<BiomeLoadInstruction> standardBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(ForgeMojangSettings.fromId(id), 128);
            standardBiomes.add(instruction);
        }
        return standardBiomes;
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled && dry) {
            this.villageGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public boolean placeDungeon(Random rand, int x, int y, int z) {
        return this.dungeonGen.func_180709_b(this.world, rand, new BlockPos(x, y, z));
    }

    @Override
    public boolean placeFossil(Random rand, ChunkCoordinate chunkCoord) {
        return this.fossilGen.func_180709_b(this.world, rand, new BlockPos(chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ()));
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        switch (type) {
            case Tree: {
                return this.tree.func_180709_b(this.world, rand, blockPos);
            }
            case BigTree: {
                return this.bigTree.func_180709_b(this.world, rand, blockPos);
            }
            case Forest: 
            case Birch: {
                return this.birchTree.func_180709_b(this.world, rand, blockPos);
            }
            case TallBirch: {
                return this.longBirchTree.func_180709_b(this.world, rand, blockPos);
            }
            case HugeMushroom: {
                if (rand.nextBoolean()) {
                    return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
                }
                return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case HugeRedMushroom: {
                return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case HugeBrownMushroom: {
                return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case SwampTree: {
                return this.swampTree.func_180709_b(this.world, rand, blockPos);
            }
            case Taiga1: {
                return this.taigaTree1.func_180709_b(this.world, rand, blockPos);
            }
            case Taiga2: {
                return this.taigaTree2.func_180709_b(this.world, rand, blockPos);
            }
            case JungleTree: {
                return this.jungleTree.func_180709_b(this.world, rand, blockPos);
            }
            case GroundBush: {
                return this.groundBush.func_180709_b(this.world, rand, blockPos);
            }
            case CocoaTree: {
                return this.cocoaTree.func_180709_b(this.world, rand, blockPos);
            }
            case Acacia: {
                return this.acaciaTree.func_180709_b(this.world, rand, blockPos);
            }
            case DarkOak: {
                return this.darkOakTree.func_180709_b(this.world, rand, blockPos);
            }
            case HugeTaiga1: {
                return this.hugeTaigaTree1.func_180709_b(this.world, rand, blockPos);
            }
            case HugeTaiga2: {
                return this.hugeTaigaTree2.func_180709_b(this.world, rand, blockPos);
            }
        }
        throw new RuntimeException("Failed to handle tree of type " + type.toString());
    }

    @Override
    public boolean placeDefaultStructures(Random rand, ChunkCoordinate chunkCoord) {
        ChunkPos chunkCoordIntPair = new ChunkPos(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        WorldConfig worldConfig = this.settings.getWorldConfig();
        boolean isVillagePlaced = false;
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.villagesEnabled) {
            isVillagePlaced = this.villageGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        return isVillagePlaced;
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
        if (!this.settings.getWorldConfig().BiomeConfigsHaveReplacement) {
            return;
        }
        Chunk[] cache = this.getChunkCache(chunkCoord);
        for (int i = 0; i < 4; ++i) {
            this.replaceBlocks(cache[i], 0, 0, 16);
        }
    }

    private void replaceBlocks(Chunk rawChunk, int startXInChunk, int startZInChunk, int size) {
        ExtendedBlockStorage[] sectionsArray;
        int endXInChunk = startXInChunk + size;
        int endZInChunk = startZInChunk + size;
        int worldStartX = rawChunk.field_76635_g * 16;
        int worldStartZ = rawChunk.field_76647_h * 16;
        for (ExtendedBlockStorage section : sectionsArray = rawChunk.func_76587_i()) {
            if (section == null) continue;
            for (int sectionX = startXInChunk; sectionX < endXInChunk; ++sectionX) {
                block2: for (int sectionZ = startZInChunk; sectionZ < endZInChunk; ++sectionZ) {
                    LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                    if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) continue;
                    IBlockState block = null;
                    LocalMaterialData[][] replaceArray = biome.getBiomeConfig().replacedBlocks.compiledInstructions;
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        block = section.func_186049_g().func_186016_a(sectionX, sectionY, sectionZ);
                        int blockId = Block.func_149682_b((Block)block.func_177230_c());
                        if (replaceArray[blockId] == null) continue;
                        int y = section.func_76662_d() + sectionY;
                        if (y >= replaceArray[blockId].length) continue block2;
                        ForgeMaterialData replaceTo = (ForgeMaterialData)replaceArray[blockId][y];
                        if (replaceTo == null || replaceTo.getBlockId() == blockId) continue;
                        section.func_177484_a(sectionX, sectionY, sectionZ, replaceTo.internalBlock());
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        WorldEntitySpawner.func_77191_a((World)this.getWorld(), (Biome)((ForgeBiome)biome).getHandle(), (int)chunkCoord.getBlockXCenter(), (int)chunkCoord.getBlockZCenter(), (int)16, (int)16, (Random)random);
    }

    private Chunk getChunk(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return null;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.chunkCache == null) {
            return this.world.func_72964_e(chunkX, chunkZ);
        }
        Chunk topLeftCachedChunk = this.chunkCache[0];
        int indexX = chunkX - topLeftCachedChunk.field_76635_g;
        int indexZ = chunkZ - topLeftCachedChunk.field_76647_h;
        if (!(indexX != 0 && indexX != 1 || indexZ != 0 && indexZ != 1)) {
            return this.chunkCache[indexX | indexZ << 1];
        }
        if (this.settings.getWorldConfig().populationBoundsCheck) {
            return null;
        }
        return this.getLoadedChunkWithoutMarkingActive(chunkX, chunkZ);
    }

    @Override
    public int getLiquidHeight(int x, int z) {
        for (int y = this.getHighestBlockYAt(x, z) - 1; y > 0; --y) {
            LocalMaterialData material = this.getMaterial(x, y, z);
            if (material.isLiquid()) {
                return y + 1;
            }
            if (!material.isSolid()) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getSolidHeight(int x, int z) {
        for (int y = this.getHighestBlockYAt(x, z) - 1; y > 0; --y) {
            LocalMaterialData material = this.getMaterial(x, y, z);
            if (!material.isSolid()) continue;
            return y + 1;
        }
        return -1;
    }

    @Override
    public boolean isEmpty(int x, int y, int z) {
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return true;
        }
        return chunk.func_186032_a(x & 0xF, y, z & 0xF).func_185904_a().equals(Material.field_151579_a);
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null || y < 0 || y >= 256) {
            return ForgeMaterialData.ofMinecraftBlock(Blocks.field_150350_a);
        }
        ExtendedBlockStorage section = chunk.func_76587_i()[y >> 4];
        if (section == null) {
            return ForgeMaterialData.ofMinecraftBlock(Blocks.field_150350_a);
        }
        IBlockState blockState = section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
        return ForgeMaterialData.ofMinecraftBlockState(blockState);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material) {
        if (y < 0 || y >= 256) {
            return;
        }
        DefaultMaterial defaultMaterial = material.toDefaultMaterial();
        if (defaultMaterial.equals((Object)DefaultMaterial.DIODE_BLOCK_ON)) {
            material = ForgeMaterialData.ofDefaultMaterial(DefaultMaterial.DIODE_BLOCK_OFF, material.getBlockData());
        } else if (defaultMaterial.equals((Object)DefaultMaterial.REDSTONE_COMPARATOR_ON)) {
            material = ForgeMaterialData.ofDefaultMaterial(DefaultMaterial.REDSTONE_COMPARATOR_OFF, material.getBlockData());
        }
        IBlockState newState = ((ForgeMaterialData)material).internalBlock();
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        IBlockState oldState = this.world.func_180495_p(pos);
        int oldLight = oldState.getLightValue((IBlockAccess)this.world, pos);
        int oldOpacity = oldState.getLightOpacity((IBlockAccess)this.world, pos);
        IBlockState iblockstate = chunk.func_177436_a(pos, newState);
        if (iblockstate == null) {
            return;
        }
        if (newState.getLightOpacity((IBlockAccess)this.world, pos) != oldOpacity || newState.getLightValue((IBlockAccess)this.world, pos) != oldLight) {
            this.world.field_72984_F.func_76320_a("checkLight");
            this.world.func_175664_x(pos);
            this.world.field_72984_F.func_76319_b();
        }
        this.world.markAndNotifyBlock(pos, chunk, iblockstate, newState, 2);
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        int y;
        Chunk chunk = this.getChunk(x, 0, z);
        if (chunk == null) {
            return -1;
        }
        boolean incorrectHeightMap = false;
        for (y = chunk.func_76611_b(x & 0xF, z & 0xF); y < this.getHeightCap() && chunk.func_186032_a(x, y, z).func_185904_a().func_76228_b(); ++y) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.func_175664_x(new BlockPos(x, y, z));
        }
        return y;
    }

    @Override
    public void startPopulation(ChunkCoordinate chunkCoord) {
        if (this.chunkCache != null && this.settings.getWorldConfig().populationBoundsCheck) {
            throw new IllegalStateException("Chunk is already being populated. This may be a bug in Open Terrain Generator, but it may also be another mod that is poking in unloaded chunks. Set PopulationBoundsCheck to false in the WorldConfig to disable this error.");
        }
        this.chunkCache = this.loadFourChunks(chunkCoord);
    }

    private Chunk[] getChunkCache(ChunkCoordinate topLeft) {
        if (this.chunkCache == null || !topLeft.coordsMatch(this.chunkCache[0].field_76635_g, this.chunkCache[0].field_76647_h)) {
            if (this.settings.getWorldConfig().populationBoundsCheck) {
                throw new IllegalStateException("chunkCache is null! You've got a bug!");
            }
            return this.loadFourChunks(topLeft);
        }
        return this.chunkCache;
    }

    private Chunk[] loadFourChunks(ChunkCoordinate topLeft) {
        Chunk[] chunkCache = new Chunk[4];
        for (int indexX = 0; indexX <= 1; ++indexX) {
            for (int indexZ = 0; indexZ <= 1; ++indexZ) {
                chunkCache[indexX | indexZ << 1] = this.world.func_72964_e(topLeft.getChunkX() + indexX, topLeft.getChunkZ() + indexZ);
            }
        }
        return chunkCache;
    }

    @Override
    public void endPopulation() {
        if (this.chunkCache == null && this.settings.getWorldConfig().populationBoundsCheck) {
            throw new IllegalStateException("Chunk is not being populated. This may be a bug in Open Terrain Generator, but it may also be another mod that is poking in unloaded chunks. Set PopulationBoundsCheck to false in the WorldConfig to disable this error.");
        }
        this.chunkCache = null;
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        return this.world.func_175699_k(new BlockPos(x, y, z));
    }

    @Override
    public boolean isLoaded(int x, int y, int z) {
        return this.getChunk(x, y, z) != null;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int getHeightCap() {
        return this.settings.getWorldConfig().worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.getWorldConfig().worldHeightScale;
    }

    public TXChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigsBukkit(WorldClient world, ClientConfigProvider config) {
        this.settings = config;
        this.world = world;
        this.seed = world.func_72905_C();
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigs(ClientConfigProvider config) {
        this.settings = config;
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientWorld(World world) {
        this.world = world;
        this.seed = world.func_72905_C();
    }

    public void provideConfigs(ServerConfigProvider configs) {
        Preconditions.checkNotNull((Object)configs, (Object)"configs");
        this.settings = configs;
    }

    public void provideWorldInstance(WorldServer world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        Preconditions.checkState((this.world == null ? 1 : 0) != 0, (Object)"world was already initialized");
        Preconditions.checkState((boolean)(this.settings instanceof ServerConfigProvider), (Object)"server configs must be provided first");
        ServerConfigProvider configs = (ServerConfigProvider)this.settings;
        if (!this.isMainWorld && !(world instanceof TXWorldServerMulti)) {
            long seedIn = (long)Math.floor(Math.random() * 9.223372036854776E18);
            if (configs.getWorldConfig().worldSeed != null && configs.getWorldConfig().worldSeed.trim().length() > 0) {
                try {
                    seedIn = configs.getWorldConfig().worldSeed == null || configs.getWorldConfig().worldSeed.trim().length() == 0 ? (long)Math.floor(Math.random() * 9.223372036854776E18) : Long.parseLong(configs.getWorldConfig().worldSeed);
                }
                catch (NumberFormatException ex) {
                    TerrainControl.log(LogMarker.ERROR, "WorldConfig for world \"" + world.func_72912_H().func_76065_j() + "\" has value \"" + configs.getWorldConfig().worldSeed + "\" for worldSeed which cannot be parsed as a number. Using a random seed instead.", new Object[0]);
                }
            }
            GameType gameType = world.func_72912_H().func_76077_q();
            boolean enableMapFeatures = world.func_72912_H().func_76089_r();
            boolean hardcoreMode = world.func_72912_H().func_76093_s();
            WorldType worldTypeIn = world.func_175624_G();
            String generatorOptions = world.func_72912_H().func_82571_y();
            boolean enableCommands = world.func_72912_H().func_76086_u();
            WorldSettings settings = new WorldSettings(seedIn, gameType, enableMapFeatures, hardcoreMode, worldTypeIn);
            settings.func_82750_a(generatorOptions);
            if (enableCommands) {
                settings.func_77166_b();
            }
            WorldInfo worldInfo = new WorldInfo(settings, world.func_72912_H().func_76065_j());
            try {
                Field[] fields;
                for (Field field : fields = World.class.getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(WorldInfo.class)) continue;
                    field.setAccessible(true);
                    field.set(world, worldInfo);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.world = world;
        this.seed = world.func_72912_H().func_76063_b();
        world.func_181544_b(configs.getWorldConfig().waterLevelMax);
        this.structureCache = new CustomObjectStructureCache(this);
        this.dataFixer = DataFixesManager.func_188279_a();
        this.dungeonGen = new WorldGenDungeons();
        this.fossilGen = new WorldGenFossils();
        this.strongholdGen = new TXStrongholdGen(configs);
        this.villageGen = new TXVillageGen(configs);
        this.mineshaftGen = new TXMineshaftGen();
        this.rareBuildingGen = new TXRareBuildingGen(configs);
        this.netherFortressGen = new TXNetherFortressGen();
        this.oceanMonumentGen = new TXOceanMonumentGen(configs);
        IBlockState jungleLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.tree = new WorldGenTrees(false);
        this.acaciaTree = new WorldGenSavannaTree(false);
        this.cocoaTree = new WorldGenTrees(false, 5, jungleLog, jungleLeaves, true);
        this.bigTree = new WorldGenBigTree(false);
        this.birchTree = new WorldGenBirchTree(false, false);
        this.darkOakTree = new WorldGenCanopyTree(false);
        this.longBirchTree = new WorldGenBirchTree(false, true);
        this.swampTree = new WorldGenSwamp();
        this.taigaTree1 = new WorldGenTaiga1();
        this.taigaTree2 = new WorldGenTaiga2(false);
        this.hugeRedMushroom = new WorldGenBigMushroom(Blocks.field_150419_aX);
        this.hugeBrownMushroom = new WorldGenBigMushroom(Blocks.field_150420_aW);
        this.hugeTaigaTree1 = new WorldGenMegaPineTree(false, false);
        this.hugeTaigaTree2 = new WorldGenMegaPineTree(false, true);
        this.jungleTree = new WorldGenMegaJungle(false, 10, 20, jungleLog, jungleLeaves);
        this.groundBush = new WorldGenShrub(jungleLog, jungleLeaves);
        this.generator = new TXChunkGenerator(this);
    }

    public void setBiomeGenerator(BiomeGenerator generator) {
        this.biomeGenerator = generator;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public LocalBiome getCalculatedBiome(int x, int z) {
        return TerrainControl.isForge ? TerrainControl.getBiomeAllWorlds(this.biomeGenerator.getBiome(x, z)) : this.getBiomeById(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        if (this.settings.getWorldConfig().populateUsingSavedBiomes) {
            return this.getSavedBiome(x, z);
        }
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public LocalBiome getSavedBiome(int x, int z) throws BiomeNotFoundException {
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_180494_b(pos);
        int biomeId = biome instanceof TXBiome ? ((TXBiome)biome).generationId : Biome.func_185362_a((Biome)biome);
        ForgeBiome forgeBiome = (ForgeBiome)TerrainControl.getBiomeAllWorlds(biomeId);
        return forgeBiome;
    }

    @Override
    public void attachMetadata(int x, int y, int z, NamedBinaryTag tag) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.func_74768_a("x", x);
        nmsTag.func_74768_a("y", y);
        nmsTag.func_74768_a("z", z);
        nmsTag = this.dataFixer.func_188251_a((IFixType)FixTypes.BLOCK_ENTITY, nmsTag, -1);
        TileEntity tileEntity = this.world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null) {
            tileEntity.func_145839_a(nmsTag);
        } else {
            TerrainControl.log(LogMarker.DEBUG, "Skipping tile entity with id {}, cannot be placed at {},{},{} on id {}", nmsTag.func_74779_i("id"), x, y, z, this.getMaterial(x, y, z));
        }
    }

    @Override
    public NamedBinaryTag getMetadata(int x, int y, int z) {
        TileEntity tileEntity = this.world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nmsTag = new NBTTagCompound();
        tileEntity.func_189515_b(nmsTag);
        nmsTag.func_82580_o("x");
        nmsTag.func_82580_o("y");
        nmsTag.func_82580_o("z");
        return NBTHelper.getNBTFromNMSTagCompound(null, nmsTag);
    }

    @Override
    public CustomObjectStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public SpawnableObject getMojangStructurePart(String name) {
        ResourceLocation resourceLocation = new ResourceLocation(name);
        TemplateManager mojangStructureParts = this.world.func_72860_G().func_186340_h();
        Template mojangStructurePart = mojangStructureParts.func_186237_a(this.world.func_73046_m(), resourceLocation);
        if (mojangStructurePart == null) {
            return null;
        }
        return new MojangStructurePart(name, mojangStructurePart);
    }

    public Chunk getLoadedChunkWithoutMarkingActive(int chunkX, int chunkZ) {
        ChunkProviderServer chunkProviderServer = (ChunkProviderServer)this.world.func_72863_F();
        long i = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        return (Chunk)chunkProviderServer.field_73244_f.get(i);
    }

    private void cacheVanillaBiomes() {
        if (!vanillaBiomesCached) {
            block0: for (DefaultBiome defaultBiome : DefaultBiome.values()) {
                Biome oldBiome;
                int biomeId = defaultBiome.Id;
                ForgeWorld.vanillaBiomes[biomeId] = oldBiome = Biome.func_150568_d((int)biomeId);
                for (ResourceLocation ob : Biome.field_185377_q.field_82596_a.keySet()) {
                    int vanillaBiomeId = Biome.func_185362_a((Biome)((Biome)Biome.field_185377_q.func_82594_a((Object)ob)));
                    if (biomeId != vanillaBiomeId) continue;
                    vanillaResouceLocations.put(vanillaBiomeId, ob);
                    continue block0;
                }
            }
            vanillaBiomesCached = true;
        }
    }

    @Override
    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub) {
        Biome biome = null;
        String biomeName = biomeConfigStub.getBiomeName();
        for (Biome vanillaBiome : vanillaBiomes) {
            if (vanillaBiome == null || !vanillaBiome.func_185359_l().equals(biomeName) || vanillaBiome instanceof TXBiome) continue;
            biome = vanillaBiome;
            break;
        }
        if (biome != null) {
            biomeConfigStub.spawnMonstersMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnMonstersMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.MONSTER));
            biomeConfigStub.spawnCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.CREATURE));
            biomeConfigStub.spawnAmbientCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnAmbientCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.AMBIENT_CREATURE));
            biomeConfigStub.spawnWaterCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnWaterCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.WATER_CREATURE));
        }
    }

    public void unRegisterBiomes() {
        for (LocalBiome localBiome : this.biomeNames.values()) {
            if (localBiome.getName().equals("The Void") || localBiome.getName().equals("The End") || localBiome.getName().equals("Hell") || localBiome.getName().equals("Sky") || !((ForgeEngine)TerrainControl.getEngine()).worldLoader.isConfigUnique(localBiome.getBiomeConfig().getName())) continue;
            String biomeNameForRegistry = StringHelper.toComputerFriendlyName(localBiome.getName());
            String resourceDomain = "OpenTerrainGenerator".toLowerCase();
            ResourceLocation registryKey = new ResourceLocation(resourceDomain, biomeNameForRegistry);
            ((ForgeEngine)TerrainControl.getEngine()).unRegisterForgeBiome(registryKey);
        }
        ((ForgeEngine)TerrainControl.getEngine()).worldLoader.clearBiomeDictionary(this);
    }

    @Override
    public void SpawnEntity(EntityFunction entityData) {
        block30: {
            if (TerrainControl.getPluginConfig().SpawnLog) {
                TerrainControl.log(LogMarker.INFO, "Attempting to spawn BO3 Entity() " + entityData.groupSize + " x " + entityData.mobName + " at " + entityData.x + " " + entityData.y + " " + entityData.z, new Object[0]);
            }
            Random rand = new Random();
            String mobTypeName = entityData.mobName;
            int groupSize = entityData.groupSize;
            String nameTag = entityData.nameTagOrNBTFileName;
            Class entityClass = null;
            for (String entry : EntityList.field_75625_b.keySet()) {
                if (!entry.toLowerCase().replace("entity", "").replace("_", "").equals(mobTypeName.toLowerCase().replace("entity", "").replace("_", ""))) continue;
                entityClass = (Class)EntityList.field_75625_b.get(entry);
                break;
            }
            if (entityClass == null) {
                TerrainControl.log(LogMarker.WARN, "Could not find entity: " + mobTypeName, new Object[0]);
                return;
            }
            Entity entityliving = null;
            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        TerrainControl.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                        return;
                    }
                    nbttagcompound = nbtbase;
                }
                catch (NBTException nbtexception) {
                    TerrainControl.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                    return;
                }
                nbttagcompound.func_74778_a("id", entityData.mobName);
                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
            } else {
                try {
                    entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(this.world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (entityliving == null) break block30;
            EnumCreatureType creatureType = EnumCreatureType.MONSTER;
            if (!(entityliving.isCreatureType(creatureType, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.CREATURE, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.AMBIENT, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.WATER_CREATURE, false))) {
                creatureType = EnumCreatureType.CREATURE;
            }
            int j1 = entityData.x;
            int k1 = entityData.y;
            int l1 = entityData.z;
            boolean isWaterMob = entityliving instanceof EntityGuardian;
            Material material = this.world.func_180495_p(new BlockPos(j1, k1, l1)).func_185904_a();
            if (!this.world.func_175677_d(new BlockPos(j1, k1, l1), false) && ((creatureType == EnumCreatureType.WATER_CREATURE || isWaterMob) && material == Material.field_151586_h || material == Material.field_151579_a)) {
                float f = (float)j1 + 0.5f;
                float f1 = k1;
                float f2 = (float)l1 + 0.5f;
                entityliving.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                if (entityliving instanceof EntityLiving) {
                    for (int r = 0; r < groupSize; ++r) {
                        if (r != 0) {
                            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                try {
                                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                                    if (!(nbtbase instanceof NBTTagCompound)) {
                                        TerrainControl.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                        return;
                                    }
                                    nbttagcompound = nbtbase;
                                }
                                catch (NBTException nbtexception) {
                                    TerrainControl.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                    return;
                                }
                                nbttagcompound.func_74778_a("id", entityData.mobName);
                                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
                            } else {
                                try {
                                    entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(this.world);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    return;
                                }
                            }
                            entityliving.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                        }
                        if (entityData.nameTagOrNBTFileName != null && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt") && nameTag != null && nameTag.length() > 0) {
                            ((EntityLiving)entityliving).func_96094_a(nameTag);
                        }
                        ((EntityLiving)entityliving).func_110163_bv();
                        if (TerrainControl.getPluginConfig().SpawnLog) {
                            TerrainControl.log(LogMarker.INFO, "Spawned OK", new Object[0]);
                        }
                        this.world.func_72838_d(entityliving);
                    }
                } else {
                    for (int r = 0; r < groupSize; ++r) {
                        if (r != 0) {
                            try {
                                entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(this.world);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return;
                            }
                            entityliving.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                        }
                        if (TerrainControl.getPluginConfig().SpawnLog) {
                            TerrainControl.log(LogMarker.INFO, "Spawned OK", new Object[0]);
                        }
                        this.world.func_72838_d(entityliving);
                    }
                }
            }
        }
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        BlockPos spawnPos = this.getSpawnPoint();
        return ChunkCoordinate.fromBlockCoords(spawnPos.func_177958_n(), spawnPos.func_177952_p());
    }

    public BlockPos getSpawnPoint() {
        BlockPos spawnPos = this.world.field_73011_w.getSpawnPoint();
        return new BlockPos(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
    }

    public boolean IsInsideWorldBorder(ChunkCoordinate chunk, boolean spawningResources) {
        BlockPos spawnPoint = this.getSpawnPoint();
        ChunkCoordinate spawnChunk = ChunkCoordinate.fromBlockCoords(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
        return ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius == 0 || chunk.getChunkX() >= spawnChunk.getChunkX() - (((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius - 1) && chunk.getChunkX() <= spawnChunk.getChunkX() + (((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius - 1) - (spawningResources ? 1 : 0) && chunk.getChunkZ() >= spawnChunk.getChunkZ() - (((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius - 1) && chunk.getChunkZ() <= spawnChunk.getChunkZ() + (((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius - 1) - (spawningResources ? 1 : 0);
    }
}

