/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ServerConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.forge.DimensionData;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.OTGDimensionInfo;
import com.khorn.terraincontrol.forge.TXWorldServerMulti;
import com.khorn.terraincontrol.forge.WorldProviderTX;
import com.khorn.terraincontrol.forge.generator.Cartographer;
import com.khorn.terraincontrol.logging.LogMarker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;

public class TXDimensionManager {
    static HashMap<Integer, Integer> dimensionsOrder;
    private static Hashtable<Integer, DimensionType> oldDims;

    public static boolean isDimensionNameRegistered(String dimensionName) {
        for (int i = 2; i < 1024; ++i) {
            DimensionType dimensionType;
            if (!DimensionManager.isDimensionRegistered((int)i) || !(dimensionType = DimensionManager.getProviderType((int)i)).func_186067_c().equals("OTG") || !dimensionType.func_186065_b().equals(dimensionName)) continue;
            return true;
        }
        return false;
    }

    public static int createDimension(String dimensionName, boolean keepLoaded, boolean initDimension, boolean saveDimensionData) {
        int newDimId = DimensionManager.getNextFreeDimId();
        DimensionManager.registerDimension((int)newDimId, (DimensionType)DimensionType.register((String)dimensionName, (String)"OTG", (int)newDimId, WorldProviderTX.class, (boolean)keepLoaded));
        if (initDimension) {
            TXDimensionManager.initDimension(newDimId, dimensionName);
        }
        int maxOrder = -1;
        for (Integer dimOrder : dimensionsOrder.values()) {
            if (dimOrder <= maxOrder) continue;
            maxOrder = dimOrder;
        }
        dimensionsOrder.put(newDimId, maxOrder + 1);
        if (saveDimensionData) {
            TXDimensionManager.SaveDimensionData();
        }
        return newDimId;
    }

    public static void DeleteDimension(int dimToRemove, ForgeWorld world, MinecraftServer server, boolean saveDimensionData) {
        if (DimensionManager.getWorld((int)dimToRemove) != null) {
            DimensionManager.setWorld((int)dimToRemove, null, (MinecraftServer)server);
        }
        if (DimensionManager.isDimensionRegistered((int)dimToRemove)) {
            DimensionManager.unregisterDimension((int)dimToRemove);
        }
        world.unRegisterBiomes();
        ((ForgeEngine)TerrainControl.getEngine()).worldLoader.RemoveUnloadedWorld(world.getName());
        TXDimensionManager.UnloadCustomDimensionData(dimToRemove);
        BitSet dimensionMap = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        dimensionMap.clear(dimToRemove);
        if (saveDimensionData) {
            File dimensionSaveDir = new File(world.getWorld().func_72860_G().func_75765_b() + "/DIM" + dimToRemove);
            if (dimensionSaveDir.exists() && dimensionSaveDir.isDirectory()) {
                TerrainControl.log(LogMarker.INFO, "Deleting world save data for dimension " + dimToRemove, new Object[0]);
                try {
                    FileUtils.deleteDirectory((File)dimensionSaveDir);
                }
                catch (IOException e) {
                    TerrainControl.log(LogMarker.ERROR, "Could not delete directory: " + e.toString(), new Object[0]);
                    e.printStackTrace();
                }
            }
            TXDimensionManager.SaveDimensionData();
        }
    }

    private static void initDimension(int dim, String dimensionName) {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType((int)dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.func_73046_m();
        ISaveHandler savehandler = overworld.func_72860_G();
        long seedIn = (long)Math.floor(Math.random() * 9.223372036854776E18);
        GameType gameType = mcServer.func_71265_f();
        boolean enableMapFeatures = overworld.func_72912_H().func_76089_r();
        boolean hardcoreMode = overworld.func_72912_H().func_76093_s();
        WorldType worldTypeIn = overworld.func_175624_G();
        WorldSettings settings = new WorldSettings(seedIn, gameType, enableMapFeatures, hardcoreMode, worldTypeIn);
        WorldInfo worldInfo = new WorldInfo(settings, overworld.func_72912_H().func_76065_j());
        WorldServer world = (WorldServer)new TXWorldServerMulti(mcServer, savehandler, dim, overworld, mcServer.field_71304_b, worldInfo).func_175643_b();
        ForgeWorld forgeWorld = (ForgeWorld)TerrainControl.getWorld(dimensionName);
        if (forgeWorld == null) {
            forgeWorld = (ForgeWorld)TerrainControl.getUnloadedWorld(dimensionName);
        }
        if (forgeWorld != null) {
            ((ServerConfigProvider)forgeWorld.getConfigs()).getWorldConfig().worldSeed = "" + seedIn;
            ((ServerConfigProvider)forgeWorld.getConfigs()).saveWorldConfig();
            WorldConfig worldConfig = ((ServerConfigProvider)forgeWorld.getConfigs()).getWorldConfig();
            world.func_82736_K().func_82764_b("commandBlockOutput", worldConfig.commandBlockOutput);
            world.func_82736_K().func_82764_b("disableElytraMovementCheck", worldConfig.disableElytraMovementCheck);
            world.func_82736_K().func_82764_b("doDaylightCycle", worldConfig.doDaylightCycle);
            world.func_82736_K().func_82764_b("doEntityDrops", worldConfig.doEntityDrops);
            world.func_82736_K().func_82764_b("doFireTick", worldConfig.doFireTick);
            world.func_82736_K().func_82764_b("doMobLoot", worldConfig.doMobLoot);
            world.func_82736_K().func_82764_b("doMobSpawning", worldConfig.doMobSpawning);
            world.func_82736_K().func_82764_b("doTileDrops", worldConfig.doTileDrops);
            world.func_82736_K().func_82764_b("doWeatherCycle", worldConfig.doWeatherCycle);
            world.func_82736_K().func_82764_b("keepInventory", worldConfig.keepInventory);
            world.func_82736_K().func_82764_b("logAdminCommands", worldConfig.logAdminCommands);
            world.func_82736_K().func_82764_b("maxEntityCramming", worldConfig.maxEntityCramming);
            world.func_82736_K().func_82764_b("mobGriefing", worldConfig.mobGriefing);
            world.func_82736_K().func_82764_b("naturalRegeneration", worldConfig.naturalRegeneration);
            world.func_82736_K().func_82764_b("randomTickSpeed", worldConfig.randomTickSpeed);
            world.func_82736_K().func_82764_b("reducedDebugInfo", worldConfig.reducedDebugInfo);
            world.func_82736_K().func_82764_b("sendCommandFeedback", worldConfig.sendCommandFeedback);
            world.func_82736_K().func_82764_b("showDeathMessages", worldConfig.showDeathMessages);
            world.func_82736_K().func_82764_b("spawnRadius", worldConfig.spawnRadius);
            world.func_82736_K().func_82764_b("spectatorsGenerateChunks", worldConfig.spectatorsGenerateChunks);
        }
        world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(mcServer, world));
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SaveDimensionData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dimensionDataFile = new File(world.func_72860_G().func_75765_b() + "/OpenTerrainGenerator/Dimensions.txt");
        if (dimensionDataFile.exists()) {
            dimensionDataFile.delete();
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = 2; i < 1024; ++i) {
            DimensionType dimType;
            if (!DimensionManager.isDimensionRegistered((int)i) || (dimType = DimensionManager.getProviderType((int)i)) == null) continue;
            ForgeWorld forgeWorld = (ForgeWorld)TerrainControl.getWorld(dimType.func_186065_b());
            if (forgeWorld == null) {
                forgeWorld = (ForgeWorld)TerrainControl.getUnloadedWorld(dimType.func_186065_b());
            }
            if (forgeWorld == null) {
                return;
            }
            if (forgeWorld == null) continue;
            stringbuilder.append((stringbuilder.length() == 0 ? "" : ",") + i + "," + dimType.func_186065_b() + "," + dimType.shouldLoadSpawn() + "," + forgeWorld.getSeed() + "," + dimensionsOrder.get(i));
        }
        BufferedWriter writer = null;
        try {
            dimensionDataFile.getParentFile().mkdirs();
            writer = new BufferedWriter(new FileWriter(dimensionDataFile));
            writer.write(stringbuilder.toString());
            TerrainControl.log(LogMarker.TRACE, "Custom dimension data saved", new Object[0]);
        }
        catch (IOException e) {
            TerrainControl.log(LogMarker.ERROR, "Could not save custom dimension data.", new Object[0]);
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void UnloadAllCustomDimensionData() {
        dimensionsOrder = new HashMap();
        BitSet dimensionMap = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (int i = 2; i < 1024; ++i) {
            DimensionType dimType;
            if (!DimensionManager.isDimensionRegistered((int)i) || (dimType = DimensionManager.getProviderType((int)i)) == null || !dimType.func_186067_c().equals("OTG")) continue;
            DimensionManager.unregisterDimension((int)i);
            dimensionMap.clear(i);
        }
    }

    public static void UnloadCustomDimensionData(int dimId) {
        DimensionType dimType;
        dimensionsOrder.remove(dimId);
        BitSet dimensionMap = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (DimensionManager.isDimensionRegistered((int)dimId) && (dimType = DimensionManager.getProviderType((int)dimId)) != null && dimType.func_186067_c() != null && dimType.func_186067_c().equals("OTG")) {
            DimensionManager.unregisterDimension((int)dimId);
            dimensionMap.clear(dimId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OTGDimensionInfo GetOrderedDimensionData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dimensionDataFile = new File(world.func_72860_G().func_75765_b() + "/OpenTerrainGenerator/Dimensions.txt");
        String[] dimensionDataFileValues = new String[]{};
        if (dimensionDataFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new FileReader(dimensionDataFile));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        dimensionDataFileValues = stringbuilder.toString().split(",");
                    }
                    TerrainControl.log(LogMarker.TRACE, "Custom dimension data loaded", new Object[0]);
                }
                finally {
                    reader.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<DimensionData> dimensionData = new ArrayList<DimensionData>();
        if (dimensionDataFileValues.length > 0) {
            for (int i = 0; i < dimensionDataFileValues.length; i += 5) {
                DimensionData dimData = new DimensionData();
                dimData.dimensionId = Integer.parseInt(dimensionDataFileValues[i]);
                dimData.dimensionName = dimensionDataFileValues[i + 1];
                dimData.keepLoaded = Boolean.parseBoolean(dimensionDataFileValues[i + 2]);
                dimData.seed = Long.parseLong(dimensionDataFileValues[i + 3]);
                dimData.dimensionOrder = Integer.parseInt(dimensionDataFileValues[i + 4]);
                dimensionData.add(dimData);
            }
        }
        dimensionsOrder = new HashMap();
        HashMap<Integer, DimensionData> orderedDimensions = new HashMap<Integer, DimensionData>();
        int highestOrder = 0;
        for (DimensionData dimData : dimensionData) {
            dimensionsOrder.put(dimData.dimensionId, dimData.dimensionOrder);
            orderedDimensions.put(dimData.dimensionOrder, dimData);
            if (dimData.dimensionOrder <= highestOrder) continue;
            highestOrder = dimData.dimensionOrder;
        }
        return new OTGDimensionInfo(highestOrder, orderedDimensions);
    }

    public static void LoadCustomDimensionData() {
        OTGDimensionInfo otgDimData = TXDimensionManager.GetOrderedDimensionData();
        for (int i = 0; i <= otgDimData.highestOrder; ++i) {
            if (!otgDimData.orderedDimensions.containsKey(i)) continue;
            DimensionData dimData = otgDimData.orderedDimensions.get(i);
            if (DimensionManager.isDimensionRegistered((int)dimData.dimensionId)) continue;
            DimensionManager.registerDimension((int)dimData.dimensionId, (DimensionType)DimensionType.register((String)dimData.dimensionName, (String)"OTG", (int)dimData.dimensionId, WorldProviderTX.class, (boolean)dimData.keepLoaded));
            if (dimData.dimensionName.equals("DIM-Cartographer")) {
                Cartographer.CartographerDimension = dimData.dimensionId;
            }
            DimensionManager.initDimension((int)dimData.dimensionId);
        }
    }

    public static void RemoveTCDims() {
        Hashtable dimensions = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Object value;
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Hashtable.class)) continue;
                field.setAccessible(true);
                Hashtable fieldAsHashTable = (Hashtable)field.get(new DimensionManager());
                if (fieldAsHashTable.values().size() <= 0 || !((value = fieldAsHashTable.values().toArray()[0]) instanceof DimensionType)) continue;
                dimensions = (Hashtable)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        oldDims = new Hashtable();
        for (int i = 2; i < 1024; ++i) {
            if (!dimensions.containsKey(i) || !((DimensionType)dimensions.get(i)).func_186067_c().equals("OTG")) continue;
            oldDims.put(i, (DimensionType)dimensions.get(i));
            dimensions.remove(i);
        }
    }

    public static HashMap<Integer, String> GetAllOTGDimensions() {
        Hashtable dimensions = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Object value;
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Hashtable.class)) continue;
                field.setAccessible(true);
                Hashtable fieldAsHashTable = (Hashtable)field.get(new DimensionManager());
                if (fieldAsHashTable.values().size() <= 0 || !((value = fieldAsHashTable.values().toArray()[0]) instanceof DimensionType)) continue;
                dimensions = (Hashtable)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        HashMap<Integer, String> otgDims = new HashMap<Integer, String>();
        for (int i = 2; i < 1024; ++i) {
            if (!dimensions.containsKey(i) || !((DimensionType)dimensions.get(i)).func_186067_c().equals("OTG")) continue;
            otgDims.put(new Integer(((DimensionType)dimensions.get(i)).func_186068_a()), ((DimensionType)dimensions.get(i)).func_186065_b());
        }
        return otgDims;
    }

    public static void ReAddTCDims() {
        Hashtable dimensions = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Object value;
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Hashtable.class)) continue;
                field.setAccessible(true);
                Hashtable fieldAsHashTable = (Hashtable)field.get(new DimensionManager());
                if (fieldAsHashTable.values().size() <= 0 || !((value = fieldAsHashTable.values().toArray()[0]) instanceof DimensionType)) continue;
                dimensions = (Hashtable)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (Map.Entry<Integer, DimensionType> oldDim : oldDims.entrySet()) {
            dimensions.put(oldDim.getKey(), oldDim.getValue());
        }
        oldDims = new Hashtable();
    }
}

