/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.google.common.base.Function;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.events.EventPriority;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.TXCommandHandler;
import com.khorn.terraincontrol.forge.TXDimensionManager;
import com.khorn.terraincontrol.forge.TXWorldType;
import com.khorn.terraincontrol.forge.WorldLoader;
import com.khorn.terraincontrol.forge.client.events.ClientNetworkEventListener;
import com.khorn.terraincontrol.forge.client.events.DimensionSyncChannelHandler;
import com.khorn.terraincontrol.forge.events.BiomeColorsListener;
import com.khorn.terraincontrol.forge.events.ChunkEventListener;
import com.khorn.terraincontrol.forge.events.EntityTravelToDimensionListener;
import com.khorn.terraincontrol.forge.events.KeyBoardEventListener;
import com.khorn.terraincontrol.forge.events.PlayerTracker;
import com.khorn.terraincontrol.forge.events.RightClickBlockListener;
import com.khorn.terraincontrol.forge.events.SaplingListener;
import com.khorn.terraincontrol.forge.events.ServerEventListener;
import com.khorn.terraincontrol.forge.events.TCToForgeEventConverter;
import com.khorn.terraincontrol.forge.events.WorldListener;
import com.khorn.terraincontrol.forge.generator.Cartographer;
import com.khorn.terraincontrol.forge.generator.ForgeVanillaBiomeGenerator;
import com.khorn.terraincontrol.forge.generator.structure.TXRareBuildingStart;
import com.khorn.terraincontrol.forge.generator.structure.TXVillageStart;
import com.khorn.terraincontrol.forge.gui.GuiHandler;
import com.khorn.terraincontrol.logging.LogMarker;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.util.EnumMap;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="openterraingenerator", name="Open Terrain Generator", acceptableRemoteVersions="*", version="v20", acceptedMinecraftVersions="[1.10.2]")
public class TXPlugin {
    private WorldLoader worldLoader;
    public static TXWorldType txWorldType;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    public TXPlugin() {
        TerrainControl.isForge = true;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        File configsDir = new File(Loader.instance().getConfigDir(), "OpenTerrainGenerator");
        this.worldLoader = new WorldLoader(configsDir);
        MinecraftForge.EVENT_BUS.register((Object)new WorldListener());
        txWorldType = new TXWorldType(this.worldLoader);
        ForgeEngine engine = new ForgeEngine(this.worldLoader);
        TerrainControl.setEngine(engine);
        engine.getBiomeModeManager().register("Default", ForgeVanillaBiomeGenerator.class);
        MapGenStructureIO.func_143034_b(TXRareBuildingStart.class, (String)"OTGTemple");
        MapGenStructureIO.func_143034_b(TXVillageStart.class, (String)"OTGVillage");
        if (event.getSide() == Side.CLIENT) {
            ClientNetworkEventListener networkHandler = new ClientNetworkEventListener(this.worldLoader);
            FMLEventChannel eventDrivenChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("OpenTerrainGenerator");
            eventDrivenChannel.register((Object)networkHandler);
            MinecraftForge.EVENT_BUS.register((Object)networkHandler);
        }
        channels = NetworkRegistry.INSTANCE.newChannel("OTGChannel", new ChannelHandler[]{DimensionSyncChannelHandler.instance});
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        SaplingListener saplingListener = new SaplingListener();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)saplingListener);
        MinecraftForge.EVENT_BUS.register((Object)saplingListener);
        Function<Biome, BiomeConfig> getBiomeConfig = new Function<Biome, BiomeConfig>(){

            public BiomeConfig apply(Biome input) {
                LocalBiome biome = null;
                try {
                    biome = TerrainControl.getBiomeAllWorlds(input.func_185359_l());
                }
                catch (BiomeNotFoundException biomeNotFoundException) {
                    // empty catch block
                }
                if (biome == null) {
                    return null;
                }
                return biome.getBiomeConfig();
            }
        };
        MinecraftForge.EVENT_BUS.register((Object)new BiomeColorsListener(getBiomeConfig));
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventListener());
        MinecraftForge.EVENT_BUS.register((Object)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeyBoardEventListener());
        engine.registerEventHandler(new TCToForgeEventConverter(), EventPriority.CANCELABLE);
        MinecraftForge.EVENT_BUS.register((Object)new RightClickBlockListener());
        MinecraftForge.EVENT_BUS.register((Object)new EntityTravelToDimensionListener());
        MinecraftForge.EVENT_BUS.register((Object)new ChunkEventListener());
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TXCommandHandler());
        WorldServer overWorld = DimensionManager.getWorld((int)0);
        if (overWorld.func_72912_H().func_76067_t() instanceof TXWorldType && !overWorld.field_72995_K) {
            TXDimensionManager.ReAddTCDims();
            TXDimensionManager.LoadCustomDimensionData();
            Cartographer.CreateCartographerDimension();
            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld((World)overWorld);
            WorldConfig worldConfig = forgeWorld.getConfigs().getWorldConfig();
            for (String dimName : worldConfig.Dimensions) {
                if (TXDimensionManager.isDimensionNameRegistered(dimName)) continue;
                File worldConfigFile = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds/" + dimName + "/WorldConfig.ini");
                if (!worldConfigFile.exists()) {
                    TerrainControl.log(LogMarker.ERROR, "Could not create dimension \"" + dimName + "\", mods/OpenTerrainGenerator/worlds/" + dimName + " could not be found or does not contain a WorldConfig.ini file.", new Object[0]);
                    continue;
                }
                TXDimensionManager.createDimension(dimName, false, true, false);
            }
            TXDimensionManager.SaveDimensionData();
        }
    }
}

