/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.google.common.base.Preconditions;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.WorldLoader;
import com.khorn.terraincontrol.forge.generator.ForgeVanillaBiomeGenerator;
import com.khorn.terraincontrol.forge.generator.TXBiomeProvider;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.util.helpers.ReflectionHelper;
import java.io.File;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TXWorldType
extends WorldType {
    public final WorldLoader worldLoader;

    public TXWorldType(WorldLoader worldLoader) {
        super("OTG");
        this.worldLoader = (WorldLoader)Preconditions.checkNotNull((Object)worldLoader, (Object)"worldLoader");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_151357_h() {
        return true;
    }

    public BiomeProvider getBiomeProvider(World mcWorld) {
        if (mcWorld.field_72995_K) {
            return super.getBiomeProvider(mcWorld);
        }
        File worldDirectory = new File(TerrainControl.getEngine().getTCDataFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName());
        if (!worldDirectory.exists()) {
            System.out.println("OpenTerrainGenerator: settings does not exist, creating defaults");
            if (!worldDirectory.mkdirs()) {
                System.out.println("OpenTerrainGenerator: cant create folder " + worldDirectory.getAbsolutePath());
            }
        }
        File worldObjectsDir = new File(TerrainControl.getEngine().getTCDataFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName() + File.separator + "WorldObjects");
        worldObjectsDir.mkdirs();
        File worldBiomesDir = new File(TerrainControl.getEngine().getTCDataFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName() + File.separator + "WorldBiomes");
        worldBiomesDir.mkdirs();
        ForgeWorld world = this.worldLoader.getOrCreateForgeWorld(mcWorld);
        if (world == null) {
            return super.getBiomeProvider(mcWorld);
        }
        Class<? extends BiomeGenerator> biomeGenClass = world.getConfigs().getWorldConfig().biomeMode;
        BiomeGenerator biomeGenerator = TerrainControl.getBiomeModeManager().createCached(biomeGenClass, world);
        BiomeProvider biomeProvider = this.createBiomeProvider(world, biomeGenerator);
        world.setBiomeGenerator(biomeGenerator);
        return biomeProvider;
    }

    private BiomeProvider createBiomeProvider(ForgeWorld world, BiomeGenerator biomeGenerator) {
        BiomeProvider biomeProvider;
        World mcWorld = world.getWorld();
        if (biomeGenerator instanceof ForgeVanillaBiomeGenerator) {
            biomeProvider = mcWorld.field_73011_w.func_177499_m();
            ((ForgeVanillaBiomeGenerator)biomeGenerator).setBiomeProvider(biomeProvider);
        } else {
            biomeProvider = new TXBiomeProvider(world, biomeGenerator);
            ReflectionHelper.setValueInFieldOfType(mcWorld.field_73011_w, BiomeProvider.class, biomeProvider);
        }
        return biomeProvider;
    }

    public IChunkGenerator getChunkGenerator(World mcWorld, String generatorOptions) {
        ForgeWorld world = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(mcWorld);
        if (world != null && world.getConfigs().getWorldConfig().ModeTerrain != WorldConfig.TerrainMode.Default) {
            return world.getChunkGenerator();
        }
        return super.getChunkGenerator(mcWorld, generatorOptions);
    }

    public int getMinimumSpawnHeight(World mcWorld) {
        ForgeWorld world = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(mcWorld);
        if (world == null) {
            return 64;
        }
        return world.getConfigs().getWorldConfig().waterLevelMax;
    }
}

