/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.standard.WorldStandardValues;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.TXPlugin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderTX
extends WorldProvider {
    public WorldConfig config = null;
    DimensionType dimType = null;

    private WorldConfig GetWorldConfig() {
        ForgeWorld forgeWorld;
        if (this.config == null && (forgeWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(this.field_76579_a)) != null) {
            this.config = forgeWorld.getConfigs().getWorldConfig();
        }
        if (this.config == null) {
            throw new RuntimeException();
        }
        return this.config;
    }

    public String getWelcomeMessage() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.welcomeMessage : WorldStandardValues.welcomeMessage.getDefaultValue();
    }

    public String getDepartMessage() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.departMessage : WorldStandardValues.departMessage.getDefaultValue();
    }

    public DimensionType func_186058_p() {
        String className;
        StackTraceElement[] stackTrace;
        if (this.dimType == null) {
            this.dimType = DimensionManager.getProviderType((int)this.field_76579_a.field_73011_w.getDimension());
        }
        if ((stackTrace = Thread.currentThread().getStackTrace()).length > 2 && (className = stackTrace[2].getClassName().toLowerCase()).contains("customcolors")) {
            return DimensionType.OVERWORLD;
        }
        return this.dimType;
    }

    protected void func_76572_b() {
        this.field_76578_c = TXPlugin.txWorldType.getBiomeProvider(this.field_76579_a);
    }

    public IChunkGenerator func_186060_c() {
        return TXPlugin.txWorldType.getChunkGenerator(this.field_76579_a, this.field_76579_a.func_72912_H().func_82571_y());
    }

    public boolean func_76569_d() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.isSurfaceWorld : WorldStandardValues.isSurfaceWorld.getDefaultValue();
    }

    public boolean func_76566_a(int x, int z) {
        return false;
    }

    public BlockPos getRandomizedSpawnPoint() {
        return super.getRandomizedSpawnPoint();
    }

    public boolean func_76567_e() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.canRespawnHere : WorldStandardValues.canRespawnHere.getDefaultValue();
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return super.getRespawnDimension(player);
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.shouldMapSpin : super.shouldMapSpin(entity, x, y, z);
    }

    public boolean isDaytime() {
        return super.isDaytime();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getActualHeight() {
        return super.getActualHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null && worldConfig.useCustomFogColor ? new Vec3d(worldConfig.fogColorRed, worldConfig.fogColorGreen, worldConfig.fogColorBlue) : super.func_76562_b(p_76562_1_, p_76562_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.doesXZShowFog : WorldStandardValues.doesXZShowFog.getDefaultValue();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_76565_k() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.voidFogYFactor : WorldStandardValues.voidFogYFactor.getDefaultValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.isSkyColored : WorldStandardValues.isSkyColored.getDefaultValue();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return super.getSkyColor(cameraEntity, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        return super.getCloudColor(partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? (float)worldConfig.cloudHeight : (float)WorldStandardValues.cloudHeight.getDefaultValue().intValue();
    }

    public int func_76557_i() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.waterLevelMax + 1 : this.field_76579_a.func_181545_F() + 1;
    }

    public boolean func_186056_c(int x, int z) {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.canDropChunk : WorldStandardValues.canDropChunk.getDefaultValue();
    }

    protected void func_76556_a() {
        WorldConfig worldConfig = this.GetWorldConfig();
        if (worldConfig != null && worldConfig.isNightWorld) {
            for (int i = 0; i <= 15; ++i) {
                float f1 = 0.0f;
                this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 0.9f + 0.1f;
            }
        } else {
            super.func_76556_a();
        }
    }

    public WorldBorder func_177501_r() {
        return super.func_177501_r();
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        WorldConfig worldConfig = this.GetWorldConfig();
        if (worldConfig != null && worldConfig.isNightWorld) {
            return 0.49837038f;
        }
        return super.func_76563_a(worldTime, partialTicks);
    }

    public double getHorizon() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? (double)worldConfig.waterLevelMax : (double)this.field_76579_a.func_181545_F();
    }

    public boolean canDoLightning(Chunk chunk) {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.canDoLightning : WorldStandardValues.canDoLightning.getDefaultValue();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.canDoRainSnowIce : WorldStandardValues.canDoRainSnowIce.getDefaultValue();
    }

    public boolean func_177500_n() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? worldConfig.doesWaterVaporize : WorldStandardValues.doesWaterVaporize.getDefaultValue();
    }

    public boolean func_177495_o() {
        WorldConfig worldConfig = this.GetWorldConfig();
        return worldConfig != null ? !worldConfig.hasSkyLight : WorldStandardValues.hasSkyLight.getDefaultValue() == false;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return super.getSkyRenderer();
    }
}

