/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.TXDimensionManager;
import com.khorn.terraincontrol.forge.TXWorldType;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldListener {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldLoad(WorldEvent.Load event) {
        for (LocalWorld localWorld : ((ForgeEngine)TerrainControl.getEngine()).getAllWorlds()) {
            ForgeWorld forgeWorld = (ForgeWorld)localWorld;
            if (forgeWorld.getWorld() != null || forgeWorld.clientDimensionId != event.getWorld().field_73011_w.getDimension()) continue;
            forgeWorld.provideClientWorld(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().SavePreGeneratorData(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            World mcWorld = event.getWorld();
            if (event.getWorld().func_175624_G() instanceof TXWorldType) {
                ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(mcWorld);
                if (forgeWorld == null) {
                    return;
                }
                MinecraftServer mcServer = mcWorld.func_73046_m();
                if (mcServer == null) {
                    mcServer = this.getClientServer();
                }
                boolean serverStopping = !mcServer.func_71278_l();
                int dimId = event.getWorld().field_73011_w.getDimension();
                if (dimId != -1 && dimId != 1) {
                    if ((ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(event.getWorld()) != null) {
                        ((TXWorldType)event.getWorld().func_175624_G()).worldLoader.unloadWorld(event.getWorld(), false);
                    }
                    if (serverStopping) {
                        TXDimensionManager.UnloadCustomDimensionData(mcWorld.field_73011_w.getDimension());
                        forgeWorld.unRegisterBiomes();
                        if (mcWorld.field_73011_w.getDimension() == 0) {
                            ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().shutDown(mcWorld);
                            for (ForgeWorld unloadedWorld : ((ForgeEngine)TerrainControl.getEngine()).getUnloadedWorlds()) {
                                if (unloadedWorld.getWorld() == mcWorld) continue;
                                TXDimensionManager.UnloadCustomDimensionData(unloadedWorld.getWorld().field_73011_w.getDimension());
                                unloadedWorld.unRegisterBiomes();
                            }
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MinecraftServer getClientServer() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    @SubscribeEvent
    public void onCreateWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        LocalWorld world = ((ForgeEngine)TerrainControl.getEngine()).getWorld(event.getWorld());
        if (world != null && (((ForgeEngine)TerrainControl.getEngine()).getCartographerEnabled() || world.getConfigs().getWorldConfig().WorldBorderRadius > 0 || world.getConfigs().getWorldConfig().BO3AtSpawn != null && world.getConfigs().getWorldConfig().BO3AtSpawn.trim().length() > 0)) {
            event.setCanceled(true);
        }
    }
}

