/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.generator.ForgeChunkBuffer;
import com.khorn.terraincontrol.forge.generator.structure.RareBuildingGen;
import com.khorn.terraincontrol.generator.ChunkProviderTC;
import com.khorn.terraincontrol.generator.ObjectSpawner;
import com.khorn.terraincontrol.generator.biome.OutputType;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import java.util.List;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;

public class ChunkProvider
implements IChunkGenerator {
    private ForgeWorld world;
    private World worldHandle;
    private boolean TestMode = false;
    private ChunkProviderTC generator;
    private ObjectSpawner spawner;
    private int[] biomeIntArray;

    public ChunkProvider(ForgeWorld _world) {
        this.world = _world;
        this.worldHandle = _world.getWorld();
        this.TestMode = this.world.getConfigs().getWorldConfig().ModeTerrain == WorldConfig.TerrainMode.TerrainTest;
        this.generator = new ChunkProviderTC(this.world.getConfigs(), this.world);
        this.spawner = new ObjectSpawner(this.world.getConfigs(), this.world);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        Chunk chunk = new Chunk(this.worldHandle, chunkX, chunkZ);
        if (this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), false)) {
            ForgeChunkBuffer chunkBuffer = new ForgeChunkBuffer(chunkCoord);
            this.generator.generate(chunkBuffer);
            chunk = chunkBuffer.toChunk(this.worldHandle);
            this.fillBiomeArray(chunk);
            chunk.func_76603_b();
        }
        return chunk;
    }

    private void fillBiomeArray(Chunk chunk) {
        byte[] chunkBiomeArray = chunk.func_76605_m();
        ConfigProvider configProvider = this.world.getConfigs();
        this.biomeIntArray = this.world.getBiomeGenerator().getBiomes(this.biomeIntArray, chunk.field_76635_g * 16, chunk.field_76647_h * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            int generationId = this.biomeIntArray[i];
            LocalBiome biome = TerrainControl.isForge ? TerrainControl.getBiomeAllWorlds(generationId) : configProvider.getBiomeByIdOrNull(generationId);
            chunkBiomeArray[i] = (byte)biome.getIds().getSavedId();
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        if (this.TestMode || !this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), true)) {
            return;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        BlockSand.field_149832_M = true;
        BlockGravel.field_149832_M = true;
        this.spawner.populate(chunkCoord);
        BlockSand.field_149832_M = false;
        BlockGravel.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType paramaca, BlockPos blockPos) {
        WorldConfig worldConfig = this.world.getConfigs().getWorldConfig();
        Biome biomeBase = this.worldHandle.getBiomeForCoordsBody(blockPos);
        if (worldConfig.rareBuildingsEnabled && paramaca == EnumCreatureType.MONSTER && ((RareBuildingGen)((Object)this.world.rareBuildingGen)).isSwampHutAtLocation(blockPos)) {
            return ((RareBuildingGen)((Object)this.world.rareBuildingGen)).getMonsterSpawnList();
        }
        if (worldConfig.oceanMonumentsEnabled && paramaca == EnumCreatureType.MONSTER && this.world.oceanMonumentGen.isPositionInStructure(this.worldHandle, blockPos)) {
            return this.world.oceanMonumentGen.getMonsterSpawnList();
        }
        return biomeBase.func_76747_a(paramaca);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos blockPos) {
        if ("Stronghold".equals(structureName) && this.world.strongholdGen != null) {
            return this.world.strongholdGen.func_180706_b(worldIn, blockPos);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int chunkX, int chunkZ) {
        WorldConfig worldConfig = this.world.getConfigs().getWorldConfig();
        if (worldConfig.mineshaftsEnabled) {
            this.world.mineshaftGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled) {
            this.world.villageGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.strongholdsEnabled) {
            this.world.strongholdGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.world.rareBuildingGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.world.netherFortressGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.world.oceanMonumentGen.generate(this.world.getWorld(), chunkX, chunkZ, null);
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }
}

