/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator.structure;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.forge.ForgeBiome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.StructureStart;

public class TXOceanMonumentGen
extends MapGenStructure {
    private int gridSize;
    private int randomOffset;
    private final List<Biome> monumentSpawnBiomes;
    private final List<Biome.SpawnListEntry> mobList;

    public TXOceanMonumentGen(ConfigProvider settings) {
        this.gridSize = settings.getWorldConfig().oceanMonumentGridSize;
        this.randomOffset = settings.getWorldConfig().oceanMonumentRandomOffset;
        this.monumentSpawnBiomes = new ArrayList<Biome>();
        this.mobList = Arrays.asList(new Biome.SpawnListEntry(EntityGuardian.class, 1, 2, 4));
        for (LocalBiome biome : settings.getBiomeArray()) {
            if (biome == null || !biome.getBiomeConfig().oceanMonumentsEnabled) continue;
            this.monumentSpawnBiomes.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int p_75047_1_, int p_75047_2_) {
        int k = p_75047_1_;
        int l = p_75047_2_;
        if (p_75047_1_ < 0) {
            p_75047_1_ -= this.gridSize - 1;
        }
        if (p_75047_2_ < 0) {
            p_75047_2_ -= this.gridSize - 1;
        }
        int i1 = p_75047_1_ / this.gridSize;
        int j1 = p_75047_2_ / this.gridSize;
        Random random = this.field_75039_c.func_72843_D(i1, j1, 10387313);
        i1 *= this.gridSize;
        j1 *= this.gridSize;
        if (k == (i1 += (random.nextInt(this.randomOffset + 1) + random.nextInt(this.randomOffset + 1)) / 2) && l == (j1 += (random.nextInt(this.randomOffset + 1) + random.nextInt(this.randomOffset + 1)) / 2)) {
            BiomeProvider biomeProvider = this.field_75039_c.func_72959_q();
            if (biomeProvider.func_180300_a(new BlockPos(k * 16 + 8, 64, l * 16 + 8), (Biome)null) != Biomes.field_150575_M) {
                return false;
            }
            boolean flag = this.field_75039_c.func_72959_q().func_76940_a(k * 16 + 8, l * 16 + 8, 16, this.monumentSpawnBiomes);
            if (flag) {
                return true;
            }
        }
        return false;
    }

    public String func_143025_a() {
        return "Monument";
    }

    protected StructureStart func_75049_b(int p_75049_1_, int p_75049_2_) {
        return new StructureOceanMonument.StartMonument(this.field_75039_c, this.field_75038_b, p_75049_1_, p_75049_2_);
    }

    public List<Biome.SpawnListEntry> getMonsterSpawnList() {
        return this.mobList;
    }
}

