/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.generator.biome.OutputType;
import com.khorn.terraincontrol.generator.noise.NoiseGeneratorOldOctaves;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.util.Random;

public class OldBiomeGenerator
extends BiomeGenerator {
    private NoiseGeneratorOldOctaves temperatureGenerator1;
    private NoiseGeneratorOldOctaves wetnessGenerator;
    private NoiseGeneratorOldOctaves temperatureGenerator2;
    public double[] oldTemperature1;
    public double[] oldWetness;
    private double[] oldTemperature2;
    private static int[] biomeDiagram = new int[4096];
    private static boolean hasGeneratedBiomeDiagram;

    public OldBiomeGenerator(LocalWorld world) {
        super(world);
        this.temperatureGenerator1 = new NoiseGeneratorOldOctaves(new Random(world.getSeed() * 9871L), 4);
        this.wetnessGenerator = new NoiseGeneratorOldOctaves(new Random(world.getSeed() * 39811L), 4);
        this.temperatureGenerator2 = new NoiseGeneratorOldOctaves(new Random(world.getSeed() * 543321L), 2);
        if (!hasGeneratedBiomeDiagram) {
            hasGeneratedBiomeDiagram = true;
            OldBiomeGenerator.generateBiomeDiagram();
        }
    }

    public int[] getBiomes(int[] paramArrayOfBiomeBase, int x, int z, int xSize, int zSize) {
        if (paramArrayOfBiomeBase == null || paramArrayOfBiomeBase.length < xSize * zSize) {
            paramArrayOfBiomeBase = new int[xSize * zSize];
        }
        WorldConfig worldConfig = this.world.getConfigs().getWorldConfig();
        this.oldTemperature1 = this.temperatureGenerator1.a(this.oldTemperature1, x, z, xSize, xSize, 0.025000000372529 / worldConfig.oldBiomeSize, 0.025000000372529 / worldConfig.oldBiomeSize, 0.25);
        this.oldWetness = this.wetnessGenerator.a(this.oldWetness, x, z, xSize, xSize, 0.0500000007450581 / worldConfig.oldBiomeSize, 0.0500000007450581 / worldConfig.oldBiomeSize, 0.3333333333333333);
        this.oldTemperature2 = this.temperatureGenerator2.a(this.oldTemperature2, x, z, xSize, xSize, 0.25 / worldConfig.oldBiomeSize, 0.25 / worldConfig.oldBiomeSize, 0.5882352941176471);
        int i = 0;
        for (int j = 0; j < xSize; ++j) {
            for (int k = 0; k < zSize; ++k) {
                double d1 = this.oldTemperature2[i] * 1.1 + 0.5;
                double d2 = 0.01;
                double d3 = 1.0 - d2;
                double d4 = (this.oldTemperature1[i] * 0.15 + 0.7) * d3 + d1 * d2;
                d2 = 0.002;
                d3 = 1.0 - d2;
                double d5 = (this.oldWetness[i] * 0.15 + 0.5) * d3 + d1 * d2;
                if ((d4 = 1.0 - (1.0 - d4) * (1.0 - d4)) < worldConfig.minTemperature) {
                    d4 = worldConfig.minTemperature;
                }
                if (d5 < worldConfig.minMoisture) {
                    d5 = worldConfig.minMoisture;
                }
                if (d4 > worldConfig.maxTemperature) {
                    d4 = worldConfig.maxTemperature;
                }
                if (d5 > worldConfig.maxMoisture) {
                    d5 = worldConfig.maxMoisture;
                }
                this.oldTemperature1[i] = d4;
                this.oldWetness[i] = d5;
                paramArrayOfBiomeBase[i++] = OldBiomeGenerator.getBiomeFromDiagram(d4, d5);
            }
        }
        return paramArrayOfBiomeBase;
    }

    @Override
    public int[] getBiomes(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        return this.getBiomes(biomeArray, x, z, x_size, z_size);
    }

    private static int getBiomeFromDiagram(double temp, double rain) {
        int i = (int)(temp * 63.0);
        int j = (int)(rain * 63.0);
        return biomeDiagram[i + j * 64];
    }

    private static void generateBiomeDiagram() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                OldBiomeGenerator.biomeDiagram[i + j * 64] = OldBiomeGenerator.generatePositionOnBiomeDiagram((float)i / 63.0f, (float)j / 63.0f);
            }
        }
    }

    private static int generatePositionOnBiomeDiagram(double paramFloat1, double paramFloat2) {
        paramFloat2 *= paramFloat1;
        if (paramFloat1 < (double)0.1f) {
            return DefaultBiome.PLAINS.Id;
        }
        if (paramFloat2 < (double)0.2f) {
            if (paramFloat1 < 0.5) {
                return DefaultBiome.PLAINS.Id;
            }
            if (paramFloat1 < (double)0.95f) {
                return DefaultBiome.PLAINS.Id;
            }
            return DefaultBiome.DESERT.Id;
        }
        if (paramFloat2 > 0.5 && paramFloat1 < (double)0.7f) {
            return DefaultBiome.SWAMPLAND.Id;
        }
        if (paramFloat1 < 0.5) {
            return DefaultBiome.TAIGA.Id;
        }
        if (paramFloat1 < (double)0.97f) {
            if (paramFloat2 < (double)0.35f) {
                return DefaultBiome.TAIGA.Id;
            }
            return DefaultBiome.FOREST.Id;
        }
        if (paramFloat2 < (double)0.45f) {
            return DefaultBiome.PLAINS.Id;
        }
        if (paramFloat2 < (double)0.9f) {
            return DefaultBiome.FOREST.Id;
        }
        return DefaultBiome.FOREST.Id;
    }

    @Override
    public boolean canGenerateUnZoomed() {
        return false;
    }
}

