/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.configuration.BiomeGroup;
import com.khorn.terraincontrol.configuration.BiomeGroupManager;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.Layer;
import java.util.Map;
import java.util.SortedMap;

public class LayerBiomeGroups
extends Layer {
    private BiomeGroupManager biomeGroupManager;
    private int depth;
    private boolean freezeGroups;

    public LayerBiomeGroups(Layer paramGenLayer, BiomeGroupManager biomeGroups, int depth, boolean freezeGroups) {
        this.child = paramGenLayer;
        this.biomeGroupManager = biomeGroups;
        this.depth = depth;
        this.freezeGroups = freezeGroups;
    }

    @Override
    public int[] getInts(ArraysCache arraysCache, int x, int z, int x_size, int z_size) {
        int[] childInts = this.child.getInts(arraysCache, x, z, x_size, z_size);
        int[] thisInts = arraysCache.getArray(x_size * z_size);
        for (int i = 0; i < z_size; ++i) {
            for (int j = 0; j < x_size; ++j) {
                this.initGroupSeed(j + x, i + z);
                int currentPiece = childInts[j + i * x_size];
                if ((currentPiece & 0x400) != 0 && (currentPiece & 0xFE000) == 0) {
                    SortedMap<Integer, BiomeGroup> possibleGroups = this.biomeGroupManager.getGroupDepthMap(this.depth);
                    int newGroupRarity = this.nextGroupInt(BiomeGroupManager.getMaxRarityFromPossibles(possibleGroups) * 10000);
                    for (Map.Entry<Integer, BiomeGroup> group : possibleGroups.entrySet()) {
                        if (newGroupRarity / 10000 >= group.getKey()) continue;
                        if (group.getValue() == null) break;
                        currentPiece |= group.getValue().getGroupId() << 13 | (group.getValue().isColdGroup() && this.freezeGroups ? 4096 : 0);
                        break;
                    }
                }
                thisInts[j + i * x_size] = currentPiece;
            }
        }
        return thisInts;
    }
}

